/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.feature;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import vazkii.arl.block.BlockMod;
import vazkii.arl.block.BlockModSlab;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.ModIntegrationHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.building.block.BlockWorldStoneBricks;
import vazkii.quark.building.block.BlockWorldStoneCarved;
import vazkii.quark.building.block.slab.BlockVanillaSlab;
import vazkii.quark.building.block.stairs.BlockVanillaStairs;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.feature.Basalt;
import vazkii.quark.world.feature.RevampStoneGen;

public class WorldStoneBricks
extends Feature {
    public static BlockMod world_stone_bricks;
    public static BlockMod world_stone_chiseled;
    public static final BlockModSlab[] slabs;
    public static boolean enableStairsAndSlabs;
    public static boolean enableWalls;

    @Override
    public void setupConfig() {
        enableStairsAndSlabs = this.loadPropBool("Enable stairs and slabs", "", true) && GlobalConfig.enableVariants;
        enableWalls = this.loadPropBool("Enable walls", "", true) && GlobalConfig.enableVariants;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        world_stone_bricks = new BlockWorldStoneBricks();
        world_stone_chiseled = new BlockWorldStoneCarved();
        if (enableStairsAndSlabs) {
            for (BlockWorldStoneBricks.Variants variant : BlockWorldStoneBricks.Variants.values()) {
                if (!variant.isEnabled()) continue;
                IBlockState state = world_stone_bricks.func_176223_P().func_177226_a(world_stone_bricks.getVariantProp(), (Comparable)((Object)variant));
                BlockModStairs.initStairs((Block)world_stone_bricks, (int)variant.ordinal(), (BlockStairs)new BlockVanillaStairs(variant.func_176610_l() + "_stairs", state));
                WorldStoneBricks.slabs[variant.ordinal()] = BlockVanillaSlab.initSlab((Block)world_stone_bricks, variant.ordinal(), state, variant.func_176610_l() + "_slab");
            }
        }
        if (enableWalls) {
            for (BlockWorldStoneBricks.Variants variant : BlockWorldStoneBricks.Variants.values()) {
                if (!variant.isEnabled()) continue;
                world_stone_bricks.func_176223_P().func_177226_a(world_stone_bricks.getVariantProp(), (Comparable)((Object)variant));
                String name = variant.func_176610_l();
                VanillaWalls.add(name, (Block)world_stone_bricks, variant.ordinal(), true);
            }
        }
    }

    @Override
    public void postPreInit() {
        for (int i = 0; i < 3; ++i) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_bricks, (int)4, (int)i), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), ProxyRegistry.newStack((Block)Blocks.field_150348_b, (int)1, (int)(i * 2 + 2))});
            if (enableStairsAndSlabs) {
                RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)1, (int)i), (Object[])new Object[]{"S", "S", Character.valueOf('S'), ProxyRegistry.newStack((Block)slabs[i])});
                continue;
            }
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)8, (int)i), (Object[])new Object[]{"SSS", "S S", "SSS", Character.valueOf('S'), ProxyRegistry.newStack((Block)world_stone_bricks, (int)1, (int)i)});
        }
        if (BlockWorldStoneBricks.Variants.STONE_BASALT_BRICKS.isEnabled()) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_bricks, (int)4, (int)3), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), ProxyRegistry.newStack((Block)Basalt.basalt, (int)1, (int)1)});
            if (enableStairsAndSlabs) {
                RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)1, (int)3), (Object[])new Object[]{"S", "S", Character.valueOf('S'), ProxyRegistry.newStack((Block)slabs[3])});
            } else {
                RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)8, (int)3), (Object[])new Object[]{"SSS", "S S", "SSS", Character.valueOf('S'), ProxyRegistry.newStack((Block)world_stone_bricks, (int)1, (int)3)});
            }
        }
        if (BlockWorldStoneBricks.Variants.STONE_MARBLE_BRICKS.isEnabled()) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_bricks, (int)4, (int)4), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), ProxyRegistry.newStack((Block)RevampStoneGen.marble, (int)1, (int)1)});
            if (enableStairsAndSlabs) {
                RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)1, (int)4), (Object[])new Object[]{"S", "S", Character.valueOf('S'), ProxyRegistry.newStack((Block)slabs[4])});
            } else {
                RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)8, (int)4), (Object[])new Object[]{"SSS", "S S", "SSS", Character.valueOf('S'), ProxyRegistry.newStack((Block)world_stone_bricks, (int)1, (int)4)});
            }
        }
        if (BlockWorldStoneBricks.Variants.STONE_LIMESTONE_BRICKS.isEnabled()) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_bricks, (int)4, (int)5), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), ProxyRegistry.newStack((Block)RevampStoneGen.limestone, (int)1, (int)1)});
            if (enableStairsAndSlabs) {
                RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)1, (int)5), (Object[])new Object[]{"S", "S", Character.valueOf('S'), ProxyRegistry.newStack((Block)slabs[5])});
            } else {
                RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)8, (int)5), (Object[])new Object[]{"SSS", "S S", "SSS", Character.valueOf('S'), ProxyRegistry.newStack((Block)world_stone_bricks, (int)1, (int)5)});
            }
        }
    }

    @Override
    public void init() {
        ModIntegrationHandler.registerChiselVariant("granite", new ItemStack((Block)world_stone_bricks, 1, 0));
        ModIntegrationHandler.registerChiselVariant("diorite", new ItemStack((Block)world_stone_bricks, 1, 1));
        ModIntegrationHandler.registerChiselVariant("andesite", new ItemStack((Block)world_stone_bricks, 1, 2));
        if (BlockWorldStoneBricks.Variants.STONE_BASALT_BRICKS.isEnabled()) {
            ModIntegrationHandler.registerChiselVariant("basalt", new ItemStack((Block)world_stone_bricks, 1, 3));
        }
        if (BlockWorldStoneBricks.Variants.STONE_MARBLE_BRICKS.isEnabled()) {
            ModIntegrationHandler.registerChiselVariant("marble", new ItemStack((Block)world_stone_bricks, 1, 4));
        }
        if (BlockWorldStoneBricks.Variants.STONE_LIMESTONE_BRICKS.isEnabled()) {
            ModIntegrationHandler.registerChiselVariant("limestone", new ItemStack((Block)world_stone_bricks, 1, 5));
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    static {
        slabs = new BlockVanillaSlab[BlockWorldStoneBricks.Variants.values().length];
    }
}

