/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.api.IDropoffManager;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.network.message.MessageDisableDropoffClient;
import vazkii.quark.management.feature.ChestButtons;
import vazkii.quark.management.feature.FavoriteItems;
import vazkii.quark.management.feature.StoreToChests;

public final class DropoffHandler {
    public static void dropoff(EntityPlayer player, boolean smart, boolean useContainer) {
        if (!ModuleLoader.isFeatureEnabled(useContainer ? ChestButtons.class : StoreToChests.class) || player.func_175149_v()) {
            return;
        }
        if (!useContainer && !player.func_130014_f_().func_72912_H().func_82574_x().func_82766_b("quark_allowDropoff")) {
            DropoffHandler.disableClientDropoff(player);
            return;
        }
        new Dropoff(player, smart, useContainer).execute();
    }

    public static void restock(EntityPlayer player, boolean filtered) {
        if (!ModuleLoader.isFeatureEnabled(ChestButtons.class) || player.func_175149_v()) {
            return;
        }
        new Restock(player, filtered).execute();
    }

    public static void disableClientDropoff(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            NetworkHandler.INSTANCE.sendTo((IMessage)new MessageDisableDropoffClient(), (EntityPlayerMP)player);
        }
    }

    public static IItemHandler getInventory(EntityPlayer player, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        boolean accept = DropoffHandler.isValidChest(player, te);
        if (accept) {
            Supplier<IItemHandler> supplier = () -> {
                IItemHandler innerRet = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (innerRet == null && te instanceof IInventory) {
                    innerRet = new InvWrapper((IInventory)te);
                }
                return innerRet;
            };
            if (IDropoffManager.hasProvider(te)) {
                return IDropoffManager.getProvider(te).getDropoffItemHandler(supplier);
            }
            return supplier.get();
        }
        return null;
    }

    private static boolean hasProvider(Object te) {
        return te instanceof TileEntity && IDropoffManager.hasProvider((TileEntity)te);
    }

    private static IDropoffManager getProvider(Object te) {
        return IDropoffManager.getProvider((TileEntity)te);
    }

    private static boolean accepts(Object te, EntityPlayer player) {
        if (DropoffHandler.hasProvider(te)) {
            return DropoffHandler.getProvider(te).acceptsDropoff(player);
        }
        return false;
    }

    public static boolean isValidChest(EntityPlayer player, TileEntity te) {
        boolean accept = DropoffHandler.accepts(te, player);
        if (!accept) {
            accept = ChestButtons.overriddenDropoff(te);
        }
        if (te instanceof IInventory) {
            accept = accept && ((IInventory)te).func_70300_a(player);
        }
        return accept;
    }

    public static boolean isValidChest(EntityPlayer player, IInventory te) {
        if (te instanceof TileEntity) {
            return DropoffHandler.isValidChest(player, (TileEntity)te);
        }
        return DropoffHandler.accepts(te, player) && te.func_70300_a(player);
    }

    public static boolean isValidChest(EntityPlayer player, IItemHandler te) {
        return DropoffHandler.accepts(te, player);
    }

    public static interface DropoffPredicate {
        public boolean apply(ItemStack var1, IItemHandler var2);
    }

    public static class ContainerWrapper
    extends InvWrapper {
        private final Container container;

        public static IItemHandler provideWrapper(Slot slot, Container container) {
            if (slot instanceof SlotItemHandler) {
                IItemHandler handler = ((SlotItemHandler)slot).getItemHandler();
                if (DropoffHandler.hasProvider(handler)) {
                    return DropoffHandler.getProvider(handler).getDropoffItemHandler(() -> handler);
                }
                return handler;
            }
            return ContainerWrapper.provideWrapper(slot.field_75224_c, container);
        }

        public static IItemHandler provideWrapper(IInventory inv, Container container) {
            if (DropoffHandler.hasProvider(inv)) {
                return DropoffHandler.getProvider(inv).getDropoffItemHandler(() -> new ContainerWrapper(inv, container));
            }
            return new ContainerWrapper(inv, container);
        }

        private ContainerWrapper(IInventory inv, Container container) {
            super(inv);
            this.container = container;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            Slot containerSlot = this.getSlot(slot);
            if (containerSlot == null || !containerSlot.func_75214_a(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        private Slot getSlot(int slot) {
            return this.container.func_75147_a(this.getInv(), slot);
        }
    }

    public static class PlayerInvWrapper
    extends InvWrapper {
        public PlayerInvWrapper(IInventory inv) {
            super(inv);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                stack = stack.func_77946_l();
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlots() {
            return super.getSlots() - 5;
        }
    }

    public static class Restock
    extends Dropoff {
        public Restock(EntityPlayer player, boolean filtered) {
            super(player, filtered, true);
        }

        @Override
        public void dropoff(DropoffPredicate predicate) {
            IItemHandler inv = (IItemHandler)((Pair)this.itemHandlers.get(0)).getLeft();
            PlayerInvWrapper playerInv = new PlayerInvWrapper((IInventory)this.player.field_71071_by);
            for (int i = inv.getSlots() - 1; i >= 0; --i) {
                ItemStack copy;
                ItemStack ret;
                ItemStack stackAt = inv.getStackInSlot(i);
                if (stackAt.func_190926_b() || ItemStack.func_77989_b((ItemStack)stackAt, (ItemStack)(ret = this.insertInHandler((IItemHandler)playerInv, copy = stackAt.func_77946_l(), predicate)))) continue;
                inv.extractItem(i, stackAt.func_77976_d(), false);
                if (ret.func_190926_b()) continue;
                inv.insertItem(i, ret, false);
            }
        }
    }

    public static class Dropoff {
        public final EntityPlayer player;
        public final boolean smart;
        public final boolean useContainer;
        public final List<Pair<IItemHandler, Double>> itemHandlers = new ArrayList<Pair<IItemHandler, Double>>();

        public Dropoff(EntityPlayer player, boolean smart, boolean useContainer) {
            this.player = player;
            this.useContainer = useContainer;
            this.smart = smart;
        }

        public void execute() {
            this.locateItemHandlers();
            if (this.itemHandlers.isEmpty()) {
                return;
            }
            if (this.smart) {
                this.smartDropoff();
            } else {
                this.roughDropoff();
            }
            this.player.field_71069_bz.func_75142_b();
            if (this.useContainer) {
                this.player.field_71070_bA.func_75142_b();
            }
        }

        public void smartDropoff() {
            this.dropoff((stack, handler) -> {
                int slots = handler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack stackAt = handler.getStackInSlot(i);
                    if (stackAt.func_190926_b()) continue;
                    boolean itemEqual = stack.func_77973_b() == stackAt.func_77973_b();
                    boolean damageEqual = stack.func_77952_i() == stackAt.func_77952_i();
                    boolean nbtEqual = ItemStack.func_77970_a((ItemStack)stackAt, (ItemStack)stack);
                    if (itemEqual && damageEqual && nbtEqual) {
                        return true;
                    }
                    if (stack.func_77981_g() || !stack.func_77984_f() || stack.func_77976_d() != 1 || !itemEqual || !nbtEqual) continue;
                    return true;
                }
                return false;
            });
        }

        public void roughDropoff() {
            this.dropoff((stack, handler) -> true);
        }

        public void locateItemHandlers() {
            if (this.useContainer) {
                Container c = this.player.field_71070_bA;
                for (Slot s : c.field_75151_b) {
                    IInventory inv = s.field_75224_c;
                    if (inv == this.player.field_71071_by) continue;
                    this.itemHandlers.add((Pair<IItemHandler, Double>)Pair.of((Object)ContainerWrapper.provideWrapper(s, c), (Object)0.0));
                    break;
                }
            } else {
                BlockPos playerPos = this.player.func_180425_c();
                int range = 6;
                for (int i = -range; i < range * 2 + 1; ++i) {
                    for (int j = -range; j < range * 2 + 1; ++j) {
                        for (int k = -range; k < range * 2 + 1; ++k) {
                            BlockPos pos = playerPos.func_177982_a(i, j, k);
                            this.findHandler(pos);
                        }
                    }
                }
                this.itemHandlers.sort(Comparator.comparingDouble(Pair::getRight));
            }
        }

        public void findHandler(BlockPos pos) {
            IItemHandler handler = DropoffHandler.getInventory(this.player, this.player.func_130014_f_(), pos);
            if (handler != null) {
                this.itemHandlers.add((Pair<IItemHandler, Double>)Pair.of((Object)handler, (Object)this.player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5)));
            }
        }

        public void dropoff(DropoffPredicate predicate) {
            InventoryPlayer inv = this.player.field_71071_by;
            for (int i = InventoryPlayer.func_70451_h(); i < inv.field_70462_a.size(); ++i) {
                ItemStack ret;
                ItemStack stackAt = inv.func_70301_a(i);
                if (stackAt.func_190926_b() || FavoriteItems.isItemFavorited(stackAt) || ItemStack.func_77989_b((ItemStack)stackAt, (ItemStack)(ret = this.insert(stackAt, predicate)))) continue;
                inv.func_70299_a(i, ret);
            }
        }

        public ItemStack insert(ItemStack stack, DropoffPredicate predicate) {
            ItemStack ret = stack.func_77946_l();
            for (Pair<IItemHandler, Double> pair : this.itemHandlers) {
                IItemHandler handler = (IItemHandler)pair.getLeft();
                ret = this.insertInHandler(handler, ret, predicate);
                if (!ret.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
            return ret;
        }

        public ItemStack insertInHandler(IItemHandler handler, ItemStack stack, DropoffPredicate predicate) {
            if (predicate.apply(stack, handler)) {
                ItemStack retStack = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                if (retStack.func_190926_b()) {
                    return retStack;
                }
                retStack = retStack.func_77946_l();
                return retStack;
            }
            return stack;
        }
    }
}

