/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.block;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockMod;
import vazkii.arl.util.RotationHandler;
import vazkii.quark.base.block.IQuarkBlock;

public class BlockRedstoneRandomizer
extends BlockMod
implements IQuarkBlock {
    protected static final AxisAlignedBB REDSTONE_DIODE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyBool POWER_LEFT = PropertyBool.func_177716_a((String)"power_left");

    public BlockRedstoneRandomizer() {
        super("redstone_randomizer", Material.field_151594_q, new String[0]);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWER_LEFT, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        boolean willBePowered;
        boolean isPowered = this.isPowered(state);
        if (isPowered != (willBePowered = this.shouldBePowered(worldIn, pos, state))) {
            IBlockState target = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(willBePowered));
            if (willBePowered) {
                target = target.func_177226_a((IProperty)POWER_LEFT, (Comparable)Boolean.valueOf(worldIn.field_73012_v.nextBoolean()));
            }
            worldIn.func_175656_a(pos, target);
        }
    }

    protected int getActiveSignal(IBlockState state, EnumFacing side) {
        return this.isPowered(state) && side == this.getOutputFace(state) ? 15 : 0;
    }

    protected void updateState(World world, BlockPos pos, IBlockState currState) {
        boolean willBePowered;
        boolean isPowered = this.isPowered(currState);
        if (isPowered != (willBePowered = this.shouldBePowered(world, pos, currState))) {
            world.func_175654_a(pos, (Block)this, 2, -1);
        }
    }

    private EnumFacing getOutputFace(IBlockState state) {
        EnumFacing target = (Boolean)state.func_177229_b((IProperty)POWER_LEFT) != false ? EnumFacing.WEST : EnumFacing.EAST;
        return this.correct(state, target);
    }

    private EnumFacing correct(IBlockState state, EnumFacing target) {
        return RotationHandler.rotateFacing((EnumFacing)target, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED, POWER_LEFT});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal() - 2 + ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 4 : 0) + ((Boolean)state.func_177229_b((IProperty)POWER_LEFT) != false ? 8 : 0);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing face = EnumFacing.field_82609_l[(meta & 3) + 2];
        boolean powered = (meta & 4) != 0;
        boolean left = (meta & 8) != 0;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)).func_177226_a((IProperty)POWER_LEFT, (Comparable)Boolean.valueOf(left));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return REDSTONE_DIODE_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && super.func_176196_c(worldIn, pos);
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        return side.func_176740_k() != EnumFacing.Axis.Y;
    }

    protected boolean isPowered(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.isPowered(blockState)) {
            return 0;
        }
        return this.getActiveSignal(blockState, side);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.canBlockStay(worldIn, pos)) {
            this.updateState(worldIn, pos, state);
        } else {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
    }

    protected int calculateInputStrength(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos blockpos = pos.func_177972_a(enumfacing);
        int i = worldIn.func_175651_c(blockpos, enumfacing);
        if (i >= 15) {
            return i;
        }
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        return Math.max(i, iblockstate.func_177230_c() == Blocks.field_150488_af ? (Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) : 0);
    }

    protected boolean shouldBePowered(World world, BlockPos pos, IBlockState currState) {
        return this.calculateInputStrength(world, pos, currState) > 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.shouldBePowered(worldIn, pos, state)) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.notifyNeighbors(worldIn, pos, state);
    }

    protected void notifyNeighbors(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos blockpos = pos.func_177972_a(enumfacing.func_176734_d());
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), EnumSet.of(enumfacing.func_176734_d()), (boolean)false).isCanceled()) {
            return;
        }
        worldIn.func_190524_a(blockpos, (Block)this, pos);
        worldIn.func_175695_a(blockpos, (Block)this, enumfacing);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.isPowered(state)) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        if (super.rotateBlock(world, pos, axis)) {
            IBlockState state = world.func_180495_p(pos);
            state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
            world.func_175656_a(pos, state);
            if (this.shouldBePowered(world, pos, state)) {
                world.func_175684_a(pos, (Block)this, 1);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

