/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util.registry;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickRegistry {
    private static TickEvent.Phase TICK_PHASE = TickEvent.Phase.START;
    public static TickRegistryMultiple<World> WORLD = new TickRegistryMultiple<World>(){
        {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void worldTick(TickEvent.WorldTickEvent event) {
            if (event.phase != TICK_PHASE) {
                return;
            }
            this.tick(event.world);
        }
    };
    public static TickRegistryMultiple<EntityPlayer> PLAYER = new TickRegistryMultiple<EntityPlayer>(){
        {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void playerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TICK_PHASE) {
                return;
            }
            this.tick(event.player);
        }
    };
    public static TickRegistrySingle SERVER = new TickRegistrySingle(){
        {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void serverTick(TickEvent.ServerTickEvent event) {
            if (event.phase != TICK_PHASE) {
                return;
            }
            this.tick();
        }
    };
    public static TickRegistrySingle CLIENT = new TickRegistrySingle(){
        {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void clientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TICK_PHASE) {
                return;
            }
            this.tick();
        }
    };

    public static TickRegistrySingle getServerOrClientTickRegistry(boolean isRemote) {
        return isRemote ? CLIENT : SERVER;
    }

    public static TickRegistrySingle getServerOrClientTickRegistry() {
        return TickRegistry.getServerOrClientTickRegistry(FMLCommonHandler.instance().getEffectiveSide().isClient());
    }

    public static class TickRegistrySingle {
        private boolean currentlySimulating;
        private final List<BooleanSupplier> callbacks = new ArrayList<BooleanSupplier>();
        private final List<BooleanSupplier> toAdd = new ArrayList<BooleanSupplier>();

        public void addContinuousCallback(Runnable callback) {
            this.addCallback(() -> {
                callback.run();
                return true;
            });
        }

        public void addSingleCallback(Runnable callback) {
            this.addCallback(() -> {
                callback.run();
                return false;
            });
        }

        public void addCallback(BooleanSupplier callback) {
            if (this.currentlySimulating) {
                this.toAdd.add(callback);
            } else {
                this.callbacks.add(callback);
            }
        }

        public void tick() {
            this.currentlySimulating = true;
            ListIterator<BooleanSupplier> iter = this.callbacks.listIterator();
            while (iter.hasNext()) {
                BooleanSupplier callback = iter.next();
                if (callback.getAsBoolean()) continue;
                iter.remove();
            }
            this.callbacks.addAll(this.toAdd);
            this.toAdd.clear();
            this.currentlySimulating = false;
        }
    }

    public static class TickRegistryMultiple<T> {
        private Object currentlyIterating;
        private final Object dummy = new Object();
        private final ListMultimap<Object, Predicate<T>> callbacks = Multimaps.newListMultimap((Map)new MapMaker().weakKeys().makeMap(), LinkedList::new);
        private final List<Predicate<T>> toAdd = new ArrayList<Predicate<T>>();

        private TickRegistryMultiple() {
        }

        public void addContinuousCallback(T obj, Consumer<T> callback) {
            this.addCallback(obj, t -> {
                callback.accept(t);
                return true;
            });
        }

        public void addSingleCallback(T obj, Consumer<T> callback) {
            assert (obj != null);
            this.addCallback(obj, t -> {
                callback.accept(t);
                return false;
            });
        }

        public void addCallback(T obj, Predicate<T> callback) {
            Object val = obj == null ? this.dummy : obj;
            if (this.currentlyIterating == obj) {
                this.toAdd.add(callback);
            } else {
                this.callbacks.get(val).add(callback);
            }
        }

        protected void tick(T obj) {
            this.doTickWork(obj, obj);
            this.doTickWork(this.dummy, obj);
        }

        private void doTickWork(Object object, T param) {
            assert (this.currentlyIterating == null);
            this.currentlyIterating = object;
            ListIterator iter = this.callbacks.get(object).listIterator();
            while (iter.hasNext()) {
                Predicate callback = (Predicate)iter.next();
                if (callback.test(param)) continue;
                iter.remove();
            }
            this.callbacks.putAll(object, this.toAdd);
            this.toAdd.clear();
            this.currentlyIterating = null;
        }
    }
}

