/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.recipes.parts;

import aroma1997.core.recipes.IRecipePart;
import aroma1997.core.recipes.parts.IngredientRecipePart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class RecipePartMulti
implements IRecipePart {
    private IRecipePart[] parts;
    private Ingredient ingredient;

    public RecipePartMulti(IRecipePart ... parts) {
        this.parts = parts;
    }

    @Override
    public boolean doesItemMatch(ItemStack item) {
        for (IRecipePart part : this.parts) {
            if (!part.doesItemMatch(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> getExamples() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (IRecipePart part : this.parts) {
            stacks.addAll(part.getExamples());
        }
        return stacks;
    }

    @Override
    public int getAmount(ItemStack stack) {
        for (IRecipePart part : this.parts) {
            if (!part.doesItemMatch(stack)) continue;
            return part.getAmount(stack);
        }
        return 0;
    }

    @Override
    public ItemStack getResult(ItemStack in) {
        for (IRecipePart part : this.parts) {
            if (!part.doesItemMatch(in)) continue;
            return part.getResult(in);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public Ingredient getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new IngredientRecipePart(this);
        }
        return this.ingredient;
    }
}

