/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.extrarails;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowfacts.extrarails.ERConfig;
import net.shadowfacts.extrarails.block.ModBlocks;
import net.shadowfacts.extrarails.gui.GUIHandler;
import net.shadowfacts.extrarails.network.MessageSetColor;
import net.shadowfacts.extrarails.proxy.CommonProxy;
import net.shadowfacts.extrarails.tileentity.TileEntityRailComparator;
import net.shadowfacts.extrarails.tileentity.TileEntityRailTeleporting;

@Mod(modid="extrarails", name="Extra Rails", version="1.3.0", dependencies="required-after:shadowmc@[3.4.2,);", acceptedMinecraftVersions="[1.12]")
public class ExtraRails {
    public static final String MODID = "extrarails";
    public static final String NAME = "Extra Rails";
    public static final String VERSION = "1.3.0";
    @SidedProxy(serverSide="net.shadowfacts.extrarails.proxy.CommonProxy", clientSide="net.shadowfacts.extrarails.proxy.ClientProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="extrarails")
    public static ExtraRails instance;
    public static SimpleNetworkWrapper network;
    public static ModBlocks blocks;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ERConfig.init(event.getModConfigurationDirectory());
        ERConfig.load();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GUIHandler());
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        network.registerMessage(MessageSetColor.Handler.class, MessageSetColor.class, 0, Side.SERVER);
    }

    static {
        blocks = new ModBlocks();
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{ExtraRails.blocks.lockingRail, ExtraRails.blocks.directionRail, ExtraRails.blocks.teleportingRail, ExtraRails.blocks.comparatorRail, ExtraRails.blocks.woodenRail});
            GameRegistry.registerTileEntity(TileEntityRailTeleporting.class, (String)"extrarails.teleportingRail");
            GameRegistry.registerTileEntity(TileEntityRailComparator.class, (String)"extrarails.comparatorRail");
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ExtraRails.blocks.lockingRail.createItemBlock(), ExtraRails.blocks.directionRail.createItemBlock(), ExtraRails.blocks.teleportingRail.createItemBlock(), ExtraRails.blocks.comparatorRail.createItemBlock(), ExtraRails.blocks.woodenRail.createItemBlock()});
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ExtraRails.blocks.lockingRail.initItemModel();
            ExtraRails.blocks.directionRail.initItemModel();
            ExtraRails.blocks.teleportingRail.initItemModel();
            ExtraRails.blocks.comparatorRail.initItemModel();
            ExtraRails.blocks.woodenRail.initItemModel();
        }
    }
}

