/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.util;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.whammich.sstow.ConfigHandler;
import com.whammich.sstow.SoulShardsTOW;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class EntityMapper {
    public static List<ResourceLocation> entityList = Lists.newArrayList();
    public static Map<ResourceLocation, String> translationMap = Maps.newHashMap();

    public static void mapEntities() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            Class entClass = ((EntityEntry)entry.getValue()).getEntityClass();
            if (entClass == null) continue;
            if (entityList.contains(entry.getKey())) {
                SoulShardsTOW.LOGGER.info("Already mapped, skipping {}", (Object)entry);
                continue;
            }
            if (!EntityLiving.class.isAssignableFrom(entClass)) continue;
            translationMap.put((ResourceLocation)entry.getKey(), ((EntityEntry)entry.getValue()).getName());
            entityList.add((ResourceLocation)entry.getKey());
        }
        ConfigHandler.handleEntityList("Entity List");
        SoulShardsTOW.LOGGER.info("Finished mapping, found {} entities in {}", (Object)entityList.size(), (Object)stopwatch.stop());
    }

    public static boolean isEntityValid(ResourceLocation entName) {
        return ConfigHandler.entityList.contains(entName);
    }

    public static Class<? extends EntityLiving> getLivingClass(ResourceLocation entName) {
        return ((EntityEntry)ForgeRegistries.ENTITIES.getValue(entName)).getEntityClass();
    }
}

