/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow;

import com.whammich.sstow.ConfigHandler;
import com.whammich.sstow.JsonConfigHandler;
import com.whammich.sstow.RegistrarSoulShards;
import com.whammich.sstow.api.ShardHelper;
import com.whammich.sstow.commands.CommandSSTOW;
import com.whammich.sstow.util.EntityMapper;
import com.whammich.sstow.util.IMCHandler;
import com.whammich.sstow.util.TierHandler;
import com.whammich.sstow.util.Utils;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="soulshardstow", name="Soul Shards - The Old Ways", version="1.12-2.7.6-56", guiFactory="com.whammich.sstow.client.gui.GuiFactory", acceptedMinecraftVersions="[1.12]")
public class SoulShardsTOW {
    public static final String MODID = "soulshardstow";
    public static final String NAME = "Soul Shards - The Old Ways";
    public static final String VERSION = "1.12-2.7.6-56";
    public static final Logger LOGGER = LogManager.getLogger((String)"Soul Shards");
    public static final CreativeTabs TAB_SS = new CreativeTabs("soulShards"){

        public ItemStack func_78016_d() {
            ItemStack shard = new ItemStack(RegistrarSoulShards.SOUL_SHARD);
            ShardHelper.setTierForShard(shard, TierHandler.tiers.size() - 1);
            Utils.setMaxedKills(shard);
            ShardHelper.setBoundEntity(shard, new ResourceLocation("minecraft", "pig"));
            return shard;
        }
    };
    @Mod.Instance(value="soulshardstow")
    public static SoulShardsTOW INSTANCE;
    private File configDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configDir = new File(event.getModConfigurationDirectory(), "sstow");
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
        ConfigHandler.init(new File(this.configDir, "SoulShards.cfg"));
        JsonConfigHandler.initShard(new File(this.configDir, "ShardTiers.json"));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        EntityMapper.mapEntities();
        ConfigHandler.handleCatalyst();
        JsonConfigHandler.initMultiblock(new File(this.configDir, "Multiblock.json"));
    }

    @Mod.EventHandler
    public void onIMCRecieved(FMLInterModComms.IMCEvent event) {
        IMCHandler.handleIMC(event);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSSTOW());
    }

    public static void debug(String message, Object ... args) {
        if (ConfigHandler.debugLogging) {
            LOGGER.info("[DEBUG] " + message, args);
        }
    }
}

