/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow;

import com.whammich.sstow.api.ShardHelper;
import com.whammich.sstow.block.BlockCage;
import com.whammich.sstow.enchantment.EnchantmentSoulStealer;
import com.whammich.sstow.item.ItemMaterials;
import com.whammich.sstow.item.ItemSoulShard;
import com.whammich.sstow.item.ItemSoulSword;
import com.whammich.sstow.tile.TileEntityCage;
import com.whammich.sstow.util.TierHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="soulshardstow")
@GameRegistry.ObjectHolder(value="soulshardstow")
public class RegistrarSoulShards {
    private static final Item.ToolMaterial MATERIAL_SOUL = EnumHelper.addToolMaterial((String)"SOUL", (int)2, (int)250, (float)6.0f, (float)2.0f, (int)14);
    public static final Block CAGE = Blocks.field_150350_a;
    public static final Item SOUL_SHARD = Items.field_190931_a;
    public static final Item MATERIALS = Items.field_190931_a;
    public static final Item VILE_SWORD = Items.field_190931_a;
    public static final Enchantment SOUL_STEALER = null;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register(new BlockCage().setRegistryName("cage"));
        GameRegistry.registerTileEntity(TileEntityCage.class, (String)CAGE.getRegistryName().toString());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemSoulShard().setRegistryName("soul_shard"));
        event.getRegistry().register(new ItemMaterials().setRegistryName("materials"));
        event.getRegistry().register(new ItemSoulSword().setRegistryName("vile_sword"));
        event.getRegistry().register(new ItemBlock(CAGE).setRegistryName(CAGE.getRegistryName()));
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().register(new EnchantmentSoulStealer().setRegistryName("soul_stealer"));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        GameRegistry.addSmelting((Block)Blocks.field_150425_aM, (ItemStack)ItemMaterials.getStack("dustVile"), (float)0.4f);
        OreDictionary.registerOre((String)"ingotCorrupted", (ItemStack)ItemMaterials.getStack("ingotCorrupted"));
        OreDictionary.registerOre((String)"dustCorrupted", (ItemStack)ItemMaterials.getStack("dustCorrupted"));
        OreDictionary.registerOre((String)"dustVile", (ItemStack)ItemMaterials.getStack("dustVile"));
        MATERIAL_SOUL.setRepairItem(ItemMaterials.getStack("ingotCorrupted"));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (int i = 0; i < TierHandler.tiers.size(); ++i) {
            ModelLoader.registerItemVariants((Item)SOUL_SHARD, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(SOUL_SHARD.getRegistryName(), "tier=" + i)});
        }
        ModelLoader.registerItemVariants((Item)SOUL_SHARD, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(SOUL_SHARD.getRegistryName(), "tier=unbound")});
        ModelLoader.setCustomMeshDefinition((Item)SOUL_SHARD, stack -> {
            if (ShardHelper.isBound(stack)) {
                return new ModelResourceLocation(SOUL_SHARD.getRegistryName(), "tier=" + ShardHelper.getTierFromShard(stack));
            }
            return new ModelResourceLocation(SOUL_SHARD.getRegistryName(), "tier=unbound");
        });
        ModelLoader.setCustomModelResourceLocation((Item)VILE_SWORD, (int)0, (ModelResourceLocation)new ModelResourceLocation(VILE_SWORD.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)MATERIALS, (int)0, (ModelResourceLocation)new ModelResourceLocation(MATERIALS.getRegistryName(), "type=ingotsoulium"));
        ModelLoader.setCustomModelResourceLocation((Item)MATERIALS, (int)1, (ModelResourceLocation)new ModelResourceLocation(MATERIALS.getRegistryName(), "type=dustcorrupted"));
        ModelLoader.setCustomModelResourceLocation((Item)MATERIALS, (int)2, (ModelResourceLocation)new ModelResourceLocation(MATERIALS.getRegistryName(), "type=dustvile"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)CAGE), (int)0, (ModelResourceLocation)new ModelResourceLocation(CAGE.getRegistryName(), "active=false"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)CAGE), (int)1, (ModelResourceLocation)new ModelResourceLocation(CAGE.getRegistryName(), "active=true"));
    }

    public static Item.ToolMaterial getMaterialSoul() {
        return MATERIAL_SOUL;
    }
}

