/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.sensor.pollSensors;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.universalSensor.IPollSensorSetting;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Rectangle;

public class WorldGlobalVariableSensor
implements IPollSensorSetting {
    @Override
    public String getSensorPath() {
        return "World/Global variable";
    }

    @Override
    public Set<Item> getRequiredUpgrades() {
        return ImmutableSet.of((Object)Itemss.upgrades.get(IItemRegistry.EnumUpgrade.DISPENSER));
    }

    @Override
    public boolean needsTextBox() {
        return true;
    }

    @Override
    public List<String> getDescription() {
        return Collections.singletonList(TextFormatting.BLACK + "Emits a full-strength redstone signal when the linked global variable has any non-zero X value");
    }

    @Override
    public int getPollFrequency(TileEntity te) {
        return 1;
    }

    @Override
    public int getRedstoneValue(World world, BlockPos pos, int sensorRange, String textBoxText) {
        return GlobalVariableManager.getInstance().getBoolean(textBoxText) ? 15 : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawAdditionalInfo(FontRenderer fontRenderer) {
        fontRenderer.func_78276_b("Variable Name", 70, 48, 0x404040);
    }

    @Override
    public Rectangle needsSlot() {
        return null;
    }
}

