/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

class EntityFilterPair {
    private final IProgWidget widget;
    private final EntityFilter entityWhitelist;
    private final EntityFilter entityBlacklist;
    private String errorWhite = "";
    private String errorBlack = "";

    EntityFilterPair(IProgWidget widget) {
        this.widget = widget;
        this.entityWhitelist = this.getFilter(widget, true);
        this.entityBlacklist = this.getFilter(widget, false);
    }

    public static void addErrors(IProgWidget widget, List<String> errors) {
        EntityFilterPair filter = new EntityFilterPair(widget);
        if (!filter.errorWhite.isEmpty()) {
            errors.add("Invalid whitelist filter: " + filter.errorWhite);
        }
        if (!filter.errorBlack.isEmpty()) {
            errors.add("Invalid blacklist filter: " + filter.errorBlack);
        }
    }

    private EntityFilter getFilter(IProgWidget widget, boolean whitelist) {
        try {
            return EntityFilter.fromProgWidget(widget, whitelist);
        }
        catch (IllegalArgumentException e) {
            if (whitelist) {
                this.errorWhite = e.getMessage();
                return EntityFilter.allow();
            }
            this.errorBlack = e.getMessage();
            return EntityFilter.deny();
        }
    }

    boolean isEntityValid(Entity e) {
        return this.entityWhitelist.test(e) && !this.entityBlacklist.test(e);
    }

    List<Entity> getValidEntities(World world) {
        return this.getEntitiesInArea((ProgWidgetArea)this.widget.getConnectedParameters()[0], (ProgWidgetArea)this.widget.getConnectedParameters()[this.widget.getParameters().length], world);
    }

    private List<Entity> getEntitiesInArea(ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget, World world) {
        if (whitelistWidget == null) {
            return new ArrayList<Entity>();
        }
        HashSet<Entity> entities = new HashSet<Entity>();
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            entities.addAll(widget.getEntitiesWithinArea(world, this.entityWhitelist));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            entities.removeAll(widget.getEntitiesWithinArea(world, this.entityWhitelist));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        if (this.entityBlacklist != null) {
            entities.removeIf(this.entityBlacklist);
        }
        return new ArrayList<Entity>(entities);
    }
}

