/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import java.util.HashSet;
import java.util.Stack;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.BlockHeatPropertiesConfig;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourTransition;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HeatBehaviourCustomTransition
extends HeatBehaviourTransition {
    private BlockHeatPropertiesConfig.CustomHeatEntry heatEntry;

    @Override
    public void initialize(String id, IHeatExchangerLogic connectedHeatLogic, World world, BlockPos pos, EnumFacing direction) {
        super.initialize(id, connectedHeatLogic, world, pos, direction);
        this.heatEntry = BlockHeatPropertiesConfig.INSTANCE.getCustomHeatEntry(this.getBlockState());
    }

    @Override
    public String getId() {
        return "pneumaticcraft:customTransition";
    }

    @Override
    public boolean isApplicable() {
        if (!super.isApplicable()) {
            return false;
        }
        BlockHeatPropertiesConfig.CustomHeatEntry entry = this.getHeatEntry();
        return this.getHeatEntry() != null && this.getHeatEntry().getTotalHeat() != 0;
    }

    @Override
    protected int getMaxExchangedHeat() {
        return this.getHeatEntry().getTotalHeat();
    }

    @Override
    protected boolean transformBlockHot() {
        IBlockState hot = this.getHeatEntry().getTransformHot();
        if (hot == null) {
            return false;
        }
        if (this.getFluid() != null) {
            this.transformFluidBlocks(hot, this.getHeatEntry().getTransformHotFlowing());
            return true;
        }
        return this.getWorld().func_175656_a(this.getPos(), hot);
    }

    @Override
    protected boolean transformBlockCold() {
        IBlockState cold = this.getHeatEntry().getTransformCold();
        if (cold == null) {
            return false;
        }
        if (this.getFluid() != null) {
            this.transformFluidBlocks(cold, this.getHeatEntry().getTransformColdFlowing());
            return true;
        }
        return this.getWorld().func_175656_a(this.getPos(), cold);
    }

    private BlockHeatPropertiesConfig.CustomHeatEntry getHeatEntry() {
        return this.heatEntry;
    }

    private void transformFluidBlocks(IBlockState turningBlockSource, IBlockState turningBlockFlowing) {
        if (FluidUtils.isSourceBlock(this.getWorld(), this.getPos())) {
            this.getWorld().func_175656_a(this.getPos(), turningBlockSource);
        } else {
            HashSet<BlockPos> traversed = new HashSet<BlockPos>();
            Stack<BlockPos> pending = new Stack<BlockPos>();
            pending.push(this.getPos());
            traversed.add(this.getPos());
            while (!pending.isEmpty()) {
                BlockPos pos = (BlockPos)pending.pop();
                for (EnumFacing d : EnumFacing.field_82609_l) {
                    BlockPos newPos = pos.func_177972_a(d);
                    Block checkingBlock = this.getWorld().func_180495_p(newPos).func_177230_c();
                    if (!this.blocksSame(checkingBlock, this.getBlockState().func_177230_c()) || !traversed.add(newPos)) continue;
                    if (FluidUtils.isSourceBlock(this.getWorld(), newPos)) {
                        this.getWorld().func_175656_a(newPos, turningBlockSource);
                        this.onTransition(newPos);
                        return;
                    }
                    this.getWorld().func_175656_a(newPos, turningBlockFlowing);
                    this.onTransition(newPos);
                    pending.push(newPos);
                }
            }
        }
    }

    private boolean blocksSame(Block b1, Block b2) {
        return b1 == b2 || b1 == Blocks.field_150356_k && b2 == Blocks.field_150353_l || b1 == Blocks.field_150353_l && b2 == Blocks.field_150356_k || b1 == Blocks.field_150358_i && b2 == Blocks.field_150355_j || b1 == Blocks.field_150355_j && b2 == Blocks.field_150358_i;
    }
}

