/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAphorismTile;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.DyeUtils;

public class BlockAphorismTile
extends BlockPneumaticCraft {
    private static final String NBT_BORDER_COLOR = "borderColor";
    private static final String NBT_BACKGROUND_COLOR = "backgroundColor";

    BlockAphorismTile() {
        super(Material.field_151576_e, "aphorism_tile");
        this.func_149711_c(1.5f);
        this.func_149752_b(4.0f);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)ROTATION);
        return new AxisAlignedBB(dir.func_82601_c() <= 0 ? 0.0 : 0.9375, dir.func_96559_d() <= 0 ? 0.0 : 0.9375, dir.func_82599_e() <= 0 ? 0.0 : 0.9375, dir.func_82601_c() >= 0 ? 1.0 : 0.0625, dir.func_96559_d() >= 0 ? 1.0 : 0.0625, dir.func_82599_e() >= 0 ? 1.0 : 0.0625);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.func_185496_a(blockState, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityAphorismTile.class;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void func_190948_a(ItemStack stack, World world, List<String> curInfo, ITooltipFlag flag) {
        super.func_190948_a(stack, world, curInfo, flag);
        if (NBTUtil.hasTag(stack, NBT_BORDER_COLOR) || NBTUtil.hasTag(stack, NBT_BACKGROUND_COLOR)) {
            curInfo.add(TextFormatting.DARK_GREEN.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"gui.tab.info.tile.aphorism_tile.color", (Object[])new Object[0]));
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack iStack) {
        super.func_180633_a(world, pos, state, entityLiving, iStack);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityAphorismTile) {
            TileEntityAphorismTile teAT = (TileEntityAphorismTile)te;
            teAT.setBackgroundColor(BlockAphorismTile.getBackgroundColor(iStack));
            teAT.setBorderColor(BlockAphorismTile.getBorderColor(iStack));
            EnumFacing rotation = this.getRotation((IBlockAccess)world, pos);
            if (rotation.func_176740_k() == EnumFacing.Axis.Y) {
                float yaw = entityLiving.field_70177_z;
                if (yaw < 0.0f) {
                    yaw += 360.0f;
                }
                teAT.textRotation = (((int)yaw + 45) / 90 + 2) % 4;
                if (rotation.func_96559_d() > 0 && (teAT.textRotation == 1 || teAT.textRotation == 3)) {
                    teAT.textRotation = 4 - teAT.textRotation;
                }
            }
            if (world.field_72995_K && entityLiving instanceof EntityPlayer) {
                ((EntityPlayer)entityLiving).openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.APHORISM_TILE.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                this.sendEditorMessage((EntityPlayer)entityLiving);
            }
        }
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityAphorismTile && drops.size() > 0) {
            TileEntityAphorismTile teAT = (TileEntityAphorismTile)te;
            ItemStack teStack = (ItemStack)drops.get(0);
            int bgColor = teAT.getBackgroundColor();
            int borderColor = teAT.getBorderColor();
            if (bgColor != EnumDyeColor.WHITE.func_176767_b() || borderColor != EnumDyeColor.BLUE.func_176767_b()) {
                NBTUtil.setInteger(teStack, NBT_BACKGROUND_COLOR, bgColor);
                NBTUtil.setInteger(teStack, NBT_BORDER_COLOR, borderColor);
            }
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (world.field_72995_K && hand != EnumHand.OFF_HAND && player.func_184586_b(hand).func_190926_b() && !player.func_70093_af()) {
            player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.APHORISM_TILE.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.sendEditorMessage(player);
        } else if (!world.field_72995_K && DyeUtils.isDye((ItemStack)player.func_184586_b(hand)) && (te = world.func_175625_s(pos)) instanceof TileEntityAphorismTile) {
            TileEntityAphorismTile teAT = (TileEntityAphorismTile)te;
            OptionalInt color = DyeUtils.dyeDamageFromStack((ItemStack)player.func_184586_b(hand));
            if (color.isPresent()) {
                if (this.clickedBorder(state, hitX, hitY, hitZ)) {
                    if (teAT.getBorderColor() != color.getAsInt()) {
                        teAT.setBorderColor(color.getAsInt());
                        player.func_184586_b(hand).func_190918_g(1);
                    }
                } else if (teAT.getBackgroundColor() != color.getAsInt()) {
                    teAT.setBackgroundColor(color.getAsInt());
                    player.func_184586_b(hand).func_190918_g(1);
                }
            }
        }
        return true;
    }

    private boolean clickedBorder(IBlockState state, float hitX, float hitY, float hitZ) {
        switch (this.getRotation(state)) {
            case EAST: 
            case WEST: {
                return (double)hitY < 0.1 || (double)hitY > 0.9 || (double)hitZ < 0.1 || (double)hitZ > 0.9;
            }
            case NORTH: 
            case SOUTH: {
                return (double)hitY < 0.1 || (double)hitY > 0.9 || (double)hitX < 0.1 || (double)hitX > 0.9;
            }
            case UP: 
            case DOWN: {
                return (double)hitX < 0.1 || (double)hitX > 0.9 || (double)hitZ < 0.1 || (double)hitZ > 0.9;
            }
        }
        return false;
    }

    private void sendEditorMessage(EntityPlayer player) {
        ITextComponent msg = new TextComponentString(TextFormatting.WHITE.toString()).func_150257_a((ITextComponent)new TextComponentTranslation("gui.aphorismTileEditor", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(": ")).func_150257_a((ITextComponent)new TextComponentTranslation("gui.holdF1forHelp", new Object[0]));
        player.func_146105_b(msg, true);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, BlockPos pos, EnumFacing face, EnumHand hand) {
        if (player != null && player.func_70093_af()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEntityAphorismTile) {
                TileEntityAphorismTile teAt = (TileEntityAphorismTile)tile;
                if (++teAt.textRotation > 3) {
                    teAt.textRotation = 0;
                }
                teAt.sendDescriptionPacket();
                return true;
            }
            return false;
        }
        return super.rotateBlock(world, player, pos, face, hand);
    }

    @Override
    protected boolean rotateForgeWay() {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public static int getBackgroundColor(ItemStack stack) {
        return NBTUtil.hasTag(stack, NBT_BACKGROUND_COLOR) ? NBTUtil.getInteger(stack, NBT_BACKGROUND_COLOR) : EnumDyeColor.WHITE.func_176767_b();
    }

    public static int getBorderColor(ItemStack stack) {
        return NBTUtil.hasTag(stack, NBT_BORDER_COLOR) ? NBTUtil.getInteger(stack, NBT_BORDER_COLOR) : EnumDyeColor.BLUE.func_176767_b();
    }
}

