/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import java.util.List;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RenderSearchItemBlock {
    private final BlockPos pos;
    private final World world;
    private long lastCheck = 0L;
    private int cachedAmount;

    public RenderSearchItemBlock(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public int getSearchedItemCount() {
        if (this.world.func_82737_E() - this.lastCheck >= 20L) {
            TileEntity te = this.world.func_175625_s(this.pos);
            if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                int itemCount = 0;
                ItemStack searchStack = ItemPneumaticArmor.getSearchedStack(ClientUtils.getWornArmor(EntityEquipmentSlot.HEAD));
                if (searchStack.func_190926_b()) {
                    return 0;
                }
                for (int l = 0; l < handler.getSlots(); ++l) {
                    if (handler.getStackInSlot(l).func_190926_b()) continue;
                    itemCount += RenderSearchItemBlock.getSearchedItemCount(handler.getStackInSlot(l), searchStack);
                }
                this.cachedAmount = itemCount;
            } else {
                this.cachedAmount = 0;
            }
            this.lastCheck = this.world.func_82737_E();
        }
        return this.cachedAmount;
    }

    public static int getSearchedItemCount(ItemStack stack, ItemStack searchStack) {
        int itemCount = 0;
        if (stack.func_77969_a(searchStack)) {
            itemCount += stack.func_190916_E();
        }
        List<ItemStack> inventoryItems = PneumaticCraftUtils.getStacksInItem(stack);
        for (ItemStack s : inventoryItems) {
            itemCount += RenderSearchItemBlock.getSearchedItemCount(s, searchStack);
        }
        return itemCount;
    }

    public void renderSearchBlock(int totalCount, float partialTicks) {
        RenderSearchItemBlock.renderSearch((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, this.getSearchedItemCount(), totalCount, partialTicks);
    }

    public static void renderSearch(double x, double y, double z, int itemCount, int totalCount, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        float f = ((float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() & 0x1FL) + partialTicks) / 5.092f;
        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)(0.65f + MathHelper.func_76126_a((float)f) * 0.15f));
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        double ratio = (double)itemCount / (double)totalCount;
        double diff = (1.0 - ratio) / 1.5;
        double size = 1.0 - diff;
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b(-size, size, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        wr.func_181662_b(-size, -size, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        wr.func_181662_b(size, -size, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        wr.func_181662_b(size, size, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179121_F();
    }
}

