/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.structures.abyss.stronghold;

import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.common.structures.abyss.stronghold.StructureAbyStrongholdPieces;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.storage.WorldSavedData;

public class MapGenAbyStronghold
extends MapGenStructure {
    public static ArrayList<Biome> allowedBiomes = new ArrayList<Biome>(Arrays.asList(ACBiomes.abyssal_wastelands));
    private Biome[] allowedBiomeGenBases = allowedBiomes.toArray(new Biome[0]);
    private boolean ranBiomeCheck;
    private ChunkPos[] structureCoords = new ChunkPos[128];
    private double field_82671_h = 32.0;
    private int field_82672_i = 3;

    public MapGenAbyStronghold() {
    }

    public MapGenAbyStronghold(Map<String, String> par1Map) {
        this();
        for (Map.Entry<String, String> var3 : par1Map.entrySet()) {
            if (var3.getKey().equals("distance")) {
                this.field_82671_h = MathHelper.func_82713_a((String)var3.getValue(), (double)this.field_82671_h, (double)1.0);
                continue;
            }
            if (var3.getKey().equals("count")) {
                this.structureCoords = new ChunkPos[MathHelper.func_82714_a((String)var3.getValue(), (int)this.structureCoords.length, (int)1)];
                continue;
            }
            if (!var3.getKey().equals("spread")) continue;
            this.field_82672_i = MathHelper.func_82714_a((String)var3.getValue(), (int)this.field_82672_i, (int)1);
        }
    }

    public String func_143025_a() {
        return "AbyStronghold";
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean bool) {
        if (!this.ranBiomeCheck) {
            this.checkBiomes();
            this.ranBiomeCheck = true;
        }
        BlockPos blockpos = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(0, 0, 0);
        double d0 = Double.MAX_VALUE;
        for (ChunkPos chunkcoordintpair : this.structureCoords) {
            StructureStart structure;
            if (bool && (structure = (StructureStart)this.field_75053_d.get(ChunkPos.func_77272_a((int)chunkcoordintpair.field_77276_a, (int)chunkcoordintpair.field_77275_b))) instanceof Start && ((Start)structure).isExplored()) continue;
            blockpos$mutableblockpos.func_181079_c((chunkcoordintpair.field_77276_a << 4) + 8, 32, (chunkcoordintpair.field_77275_b << 4) + 8);
            double d1 = blockpos$mutableblockpos.func_177951_i((Vec3i)pos);
            if (blockpos == null) {
                blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
                d0 = d1;
                continue;
            }
            if (!(d1 < d0)) continue;
            blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
            d0 = d1;
        }
        return blockpos;
    }

    public void markStructureExplored(World world, BlockPos pos) {
        StructureStart structure = this.func_175797_c(pos);
        if (structure instanceof Start) {
            ((Start)structure).setExplored(true);
            WorldSavedData data = world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, this.func_143025_a());
            if (data instanceof MapGenStructureData) {
                ((MapGenStructureData)data).func_143043_a(structure.func_143021_a(structure.func_143019_e(), structure.func_143018_f()), structure.func_143019_e(), structure.func_143018_f());
                data.func_76185_a();
            }
        }
    }

    protected boolean func_75047_a(int par1, int par2) {
        if (!this.ranBiomeCheck) {
            this.checkBiomes();
            this.ranBiomeCheck = true;
        }
        for (ChunkPos var16 : this.structureCoords) {
            if (par1 != var16.field_77276_a || par2 != var16.field_77275_b) continue;
            return true;
        }
        return false;
    }

    private void checkBiomes() {
        this.func_143027_a(this.field_75039_c);
        int i = 0;
        for (StructureStart structurestart : this.field_75053_d.values()) {
            if (i >= this.structureCoords.length) continue;
            this.structureCoords[i++] = new ChunkPos(structurestart.func_143019_e(), structurestart.func_143018_f());
        }
        Random random = new Random();
        random.setSeed(this.field_75039_c.func_72905_C());
        double d1 = random.nextDouble() * Math.PI * 2.0;
        int j = 0;
        int k = 0;
        int l = this.field_75053_d.size();
        if (l < this.structureCoords.length) {
            for (int i1 = 0; i1 < this.structureCoords.length; ++i1) {
                double d0 = 4.0 * this.field_82671_h + this.field_82671_h * (double)j * 6.0 + (random.nextDouble() - 0.5) * this.field_82671_h * 2.5;
                int j1 = (int)Math.round(Math.cos(d1) * d0);
                int k1 = (int)Math.round(Math.sin(d1) * d0);
                BlockPos blockpos = this.field_75039_c.func_72959_q().func_180630_a((j1 << 4) + 8, (k1 << 4) + 8, 112, allowedBiomes, random);
                if (blockpos != null) {
                    j1 = blockpos.func_177958_n() >> 4;
                    k1 = blockpos.func_177952_p() >> 4;
                }
                if (i1 >= l) {
                    this.structureCoords[i1] = new ChunkPos(j1, k1);
                }
                d1 += Math.PI * 2 / (double)this.field_82672_i;
                if (++k != this.field_82672_i) continue;
                k = 0;
                this.field_82672_i += 2 * this.field_82672_i / (++j + 1);
                this.field_82672_i = Math.min(this.field_82672_i, this.structureCoords.length - i1);
                d1 += random.nextDouble() * Math.PI * 2.0;
            }
        }
    }

    protected StructureStart func_75049_b(int par1, int par2) {
        Start start = new Start(this.field_75039_c, this.field_75038_b, par1, par2);
        while (start.func_186161_c().isEmpty() || ((StructureAbyStrongholdPieces.Stairs2)((Object)start.func_186161_c().get((int)0))).strongholdPortalRoom == null) {
            start = new Start(this.field_75039_c, this.field_75038_b, par1, par2);
        }
        return start;
    }

    public static class Start
    extends StructureStart {
        private boolean isExplored;

        public Start() {
        }

        public Start(World par1World, Random par2Random, int par3, int par4) {
            super(par3, par4);
            StructureAbyStrongholdPieces.prepareStructurePieces();
            StructureAbyStrongholdPieces.Stairs2 stairs2 = new StructureAbyStrongholdPieces.Stairs2(0, par2Random, (par3 << 4) + 2, (par4 << 4) + 2);
            this.field_75075_a.add(stairs2);
            stairs2.func_74861_a(stairs2, this.field_75075_a, par2Random);
            List<StructureAbyStrongholdPieces.Stronghold> list = stairs2.field_75026_c;
            while (!list.isEmpty()) {
                int k = par2Random.nextInt(list.size());
                StructureComponent structurecomponent = list.remove(k);
                structurecomponent.func_74861_a((StructureComponent)stairs2, this.field_75075_a, par2Random);
            }
            this.func_75072_c();
            this.func_75067_a(par1World, par2Random, 10);
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            tagCompound.func_74757_a("explored", this.isExplored);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            if (tagCompound.func_74764_b("explored")) {
                this.setExplored(tagCompound.func_74767_n("explored"));
            }
        }

        public void setExplored(boolean explored) {
            this.isExplored = explored;
        }

        public boolean isExplored() {
            return this.isExplored;
        }
    }
}

