/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.client;

import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionHandler;
import com.shinoow.abyssalcraft.api.event.ACEvents;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class RitualMessage
extends AbstractMessage.AbstractClientMessage<RitualMessage> {
    private String name;
    private String disruption;
    private BlockPos pos;
    private boolean failed;

    public RitualMessage() {
    }

    public RitualMessage(String name, BlockPos pos) {
        this(name, pos, false, "");
    }

    public RitualMessage(String name, BlockPos pos, boolean failed, String disruption) {
        this.name = name;
        this.pos = pos;
        this.failed = failed;
        this.disruption = disruption;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.failed = buffer.readBoolean();
        this.pos = buffer.func_179259_c();
        this.disruption = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        buffer.writeBoolean(this.failed);
        buffer.func_179255_a(this.pos);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.disruption);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        NecronomiconRitual ritual = null;
        for (NecronomiconRitual r : RitualRegistry.instance().getRituals()) {
            if (!r.getUnlocalizedName().substring("ac.ritual.".length()).equals(this.name)) continue;
            ritual = r;
            break;
        }
        if (ritual != null) {
            if (this.failed) {
                MinecraftForge.EVENT_BUS.post((Event)new ACEvents.RitualEvent.Failed(player, ritual, DisruptionHandler.instance().disruptionFromName(this.disruption), player.field_70170_p, this.pos));
            } else if (!MinecraftForge.EVENT_BUS.post((Event)new ACEvents.RitualEvent.Post(player, ritual, player.field_70170_p, this.pos))) {
                ritual.completeRitual(player.field_70170_p, this.pos, player);
            }
        }
    }
}

