/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.entity.anti;

import com.shinoow.abyssalcraft.api.entity.IAntiEntity;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.entity.anti.EntityAntiSkeleton;
import com.shinoow.abyssalcraft.common.util.ExplosionUtil;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLoot;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityAntiSpider
extends EntityMob
implements IAntiEntity {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityAntiSpider.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityAntiSpider(World par1World) {
        super(par1World);
        this.func_70105_a(1.4f, 0.9f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAntiSpiderAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AIAntiSpiderTarget<EntitySpider>(this, EntitySpider.class));
        this.field_70715_bh.func_75776_a(3, new AIAntiSpiderTarget<EntityPlayer>(this, EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, new AIAntiSpiderTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    public double func_70042_X() {
        return this.field_70131_O * 0.5f;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)new Byte(0));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(64.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(32.0);
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (ACConfig.hardcoreMode && par1Entity instanceof EntityPlayer) {
            par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h().func_151518_m(), 1.5f * (float)(ACConfig.damageAmpl > 1.0 ? ACConfig.damageAmpl : 1.0));
        }
        return super.func_70652_k(par1Entity);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean par1, int par2) {
        super.func_70628_a(par1, par2);
        if (par1 && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + par2) > 0)) {
            this.func_145779_a(ACItems.anti_spider_eye, 1);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    protected ResourceLocation func_184647_J() {
        return ACLoot.ENTITY_ANTI_SPIDER;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return par1PotionEffect.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(par1PotionEffect);
    }

    protected void func_82167_n(Entity par1Entity) {
        if (!this.field_70170_p.field_72995_K && par1Entity instanceof EntitySpider) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            if (ACConfig.nuclearAntimatterExplosions) {
                ExplosionUtil.newODBExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0f, true, flag);
            } else {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, flag);
            }
            this.func_70106_y();
        } else {
            par1Entity.func_70108_f((Entity)this);
        }
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean par1) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = par1 ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        Potion i;
        IEntityLivingData p_110161_1_1 = super.func_180482_a(difficulty, par1EntityLivingData);
        if (this.field_70170_p.field_73012_v.nextInt(100) == 0) {
            EntityAntiSkeleton entityskeleton = new EntityAntiSkeleton(this.field_70170_p);
            entityskeleton.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityskeleton.func_180482_a(difficulty, null);
            this.field_70170_p.func_72838_d((Entity)entityskeleton);
            entityskeleton.func_184220_m((Entity)this);
        }
        if (p_110161_1_1 == null) {
            p_110161_1_1 = new GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((GroupData)p_110161_1_1).func_111104_a(this.field_70170_p.field_73012_v);
            }
        }
        if (p_110161_1_1 instanceof GroupData && Potion.func_188409_a((Potion)(i = ((GroupData)p_110161_1_1).field_111105_a)) > 0) {
            this.func_70690_d(new PotionEffect(i, Integer.MAX_VALUE));
        }
        return p_110161_1_1;
    }

    public float func_70047_e() {
        return 0.65f;
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion field_111105_a;

        public void func_111104_a(Random par1Random) {
            int i = par1Random.nextInt(5);
            if (i <= 1) {
                this.field_111105_a = MobEffects.field_76424_c;
            } else if (i <= 2) {
                this.field_111105_a = MobEffects.field_76420_g;
            } else if (i <= 3) {
                this.field_111105_a = MobEffects.field_76428_l;
            } else if (i <= 4) {
                this.field_111105_a = MobEffects.field_76441_p;
            }
        }
    }

    static class AIAntiSpiderTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget {
        public AIAntiSpiderTarget(EntityAntiSpider p_i45818_1_, Class<T> classTarget) {
            super((EntityCreature)p_i45818_1_, classTarget, true);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f >= 0.5f ? false : super.func_75250_a();
        }
    }

    static class AIAntiSpiderAttack
    extends EntityAIAttackMelee {
        public AIAntiSpiderAttack(EntityAntiSpider p_i45819_1_) {
            super((EntityCreature)p_i45819_1_, 1.0, true);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

