/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.shinoow.abyssalcraft.api.energy.PEUtils;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityStatue;
import com.shinoow.abyssalcraft.lib.ACTabs;
import com.shinoow.abyssalcraft.lib.util.blocks.BlockUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStatue
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyEnum<EnumDeityType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumDeityType.class);

    public BlockStatue() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)EnumDeityType.CTHULHU)));
        this.func_149711_c(6.0f);
        this.func_149752_b(12.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(ACTabs.tabDecoration);
        this.setHarvestLevel("pickaxe", 0);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(TYPE, (Comparable)((Object)EnumDeityType.byMetadata(meta)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = EnumFacing.NORTH;
        TileEntity tile = BlockUtil.getTileEntitySafely(worldIn, pos);
        if (tile instanceof TileEntityStatue) {
            facing = EnumFacing.func_82600_a((int)((TileEntityStatue)tile).getFacing());
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumDeityType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDeityType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDeityType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        for (int i = 0; i < EnumDeityType.values().length; ++i) {
            par3List.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockUtil.dropTileEntityAsItemWithExtra(world, pos, state, (Block)this);
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityStatue) {
            ((TileEntityStatue)tile).setFacing(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a());
            if (stack.func_77942_o()) {
                NBTTagCompound data = new NBTTagCompound();
                tile.func_189515_b(data);
                data.func_74768_a("Timer", stack.func_77978_p().func_74762_e("Timer"));
                data.func_74768_a("ActivationTimer", stack.func_77978_p().func_74762_e("ActivationTimer"));
                data.func_74768_a("Tolerance", stack.func_77978_p().func_74762_e("Tolerance") + 10);
                tile.func_145839_a(data);
                PEUtils.readManipulatorNBT((TileEntityStatue)tile, stack.func_77978_p());
            }
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityStatue();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).add(new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE}).add(new IProperty[]{TYPE}).build();
    }

    public static enum EnumDeityType implements IStringSerializable
    {
        CTHULHU(0, "cthulhu"),
        HASTUR(1, "hastur"),
        JZAHAR(2, "jzahar"),
        AZATHOTH(3, "azathoth"),
        NYARLATHOTEP(4, "nyarlathotep"),
        YOGSOTHOTH(5, "yogsothoth"),
        SHUBNIGGURATH(6, "shubniggurath");

        private static final EnumDeityType[] META_LOOKUP;
        private int meta;
        private String name;

        private EnumDeityType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumDeityType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String toString() {
            return this.func_176610_l();
        }

        static {
            META_LOOKUP = new EnumDeityType[EnumDeityType.values().length];
            EnumDeityType[] enumDeityTypeArray = EnumDeityType.values();
            int n = enumDeityTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumDeityType type;
                EnumDeityType.META_LOOKUP[type.getMeta()] = type = enumDeityTypeArray[i];
            }
        }
    }
}

