/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.client.gui.necronomicon;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconCreationRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomicon;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonHome;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonNextPage;
import com.shinoow.abyssalcraft.lib.NecronomiconResources;
import com.shinoow.abyssalcraft.lib.NecronomiconText;
import com.shinoow.abyssalcraft.lib.util.IHiddenRitual;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public class GuiNecronomiconRitualEntry
extends GuiNecronomicon {
    private ButtonNextPage buttonNextPage;
    private ButtonNextPage buttonNextPageLong;
    private ButtonNextPage buttonPreviousPage;
    private ButtonNextPage buttonPreviousPageLong;
    private GuiButton buttonDone;
    private ButtonHome buttonHome;
    private GuiNecronomicon parent;
    private Map<Integer, String> dimToString = new HashMap<Integer, String>();
    private int ritualnum;
    private List<NecronomiconRitual> rituals = new ArrayList<NecronomiconRitual>();

    public GuiNecronomiconRitualEntry(int bookType, GuiNecronomicon gui, int ritualnum) {
        super(bookType);
        this.parent = gui;
        this.isInfo = true;
        this.ritualnum = ritualnum;
    }

    @Override
    public GuiNecronomicon withBookType(int par1) {
        if (this.getBookType() > par1) {
            this.isInvalid = true;
        }
        return super.withBookType(par1);
    }

    @Override
    public void func_73866_w_() {
        if (this.isInvalid) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
        }
        currentNecro = this;
        if (this.rituals.isEmpty()) {
            this.initStuff();
        }
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        int i = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.buttonNextPage = new ButtonNextPage(1, i + 215, b0 + 154, true, false);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonNextPageLong = new ButtonNextPage(2, i + 203, b0 + 167, true, true);
        this.field_146292_n.add(this.buttonNextPageLong);
        this.buttonPreviousPage = new ButtonNextPage(3, i + 18, b0 + 154, false, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonPreviousPageLong = new ButtonNextPage(4, i + 23, b0 + 167, false, true);
        this.field_146292_n.add(this.buttonPreviousPageLong);
        this.buttonHome = new ButtonHome(5, i + 118, b0 + 167);
        this.field_146292_n.add(this.buttonHome);
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currTurnup < this.getTurnupLimit() - 1;
        this.buttonNextPageLong.field_146125_m = this.currTurnup < this.getTurnupLimit() - 5;
        this.buttonPreviousPage.field_146125_m = true;
        this.buttonPreviousPageLong.field_146125_m = this.currTurnup > 4;
        this.buttonDone.field_146125_m = true;
        this.buttonHome.field_146125_m = true;
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                if (this.currTurnup < this.getTurnupLimit() - 1) {
                    ++this.currTurnup;
                }
            } else if (button.field_146127_k == 2) {
                if (this.currTurnup < this.getTurnupLimit() - 5) {
                    this.currTurnup += 5;
                }
            } else if (button.field_146127_k == 3) {
                if (this.currTurnup == 0) {
                    this.isInfo = false;
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
                } else if (this.currTurnup > 0) {
                    --this.currTurnup;
                }
            } else if (button.field_146127_k == 4) {
                if (this.currTurnup > 4) {
                    this.currTurnup -= 5;
                }
            } else if (button.field_146127_k == 5) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomicon(this.getBookType()));
            }
        }
        this.updateButtons();
    }

    @Override
    protected void drawInformationText(int x, int y) {
        this.drawPage(this.rituals.get(this.currTurnup), x, y);
    }

    private void drawPage(NecronomiconRitual ritual, int x, int y) {
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        String title = ritual.getLocalizedName();
        this.field_146289_q.func_78279_b(title, k + 20, b0 + 16, 116, 0xC40000);
        if (ritual.requiresSacrifice()) {
            this.field_146289_q.func_78279_b(this.localize(NecronomiconText.LABEL_SACRIFICE), k + 138, 164, 107, 0xC40000);
        }
        this.writeText(1, this.localize(NecronomiconText.LABEL_REQUIRED_ENERGY) + ": " + ritual.getReqEnergy() + " PE", 125);
        this.writeText(2, this.localize(NecronomiconText.LABEL_LOCATION) + ": " + this.getDimension(ritual.getDimension()));
        if (!ritual.getDescription().startsWith("ac.ritual.")) {
            this.writeText(2, ritual.getDescription(), 48);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.RITUAL);
        this.func_73729_b(k, b0, 0, 0, 256, 256);
        if (ritual.getSacrifice() != null) {
            this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.RITUAL_INFUSION);
            this.func_73729_b(k, b0, 0, 0, 256, 256);
        }
        if (ritual instanceof NecronomiconCreationRitual) {
            this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.RITUAL_CREATION);
            this.func_73729_b(k, b0, 0, 0, 256, 256);
        }
        this.tooltipStack = null;
        Object[] offerings = new Object[8];
        if (ritual.getOfferings().length < 8) {
            for (int i = 0; i < ritual.getOfferings().length; ++i) {
                offerings[i] = ritual.getOfferings()[i];
            }
        } else {
            offerings = ritual.getOfferings();
        }
        this.renderObject(k + 58, b0 + 30, offerings[0], x, y);
        this.renderObject(k + 84, b0 + 40, offerings[1], x, y);
        this.renderObject(k + 94, b0 + 66, offerings[2], x, y);
        this.renderObject(k + 84, b0 + 92, offerings[3], x, y);
        this.renderObject(k + 58, b0 + 103, offerings[4], x, y);
        this.renderObject(k + 32, b0 + 92, offerings[5], x, y);
        this.renderObject(k + 22, b0 + 66, offerings[6], x, y);
        this.renderObject(k + 32, b0 + 40, offerings[7], x, y);
        this.renderItem(k + 58, b0 + 66, APIUtils.convertToStack(ritual.getSacrifice()), x, y);
        if (ritual instanceof NecronomiconCreationRitual) {
            this.renderItem(k + 58, b0 + 139, ((NecronomiconCreationRitual)ritual).getItem(), x, y);
        }
        this.renderTooltip(x, y);
    }

    private String getDimension(int dim) {
        if (!this.dimToString.containsKey(dim)) {
            this.dimToString.put(dim, "DIM" + dim);
        }
        return this.dimToString.get(dim);
    }

    private void initStuff() {
        this.dimToString.put(-1, this.localize(NecronomiconText.LABEL_ANYWHERE));
        this.dimToString.putAll(RitualRegistry.instance().getDimensionNameMappings());
        for (NecronomiconRitual ritual : RitualRegistry.instance().getRituals()) {
            if (ritual.getBookType() != this.ritualnum || !this.isUnlocked(ritual.getUnlockCondition()) || ritual instanceof IHiddenRitual) continue;
            this.rituals.add(ritual);
        }
        this.setTurnupLimit(this.rituals.size());
    }
}

