/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.recipe;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CrystallizerRecipes {
    private static final CrystallizerRecipes crystallizationBase = new CrystallizerRecipes();
    private final Map<ItemStack, ItemStack[]> crystallizationList = new HashMap<ItemStack, ItemStack[]>();
    private final Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    public static CrystallizerRecipes instance() {
        return crystallizationBase;
    }

    private CrystallizerRecipes() {
    }

    public void crystallize(Block input, ItemStack output1, ItemStack output2, float xp) {
        this.crystallize(Item.func_150898_a((Block)input), output1, output2, xp);
    }

    public void crystallize(Item input, ItemStack output1, ItemStack output2, float xp) {
        this.crystallize(new ItemStack(input, 1, Short.MAX_VALUE), output1, output2, xp);
    }

    public void crystallize(ItemStack input, ItemStack output1, ItemStack output2, float xp) {
        this.crystallizationList.put(input, new ItemStack[]{output1, output2});
        this.experienceList.put(output1, Float.valueOf(xp));
    }

    public ItemStack[] getCrystallizationResult(ItemStack par1ItemStack) {
        for (Map.Entry<ItemStack, ItemStack[]> entry : this.crystallizationList.entrySet()) {
            if (!this.areStacksEqual(par1ItemStack, entry.getKey())) continue;
            return entry.getValue();
        }
        return new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
    }

    private boolean areStacksEqual(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == par1ItemStack.func_77973_b() && (par2ItemStack.func_77952_i() == Short.MAX_VALUE || par2ItemStack.func_77952_i() == par1ItemStack.func_77952_i());
    }

    public Map<ItemStack, ItemStack[]> getCrystallizationList() {
        return this.crystallizationList;
    }

    public float getExperience(ItemStack par1ItemStack) {
        float ret = par1ItemStack.func_77973_b().getSmeltingExperience(par1ItemStack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.areStacksEqual(par1ItemStack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

