/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft;

import com.shinoow.abyssalcraft.common.CommonProxy;
import com.shinoow.abyssalcraft.common.command.CommandUnlockAllKnowledge;
import com.shinoow.abyssalcraft.common.handlers.IMCHandler;
import com.shinoow.abyssalcraft.common.util.ACLogger;
import com.shinoow.abyssalcraft.init.BlockHandler;
import com.shinoow.abyssalcraft.init.EntityHandler;
import com.shinoow.abyssalcraft.init.ILifeCycleHandler;
import com.shinoow.abyssalcraft.init.InitHandler;
import com.shinoow.abyssalcraft.init.IntegrationHandler;
import com.shinoow.abyssalcraft.init.ItemHandler;
import com.shinoow.abyssalcraft.init.MiscHandler;
import com.shinoow.abyssalcraft.init.WorldHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid="abyssalcraft", name="AbyssalCraft", version="1.9.10", dependencies="required-after:forge@[14.23.4.2747,);after:jei@[4.11.0,)", useMetadata=false, guiFactory="com.shinoow.abyssalcraft.client.config.ACGuiFactory", acceptedMinecraftVersions="[1.12.2]", updateJSON="https://raw.githubusercontent.com/Shinoow/AbyssalCraft/master/version.json", certificateFingerprint="220f10d3a93b3ff5fbaa7434cc629d863d6751b9")
public class AbyssalCraft {
    public static final String version = "1.9.10";
    public static final String modid = "abyssalcraft";
    public static final String name = "AbyssalCraft";
    @Mod.Metadata(value="abyssalcraft")
    public static ModMetadata metadata;
    @Mod.Instance(value="abyssalcraft")
    public static AbyssalCraft instance;
    @SidedProxy(clientSide="com.shinoow.abyssalcraft.client.ClientProxy", serverSide="com.shinoow.abyssalcraft.common.CommonProxy")
    public static CommonProxy proxy;
    private static List<ILifeCycleHandler> handlers;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        handlers.forEach(handler -> handler.preInit(event));
        proxy.preInit();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        proxy.init();
        handlers.forEach(handler -> handler.init(event));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        handlers.forEach(handler -> handler.postInit(event));
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        handlers.forEach(handler -> handler.loadComplete(event));
    }

    @Mod.EventHandler
    public void serverStart(FMLServerAboutToStartEvent event) {
        InitHandler.INSTANCE.serverStart(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandUnlockAllKnowledge());
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        IMCHandler.handleIMC(event);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        ACLogger.warning("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!", new Object[0]);
    }

    static {
        instance = new AbyssalCraft();
        handlers = new ArrayList<ILifeCycleHandler>(){
            {
                this.add(InitHandler.INSTANCE);
                this.add(new BlockHandler());
                this.add(new WorldHandler());
                this.add(new ItemHandler());
                this.add(new MiscHandler());
                this.add(new EntityHandler());
                this.add(new IntegrationHandler());
            }
        };
        FluidRegistry.enableUniversalBucket();
    }
}

