/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.darktower;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFBossSpawner;
import twilightforest.block.BlockTFLog;
import twilightforest.block.BlockTFTowerDevice;
import twilightforest.block.TFBlocks;
import twilightforest.enums.BossVariant;
import twilightforest.enums.TowerDeviceVariant;
import twilightforest.enums.WoodVariant;
import twilightforest.item.TFItems;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.StructureTFComponentOld;
import twilightforest.structures.StructureTFDecorator;
import twilightforest.structures.TFMaze;
import twilightforest.structures.darktower.ComponentTFDarkTowerBossBridge;
import twilightforest.structures.darktower.ComponentTFDarkTowerEntranceBridge;
import twilightforest.structures.darktower.ComponentTFDarkTowerMainBridge;
import twilightforest.structures.darktower.ComponentTFDarkTowerWing;
import twilightforest.structures.darktower.EnumDarkTowerDoor;
import twilightforest.structures.darktower.StructureDecoratorDarkTower;
import twilightforest.util.RotationUtil;
import twilightforest.util.TFEntityNames;
import twilightforest.util.VanillaEntityNames;
import twilightforest.world.feature.TFGenSmallRainboak;
import twilightforest.world.feature.TFGenSmallTwilightOak;

public class ComponentTFDarkTowerMain
extends ComponentTFDarkTowerWing {
    private boolean placedKeys = false;

    public ComponentTFDarkTowerMain() {
    }

    public ComponentTFDarkTowerMain(TFFeature feature, World world, Random rand, int index, int x, int y, int z) {
        this(feature, world, rand, index, x + 10, y, z + 10, EnumFacing.NORTH);
    }

    public ComponentTFDarkTowerMain(TFFeature feature, World world, Random rand, int index, int x, int y, int z, EnumFacing rotation) {
        super(feature, index, x, y, z, 19, 56 + rand.nextInt(32) / 5 * 5, rotation);
        if (this.field_74887_e.field_78894_e > 245) {
            int amtToLower = (this.field_74887_e.field_78894_e - 245) / 5 * 5 + 5;
            TwilightForestMod.LOGGER.info("[TwilightForest] Lowering Dark Tower max height by %d to be within world bounds", (Object)amtToLower);
            this.height -= amtToLower;
            this.field_74887_e.field_78894_e -= amtToLower;
        }
        if (this.deco == null) {
            this.deco = new StructureDecoratorDarkTower();
        }
    }

    @Override
    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random rand) {
        int childHeight;
        int[] dest;
        if (parent != null && parent instanceof StructureTFComponentOld) {
            this.deco = ((StructureTFComponentOld)parent).deco;
        }
        if (this.func_74877_c() > 0) {
            this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        }
        Rotation mainDir = null;
        if (this.func_74877_c() < 2) {
            mainDir = RotationUtil.ROTATIONS[rand.nextInt(RotationUtil.ROTATIONS.length)];
            for (Rotation rotation : RotationUtil.ROTATIONS) {
                if (rotation == mainDir) continue;
                dest = this.getValidOpening(rand, rotation);
                childHeight = this.validateChildHeight(21 + rand.nextInt(10), 11);
                this.makeTowerWing(list, rand, this.func_74877_c(), dest[0], dest[1], dest[2], 11, childHeight, rotation);
            }
        } else {
            for (Rotation i : RotationUtil.ROTATIONS) {
                dest = this.getValidOpening(rand, i);
                this.makeBossTrapWing(list, rand, this.func_74877_c(), dest[0], dest[1], dest[2], i);
            }
        }
        if (this.func_74877_c() > 0) {
            for (Rotation i : RotationUtil.ROTATIONS) {
                if (i == Rotation.CLOCKWISE_180) continue;
                dest = this.getValidOpening(rand, i);
                dest[1] = 1;
                childHeight = this.validateChildHeight(21 + rand.nextInt(10), 11);
                this.makeTowerWing(list, rand, this.func_74877_c(), dest[0], dest[1], dest[2], 11, childHeight, i);
            }
            this.makeABeard(parent, list, rand);
        } else {
            for (Rotation rotation : new Rotation[]{Rotation.NONE, Rotation.CLOCKWISE_180}) {
                dest = this.getValidOpening(rand, rotation);
                dest[1] = 1;
                childHeight = this.validateChildHeight(10 + rand.nextInt(5), 9);
                this.makeEntranceTower(list, rand, 5, dest[0], dest[1], dest[2], 9, childHeight, rotation);
            }
        }
        if (mainDir != null) {
            int[] dest2 = this.getValidOpening(rand, mainDir);
            this.makeNewLargeTower(list, rand, this.func_74877_c() + 1, dest2[0], dest2[1], dest2[2], mainDir);
        }
        this.makeARoof(parent, list, rand);
        if (!this.placedKeys && this.func_74877_c() < 2) {
            ArrayList<ComponentTFDarkTowerWing> possibleKeyTowers = new ArrayList<ComponentTFDarkTowerWing>();
            for (StructureComponent piece : list) {
                if (!(piece instanceof ComponentTFDarkTowerWing)) continue;
                ComponentTFDarkTowerWing wing = (ComponentTFDarkTowerWing)piece;
                if (wing.size != 9 || wing.func_74877_c() != this.func_74877_c()) continue;
                possibleKeyTowers.add(wing);
            }
            for (int i = 0; i < 4; ++i) {
                if (possibleKeyTowers.size() < 1) {
                    TwilightForestMod.LOGGER.warn("[TwilightForest] Dark forest tower could not find four small towers to place keys in.");
                    break;
                }
                int towerNum = rand.nextInt(possibleKeyTowers.size());
                ((ComponentTFDarkTowerWing)((Object)possibleKeyTowers.get(towerNum))).setKeyTower(true);
                possibleKeyTowers.remove(towerNum);
            }
            this.placedKeys = true;
        }
    }

    private boolean makeEntranceTower(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int childSize, int childHeight, Rotation rotation) {
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        ComponentTFDarkTowerEntranceBridge bridge = new ComponentTFDarkTowerEntranceBridge(this.getFeatureType(), index, dx[0], dx[1], dx[2], childSize, childHeight, direction);
        list.add(bridge);
        bridge.func_74861_a(this, list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }

    private boolean makeNewLargeTower(List<StructureComponent> list, Random rand, int index, int x, int y, int z, Rotation rotation) {
        int wingSize = 15;
        int wingHeight = 56;
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        ComponentTFDarkTowerMainBridge bridge = new ComponentTFDarkTowerMainBridge(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.add(bridge);
        bridge.func_74861_a(this, list, rand);
        this.addOpening(x, y, z, rotation, EnumDarkTowerDoor.LOCKED);
        return true;
    }

    private boolean makeBossTrapWing(List<StructureComponent> list, Random rand, int index, int x, int y, int z, Rotation rotation) {
        int wingSize = 11;
        int wingHeight = 9;
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        ComponentTFDarkTowerBossBridge bridge = new ComponentTFDarkTowerBossBridge(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        list.add(bridge);
        bridge.func_74861_a(this, list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }

    @Override
    public void makeARoof(StructureComponent parent, List<StructureComponent> list, Random rand) {
        if (this.func_74877_c() < 2) {
            super.makeARoof(parent, list, rand);
        }
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.makeEncasedWalls(world, rand, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        this.func_74878_a(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        if (this.func_74877_c() == 0) {
            for (int x = 0; x < this.size; ++x) {
                for (int z = 0; z < this.size; ++z) {
                    this.func_175811_a(world, this.deco.accentState, x, -1, z, sbb);
                }
            }
        }
        this.nullifySkyLightForBoundingBox(world);
        int totalFloors = this.height / 5;
        boolean beamMaze = decoRNG.nextBoolean();
        int centerFloors = beamMaze ? 4 : totalFloors / 2;
        int bottomFloors = (totalFloors - centerFloors) / 2;
        centerFloors = totalFloors - bottomFloors * 2;
        int topFloorsStartY = this.height - (bottomFloors * 5 + 1);
        this.addThreeQuarterFloors(world, decoRNG, sbb, 0, bottomFloors * 5);
        if (this.func_74877_c() < 2) {
            this.addThreeQuarterFloors(world, decoRNG, sbb, topFloorsStartY, this.height - 1);
        } else {
            this.addThreeQuarterFloorsDecorateBoss(world, decoRNG, sbb, topFloorsStartY, this.height - 1);
            this.destroyTower(world, decoRNG, 12, this.height + 4, 3, 4, sbb);
            this.destroyTower(world, decoRNG, 3, this.height + 4, 12, 4, sbb);
            this.destroyTower(world, decoRNG, 3, this.height + 4, 3, 4, sbb);
            this.destroyTower(world, decoRNG, 12, this.height + 4, 12, 4, sbb);
            this.destroyTower(world, decoRNG, 8, this.height + 4, 8, 5, sbb);
            this.decorateBossSpawner(world, decoRNG, sbb, Rotation.NONE, this.height - 6);
        }
        if (beamMaze) {
            this.addTimberMaze(world, decoRNG, sbb, bottomFloors * 5, topFloorsStartY);
        } else {
            this.addBuilderPlatforms(world, decoRNG, sbb, bottomFloors * 5, topFloorsStartY);
        }
        this.makeOpenings(world, sbb);
        return true;
    }

    protected void addThreeQuarterFloors(World world, Random decoRNG, StructureBoundingBox sbb, int bottom, int top) {
        int spacing = 5;
        Rotation rotation = RotationUtil.ROTATIONS[(this.field_74887_e.field_78895_b + bottom) % 4];
        if (bottom == 0) {
            this.makeLargeStairsUp(world, sbb, rotation, 0);
            rotation = rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
            this.makeBottomEntrance(world, decoRNG, sbb, rotation, bottom);
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            boolean isBottomFloor = y == bottom && bottom != spacing;
            boolean isTopFloor = y >= top - spacing;
            boolean isTowerTopFloor = y >= this.height - spacing - 2;
            this.makeThreeQuarterFloor(world, sbb, rotation, y, isBottomFloor, isTowerTopFloor);
            if (!isTopFloor) {
                this.makeLargeStairsUp(world, sbb, rotation, y);
            }
            if (!isTopFloor || isTowerTopFloor) {
                this.decorateFloor(world, decoRNG, sbb, rotation, y, isBottomFloor, isTopFloor);
            }
            rotation = rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
        }
    }

    protected void addThreeQuarterFloorsDecorateBoss(World world, Random decoRNG, StructureBoundingBox sbb, int bottom, int top) {
        int spacing = 5;
        Rotation rotation = RotationUtil.ROTATIONS[(this.field_74887_e.field_78895_b + bottom) % 4];
        if (bottom == 0) {
            this.makeLargeStairsUp(world, sbb, rotation, 0);
            rotation = rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            boolean isBottomFloor = y == bottom && bottom != spacing;
            boolean isTopFloor = y >= top - spacing;
            boolean isTowerTopFloor = y >= this.height - spacing - 2;
            this.makeThreeQuarterFloor(world, sbb, rotation, y, isBottomFloor, isTowerTopFloor);
            if (!isTopFloor) {
                this.makeLargeStairsUp(world, sbb, rotation, y);
                this.decorateExperiment(world, decoRNG, sbb, rotation, y);
            }
            rotation = rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
        }
    }

    private void decorateFloor(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y, boolean isBottom, boolean isTop) {
        if (isTop) {
            switch (decoRNG.nextInt(3)) {
                default: {
                    this.decorateAquarium(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 1: {
                    this.decorateBotanical(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 2: {
                    this.decorateNetherwart(world, decoRNG, sbb, rotation, y, isTop);
                    break;
                }
            }
        } else if (isBottom) {
            switch (decoRNG.nextInt(4)) {
                default: {
                    this.decorateAquarium(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 1: {
                    this.decorateBotanical(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 2: {
                    if (y + this.field_74887_e.field_78895_b > 64) {
                        this.decorateNetherwart(world, decoRNG, sbb, rotation, y, isTop);
                        break;
                    }
                }
                case 3: {
                    this.decorateForge(world, decoRNG, sbb, rotation, y);
                    break;
                }
            }
        } else {
            switch (decoRNG.nextInt(8)) {
                default: {
                    this.decorateReappearingMaze(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 2: {
                    this.decorateUnbuilderMaze(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 3: {
                    this.decorateAquarium(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 4: {
                    this.decorateBotanical(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 5: {
                    if (y + this.field_74887_e.field_78895_b > 64) {
                        this.decorateNetherwart(world, decoRNG, sbb, rotation, y, isTop);
                        break;
                    }
                }
                case 6: {
                    this.decorateLounge(world, decoRNG, sbb, rotation, y);
                    break;
                }
                case 7: {
                    this.decorateForge(world, decoRNG, sbb, rotation, y);
                }
            }
        }
    }

    protected void makeThreeQuarterFloor(World world, StructureBoundingBox sbb, Rotation rotation, int y, boolean isBottom, boolean isTowerTopFloor) {
        int half = this.size / 2;
        this.fillBlocksRotated(world, sbb, half + 1, y, 1, this.size - 2, y, half + 1, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 1, y, half + 1, this.size - 2, y, this.size - 2, this.deco.blockState, rotation);
        int startZ = isBottom ? 1 : 3;
        this.fillBlocksRotated(world, sbb, 1, y, half, half, y, half, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, half, y, startZ, half, y, half, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, 1, y + 1, half, half, y + 1, half, this.deco.fenceState, rotation);
        this.fillBlocksRotated(world, sbb, half, y + 1, startZ, half, y + 1, half, this.deco.fenceState, rotation);
        if (isTowerTopFloor) {
            this.fillBlocksRotated(world, sbb, 1, y + 0, half - 2, 3, y + 0, half, this.deco.accentState, rotation);
            this.fillBlocksRotated(world, sbb, 1, y + 1, half - 2, 3, y + 1, half, this.deco.fenceState, rotation);
            this.fillBlocksRotated(world, sbb, 1, y + 0, half - 1, 2, y + 0, half, this.deco.fenceState, rotation);
            this.fillBlocksRotated(world, sbb, 1, y + 1, half - 1, 2, y + 1, half, AIR, rotation);
        }
    }

    protected void makeLargeStairsUp(World world, StructureBoundingBox sbb, Rotation rotation, int y) {
        for (int i = 0; i < 5; ++i) {
            int z = this.size / 2 - i + 4;
            int sy = y + i + 1;
            this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), 1, sy, z, rotation, sbb);
            this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), 2, sy, z, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, 1, sy, z - 1, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, 2, sy, z - 1, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, 3, sy, z - 1, rotation, sbb);
            if (i > 0 && i < 4) {
                this.setBlockStateRotated(world, this.deco.accentState, 3, sy, z, rotation, sbb);
                this.setBlockStateRotated(world, this.deco.fenceState, 3, sy + 1, z, rotation, sbb);
                this.setBlockStateRotated(world, this.deco.fenceState, 3, sy + 2, z, rotation, sbb);
                continue;
            }
            if (i != 0) continue;
            this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, false), 3, sy, z, rotation, sbb);
        }
    }

    private void decorateReappearingMaze(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y) {
        int mazeSize = 6;
        TFMaze maze = new TFMaze(mazeSize, mazeSize);
        maze.setSeed(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 90342903) + (long)(y * 90342903) ^ (long)this.field_74887_e.field_78896_c);
        for (int i = 0; i < 13; ++i) {
            maze.putRaw(i, 0, 5);
            maze.putRaw(i, 12, 5);
            maze.putRaw(0, i, 5);
            maze.putRaw(12, i, 5);
        }
        maze.doorRarity = 0.3f;
        switch (rotation) {
            case NONE: {
                int x;
                for (x = 1; x < 6; ++x) {
                    for (int z = 1; z < 6; ++z) {
                        maze.putRaw(x, z, 5);
                    }
                }
                maze.putRaw(1, 6, 5);
                maze.putRaw(1, 7, 5);
                maze.putRaw(1, 8, 5);
                maze.putRaw(1, 9, 5);
                maze.putRaw(1, 10, 6);
                maze.putRaw(6, 1, 5);
                maze.putRaw(7, 1, 5);
                maze.putRaw(8, 1, 6);
                maze.generateRecursiveBacktracker(0, 5);
                break;
            }
            case CLOCKWISE_90: {
                int x;
                for (x = 7; x < 12; ++x) {
                    for (int z = 1; z < 6; ++z) {
                        maze.putRaw(x, z, 5);
                    }
                }
                maze.putRaw(6, 1, 5);
                maze.putRaw(5, 1, 5);
                maze.putRaw(4, 1, 5);
                maze.putRaw(3, 1, 5);
                maze.putRaw(2, 1, 6);
                maze.putRaw(11, 6, 5);
                maze.putRaw(11, 7, 5);
                maze.putRaw(11, 8, 6);
                maze.generateRecursiveBacktracker(0, 0);
                break;
            }
            case CLOCKWISE_180: {
                int x;
                for (x = 7; x < 12; ++x) {
                    for (int z = 7; z < 12; ++z) {
                        maze.putRaw(x, z, 5);
                    }
                }
                maze.putRaw(11, 6, 5);
                maze.putRaw(11, 5, 5);
                maze.putRaw(11, 4, 5);
                maze.putRaw(11, 3, 5);
                maze.putRaw(11, 2, 6);
                maze.putRaw(6, 11, 5);
                maze.putRaw(5, 11, 5);
                maze.putRaw(4, 11, 6);
                maze.generateRecursiveBacktracker(5, 0);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                int x;
                for (x = 1; x < 6; ++x) {
                    for (int z = 7; z < 12; ++z) {
                        maze.putRaw(x, z, 5);
                    }
                }
                maze.putRaw(6, 11, 5);
                maze.putRaw(7, 11, 5);
                maze.putRaw(8, 11, 5);
                maze.putRaw(9, 11, 5);
                maze.putRaw(10, 11, 6);
                maze.putRaw(1, 6, 5);
                maze.putRaw(1, 5, 5);
                maze.putRaw(1, 4, 6);
                maze.generateRecursiveBacktracker(5, 5);
            }
        }
        maze.wallBlockState = this.deco.blockState;
        maze.headBlockState = this.deco.accentState;
        maze.pillarBlockState = this.deco.accentState;
        maze.doorBlockState = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.REAPPEARING_INACTIVE));
        maze.torchRarity = 0.0f;
        maze.tall = 3;
        maze.head = 1;
        maze.oddBias = 2;
        maze.copyToStructure(world, 0, y + 1, 0, this, sbb);
        this.decorateMazeDeadEnds(world, decoRNG, maze, y, rotation, sbb);
    }

    protected void decorateMazeDeadEnds(World world, Random decoRNG, TFMaze maze, int y, Rotation rotation, StructureBoundingBox sbb) {
        for (int x = 0; x < maze.width; ++x) {
            for (int z = 0; z < maze.depth; ++z) {
                if (!maze.isWall(x, z, x - 1, z) && maze.isWall(x, z, x + 1, z) && maze.isWall(x, z, x, z - 1) && maze.isWall(x, z, x, z + 1)) {
                    this.decorateDeadEnd(world, decoRNG, maze, x, y, z, 3, rotation, sbb);
                }
                if (maze.isWall(x, z, x - 1, z) && !maze.isWall(x, z, x + 1, z) && maze.isWall(x, z, x, z - 1) && maze.isWall(x, z, x, z + 1)) {
                    this.decorateDeadEnd(world, decoRNG, maze, x, y, z, 1, rotation, sbb);
                }
                if (maze.isWall(x, z, x - 1, z) && maze.isWall(x, z, x + 1, z) && !maze.isWall(x, z, x, z - 1) && maze.isWall(x, z, x, z + 1)) {
                    this.decorateDeadEnd(world, decoRNG, maze, x, y, z, 0, rotation, sbb);
                }
                if (!maze.isWall(x, z, x - 1, z) || !maze.isWall(x, z, x + 1, z) || !maze.isWall(x, z, x, z - 1) || maze.isWall(x, z, x, z + 1)) continue;
                this.decorateDeadEnd(world, decoRNG, maze, x, y, z, 2, rotation, sbb);
            }
        }
    }

    private void decorateDeadEnd(World world, Random decoRNG, TFMaze maze, int mx, int y, int mz, int facing, Rotation rotation, StructureBoundingBox sbb) {
        int x = mx * 3 + 1;
        int z = mz * 3 + 1;
        switch (facing) {
            case 0: {
                this.func_175811_a(world, this.deco.accentState, x + 0, y + 1, z + 1, sbb);
                this.func_175811_a(world, this.deco.accentState, x + 1, y + 1, z + 1, sbb);
                this.func_175811_a(world, Blocks.field_150486_ae.func_176223_P(), x + 0, y + 2, z + 1, sbb);
                this.placeTreasureAtCurrentPosition(world, decoRNG, x + 1, y + 2, z + 1, TFTreasure.darktower_cache, sbb);
                break;
            }
            case 1: {
                this.func_175811_a(world, this.deco.accentState, x + 0, y + 1, z + 0, sbb);
                this.func_175811_a(world, this.deco.accentState, x + 0, y + 1, z + 1, sbb);
                this.func_175811_a(world, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH), x + 0, y + 2, z + 0, sbb);
                this.placeTreasureAtCurrentPosition(world, decoRNG, x + 0, y + 2, z + 1, TFTreasure.darktower_cache, sbb);
                break;
            }
            case 2: {
                this.func_175811_a(world, this.deco.accentState, x + 0, y + 1, z + 0, sbb);
                this.func_175811_a(world, this.deco.accentState, x + 1, y + 1, z + 0, sbb);
                this.func_175811_a(world, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH), x + 0, y + 2, z + 0, sbb);
                this.placeTreasureAtCurrentPosition(world, decoRNG, x + 1, y + 2, z + 0, TFTreasure.darktower_cache, sbb);
                break;
            }
            case 3: {
                this.func_175811_a(world, this.deco.accentState, x + 1, y + 1, z + 0, sbb);
                this.func_175811_a(world, this.deco.accentState, x + 1, y + 1, z + 1, sbb);
                this.func_175811_a(world, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH), x + 1, y + 2, z + 0, sbb);
                this.placeTreasureAtCurrentPosition(world, decoRNG, x + 1, y + 2, z + 1, TFTreasure.darktower_cache, sbb);
            }
        }
    }

    private void decorateUnbuilderMaze(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y) {
        for (int x = this.size / 2; x < this.size - 1; ++x) {
            for (int z = 3; z < this.size - 1; ++z) {
                int py;
                if (x % 2 == 1 && z % 2 == 1) {
                    for (py = 1; py < 5; ++py) {
                        this.setBlockStateRotated(world, this.deco.pillarState, x, y + py, z, rotation, sbb);
                    }
                    continue;
                }
                if (x % 2 != 1 && z % 2 != 1) continue;
                for (py = 1; py < 5; ++py) {
                    this.setBlockStateRotated(world, this.deco.fenceState, x, y + py, z, rotation, sbb);
                }
                if (x == this.size / 2 || x == this.size - 2 || z == this.size - 2) continue;
                int ay = decoRNG.nextInt(4) + 1;
                this.setBlockStateRotated(world, AIR, x, y + ay, z, rotation, sbb);
                if (x <= this.size - 7) continue;
                ay = decoRNG.nextInt(3) + 1;
                this.setBlockStateRotated(world, AIR, x, y + ay, z, rotation, sbb);
            }
        }
        IBlockState antiBuilderBlockState = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.ANTIBUILDER));
        this.setBlockStateRotated(world, antiBuilderBlockState, 15, y + 2, 7, rotation, sbb);
        this.setBlockStateRotated(world, antiBuilderBlockState, 11, y + 3, 7, rotation, sbb);
        this.setBlockStateRotated(world, antiBuilderBlockState, 15, y + 2, 13, rotation, sbb);
        this.setBlockStateRotated(world, antiBuilderBlockState, 11, y + 3, 13, rotation, sbb);
        this.setBlockStateRotated(world, antiBuilderBlockState, 5, y + 3, 13, rotation, sbb);
    }

    private void decorateLounge(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y) {
        this.fillBlocksRotated(world, sbb, 17, y + 1, 1, 17, y + 4, 6, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 1, 17, y + 4, 1, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 2, 16, y + 1, 5, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 2, 12, y + 1, 6, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 6, 16, y + 1, 6, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), rotation);
        this.makeDispenserPillar(world, this.deco, 13, y, 1, EnumFacing.SOUTH, rotation, sbb);
        this.makeDispenserPillar(world, this.deco, 15, y, 1, EnumFacing.SOUTH, rotation, sbb);
        this.makeDispenserPillar(world, this.deco, 17, y, 3, EnumFacing.WEST, rotation, sbb);
        this.makeDispenserPillar(world, this.deco, 17, y, 5, EnumFacing.WEST, rotation, sbb);
        this.makeStonePillar(world, this.deco, 12, y, 1, EnumFacing.NORTH, rotation, sbb);
        this.makeStonePillar(world, this.deco, 17, y, 6, EnumFacing.EAST, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150382_bo.func_176223_P(), 13, y + 2, 5, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150383_bp.func_176223_P().func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(3)), 15, y + 2, 3, rotation, sbb);
        this.fillBlocksRotated(world, sbb, 10, y + 1, 17, 17, y + 4, 17, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 10, 17, y + 4, 17, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 11, y + 1, 17, 12, y + 4, 17, Blocks.field_150342_X.func_176223_P(), rotation);
        this.fillBlocksRotated(world, sbb, 14, y + 1, 17, 15, y + 4, 17, Blocks.field_150342_X.func_176223_P(), rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 11, 17, y + 4, 12, Blocks.field_150342_X.func_176223_P(), rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 14, 17, y + 4, 15, Blocks.field_150342_X.func_176223_P(), rotation);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, true), 13, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, true), 14, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, true), 14, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, true), 13, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, false), 11, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), 13, y + 1, 11, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150379_bu.func_176223_P(), 8, y + 3, 8, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), decoRNG.nextBoolean() ? BlockLever.EnumOrientation.DOWN_X : BlockLever.EnumOrientation.DOWN_Z, rotation, false), 8, y + 2, 8, rotation, sbb);
        this.placeTreePlanter(world, decoRNG.nextInt(5), 6, y + 1, 12, rotation, sbb);
    }

    private void makeDispenserPillar(World world, StructureTFDecorator forgeDeco, int x, int y, int z, EnumFacing stairMeta, Rotation rotation, StructureBoundingBox sbb) {
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(forgeDeco.stairState, stairMeta, rotation, true), x, y + 2, z, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150367_z.func_176223_P().func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)stairMeta), x, y + 3, z, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(forgeDeco.stairState, stairMeta, rotation, false), x, y + 4, z, rotation, sbb);
    }

    private void decorateBossSpawner(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y) {
        this.setBlockStateRotated(world, TFBlocks.bossSpawner.func_176223_P().func_177226_a(BlockTFBossSpawner.VARIANT, (Comparable)((Object)BossVariant.UR_GHAST)), 9, y + 4, 9, rotation, sbb);
    }

    private void decorateExperiment(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y) {
        IBlockState obsidian = Blocks.field_150343_Z.func_176223_P();
        IBlockState netherrack = Blocks.field_150424_aL.func_176223_P();
        IBlockState redstone = Blocks.field_150451_bX.func_176223_P();
        IBlockState inactiveReactor = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.REACTOR_INACTIVE));
        this.fillBlocksRotated(world, sbb, 17, y + 1, 1, 17, y + 4, 6, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 1, 17, y + 4, 1, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 2, 16, y + 1, 5, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 2, 12, y + 1, 6, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 6, 16, y + 1, 6, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), rotation);
        this.makeWoodPillar(world, this.deco, 13, y, 1, rotation, sbb);
        this.makeWoodPillar(world, this.deco, 15, y, 1, rotation, sbb);
        this.makeWoodPillar(world, this.deco, 17, y, 3, rotation, sbb);
        this.makeWoodPillar(world, this.deco, 17, y, 5, rotation, sbb);
        this.makeStonePillar(world, this.deco, 12, y, 1, EnumFacing.NORTH, rotation, sbb);
        this.makeStonePillar(world, this.deco, 17, y, 6, EnumFacing.EAST, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150462_ai.func_176223_P(), 14, y + 2, 4, rotation, sbb);
        this.placeItemFrameRotated(world, 13, y + 2, 1, rotation, EnumFacing.SOUTH, new ItemStack(TFItems.borer_essence), sbb);
        this.placeItemFrameRotated(world, 14, y + 2, 1, rotation, EnumFacing.SOUTH, new ItemStack(Items.field_151137_ax), sbb);
        this.placeItemFrameRotated(world, 15, y + 2, 1, rotation, EnumFacing.SOUTH, new ItemStack(TFItems.borer_essence), sbb);
        this.placeItemFrameRotated(world, 13, y + 3, 1, rotation, EnumFacing.SOUTH, new ItemStack(Items.field_151137_ax), sbb);
        this.placeItemFrameRotated(world, 14, y + 3, 1, rotation, EnumFacing.SOUTH, new ItemStack(Items.field_151073_bk), sbb);
        this.placeItemFrameRotated(world, 15, y + 3, 1, rotation, EnumFacing.SOUTH, new ItemStack(Items.field_151137_ax), sbb);
        this.placeItemFrameRotated(world, 13, y + 4, 1, rotation, EnumFacing.SOUTH, new ItemStack(TFItems.borer_essence), sbb);
        this.placeItemFrameRotated(world, 14, y + 4, 1, rotation, EnumFacing.SOUTH, new ItemStack(Items.field_151137_ax), sbb);
        this.placeItemFrameRotated(world, 15, y + 4, 1, rotation, EnumFacing.SOUTH, new ItemStack(TFItems.borer_essence), sbb);
        this.placeItemFrameRotated(world, 17, y + 2, 3, rotation, EnumFacing.WEST, new ItemStack(TFBlocks.tower_wood, 1, 1), sbb);
        this.placeItemFrameRotated(world, 17, y + 2, 4, rotation, EnumFacing.WEST, new ItemStack(TFBlocks.tower_wood, 1, 0), sbb);
        this.placeItemFrameRotated(world, 17, y + 2, 5, rotation, EnumFacing.WEST, new ItemStack(TFBlocks.tower_wood, 1, 1), sbb);
        this.placeItemFrameRotated(world, 17, y + 3, 3, rotation, EnumFacing.WEST, new ItemStack(TFBlocks.tower_wood, 1, 0), sbb);
        this.placeItemFrameRotated(world, 17, y + 3, 4, rotation, EnumFacing.WEST, new ItemStack(TFItems.carminite), sbb);
        this.placeItemFrameRotated(world, 17, y + 3, 5, rotation, EnumFacing.WEST, new ItemStack(TFBlocks.tower_wood, 1, 0), sbb);
        this.placeItemFrameRotated(world, 17, y + 4, 3, rotation, EnumFacing.WEST, new ItemStack(TFBlocks.tower_wood, 1, 1), sbb);
        this.placeItemFrameRotated(world, 17, y + 4, 4, rotation, EnumFacing.WEST, new ItemStack(TFBlocks.tower_wood, 1, 0), sbb);
        this.placeItemFrameRotated(world, 17, y + 4, 5, rotation, EnumFacing.WEST, new ItemStack(TFBlocks.tower_wood, 1, 1), sbb);
        if (y < this.height - 13) {
            this.setBlockStateRotated(world, obsidian, 13, y + 1, 13, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 15, y + 1, 13, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 13, y + 1, 15, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 15, y + 1, 15, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 13, y + 1, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 14, y + 1, 13, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 15, y + 1, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 14, y + 1, 15, rotation, sbb);
            this.setBlockStateRotated(world, redstone, 14, y + 1, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 13, y + 2, 13, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 15, y + 2, 13, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 13, y + 2, 15, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 15, y + 2, 15, rotation, sbb);
            this.setBlockStateRotated(world, inactiveReactor, 14, y + 2, 14, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 13, y + 3, 13, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 15, y + 3, 13, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 13, y + 3, 15, rotation, sbb);
            this.setBlockStateRotated(world, obsidian, 15, y + 3, 15, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 13, y + 3, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 14, y + 3, 13, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 15, y + 3, 14, rotation, sbb);
            this.setBlockStateRotated(world, netherrack, 14, y + 3, 15, rotation, sbb);
            this.setBlockStateRotated(world, redstone, 14, y + 3, 14, rotation, sbb);
        }
        this.setBlockStateRotated(world, this.deco.accentState, 14, y + 1, 17, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), BlockLever.EnumOrientation.EAST, rotation, false), 13, y + 1, 17, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150331_J.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.SOUTH), 14, y + 2, 17, rotation, sbb);
        this.setBlockStateRotated(world, redstone, 14, y + 2, 16, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 17, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), BlockLever.EnumOrientation.SOUTH, rotation, false), 17, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150331_J.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.EAST), 17, y + 2, 14, rotation, sbb);
        this.setBlockStateRotated(world, redstone, 16, y + 2, 14, rotation, sbb);
        this.setBlockStateRotated(world, redstone, 14, y + 2, 11, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 14, y + 1, 11, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), BlockLever.EnumOrientation.EAST, rotation, true), 13, y + 1, 11, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150331_J.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.NORTH), 14, y + 2, 10, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 14, y + 1, 9, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), BlockLever.EnumOrientation.EAST, rotation, false), 13, y + 1, 9, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.NORTH), 14, y + 2, 9, rotation, sbb);
        this.setBlockStateRotated(world, redstone, 11, y + 2, 14, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 11, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), BlockLever.EnumOrientation.SOUTH, rotation, true), 11, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150331_J.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.WEST), 10, y + 2, 14, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 9, y + 1, 14, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), BlockLever.EnumOrientation.SOUTH, rotation, false), 9, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)EnumFacing.WEST), 9, y + 2, 14, rotation, sbb);
    }

    private void makeWoodPillar(World world, StructureTFDecorator forgeDeco, int x, int y, int z, Rotation rotation, StructureBoundingBox sbb) {
        IBlockState log = TFBlocks.twilight_log.func_176223_P().func_177226_a(BlockTFLog.VARIANT, (Comparable)((Object)WoodVariant.DARK));
        this.setBlockStateRotated(world, log, x, y + 2, z, rotation, sbb);
        this.setBlockStateRotated(world, log, x, y + 3, z, rotation, sbb);
        this.setBlockStateRotated(world, log, x, y + 4, z, rotation, sbb);
    }

    private void placeItemFrameRotated(World world, int x, int y, int z, Rotation rotation, EnumFacing direction, ItemStack itemStack, StructureBoundingBox sbb) {
        EnumFacing facing;
        int dz;
        int dy;
        int dx = this.getXWithOffsetRotated(x, z, rotation);
        BlockPos pos = new BlockPos(dx, dy = this.func_74862_a(y), dz = this.getZWithOffsetRotated(x, z, rotation)).func_177972_a(facing = this.field_186169_c.func_185830_a(rotation).func_185831_a(direction).func_176734_d());
        if (sbb.func_175898_b((Vec3i)pos)) {
            EntityItemFrame frame = new EntityItemFrame(world, pos, facing);
            if (!itemStack.func_190926_b()) {
                frame.func_82334_a(itemStack);
            }
            world.func_72838_d((Entity)frame);
        }
    }

    private void decorateAquarium(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y) {
        this.makePillarFrame(world, sbb, this.deco, rotation, 12, y, 3, 4, 4, 13, false);
        this.fillBlocksRotated(world, sbb, 13, y + 4, 4, 14, y + 4, 14, Blocks.field_150358_i.func_176223_P(), rotation);
        this.makePillarFrame(world, sbb, this.deco, rotation, 6, y, 12, 4, 4, 4, false);
        this.fillBlocksRotated(world, sbb, 6, y + 5, 12, 9, y + 5, 15, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, 7, y + 4, 13, 8, y + 5, 14, Blocks.field_150358_i.func_176223_P(), rotation);
    }

    private void decorateForge(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y) {
        StructureTFDecorator forgeDeco = this.deco;
        this.fillBlocksRotated(world, sbb, 17, y + 1, 1, 17, y + 4, 6, forgeDeco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 1, 17, y + 4, 1, forgeDeco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 17, 17, y + 4, 17, forgeDeco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 17, y + 1, 12, 17, y + 4, 17, forgeDeco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 2, 16, y + 1, 5, forgeDeco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 2, 12, y + 1, 6, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 6, 16, y + 1, 6, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 13, 16, y + 1, 16, forgeDeco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 12, 12, y + 1, 16, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), rotation);
        this.fillBlocksRotated(world, sbb, 12, y + 1, 12, 16, y + 1, 12, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false), rotation);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 13, y, 1, EnumFacing.SOUTH, rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 15, y, 1, EnumFacing.SOUTH, rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 17, y, 3, EnumFacing.WEST, rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 17, y, 5, EnumFacing.WEST, rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 13, y, 17, EnumFacing.NORTH, rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 15, y, 17, EnumFacing.NORTH, rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 17, y, 13, EnumFacing.WEST, rotation, sbb);
        this.makeFurnacePillar(world, forgeDeco, decoRNG, 17, y, 15, EnumFacing.WEST, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 17, y, 6, EnumFacing.WEST, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 12, y, 17, EnumFacing.NORTH, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 17, y, 12, EnumFacing.WEST, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 17, y, 9, EnumFacing.WEST, rotation, sbb);
        this.makeStonePillar(world, forgeDeco, 9, y, 17, EnumFacing.NORTH, rotation, sbb);
        IBlockState anvil = Blocks.field_150467_bQ.func_176223_P().func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(decoRNG.nextInt(2))).func_177226_a((IProperty)BlockAnvil.field_176506_a, (Comparable)EnumFacing.field_176754_o[decoRNG.nextInt(4)]);
        this.setBlockStateRotated(world, anvil, 13, y + 2, 5, rotation, sbb);
        anvil = Blocks.field_150467_bQ.func_176223_P().func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(decoRNG.nextInt(2))).func_177226_a((IProperty)BlockAnvil.field_176506_a, (Comparable)EnumFacing.field_176754_o[decoRNG.nextInt(4)]);
        this.setBlockStateRotated(world, anvil, 13, y + 2, 13, rotation, sbb);
        this.makeFirePit(world, forgeDeco, 6, y + 1, 12, rotation, sbb);
    }

    private void makeFurnacePillar(World world, StructureTFDecorator forgeDeco, Random rand, int x, int y, int z, EnumFacing direction, Rotation rotation, StructureBoundingBox sbb) {
        int dz;
        int dy;
        int dx;
        BlockPos pos;
        int amount;
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, direction, rotation, true), x, y + 2, z, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150460_al.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)direction), x, y + 3, z, rotation, sbb);
        int n = amount = rand.nextBoolean() ? rand.nextInt(5) + 4 : 0;
        if (amount > 0 && sbb.func_175898_b((Vec3i)(pos = new BlockPos(dx = this.getXWithOffsetRotated(x, z, rotation), dy = this.func_74862_a(y + 3), dz = this.getZWithOffsetRotated(x, z, rotation)))) && world.func_180495_p(pos).func_177230_c() == Blocks.field_150460_al) {
            IInventory inv = (IInventory)world.func_175625_s(pos);
            inv.func_70299_a(1, new ItemStack(Items.field_151044_h, amount, 1));
        }
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, direction, rotation, false), x, y + 4, z, rotation, sbb);
    }

    private void makeStonePillar(World world, StructureTFDecorator forgeDeco, int x, int y, int z, EnumFacing stairDirection, Rotation rotation, StructureBoundingBox sbb) {
        for (int py = 1; py <= 4; ++py) {
            this.setBlockStateRotated(world, forgeDeco.pillarState, x, y + py, z, rotation, sbb);
        }
    }

    private void makeFirePit(World world, StructureTFDecorator myDeco, int x, int y, int z, Rotation rotation, StructureBoundingBox sbb) {
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), x - 1, y, z + 0, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, false), x + 1, y, z + 0, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), x + 0, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false), x + 0, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, myDeco.pillarState, x + 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, myDeco.pillarState, x + 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, myDeco.pillarState, x - 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, myDeco.pillarState, x - 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150424_aL.func_176223_P(), x, y, z, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150480_ab.func_176223_P(), x, y + 1, z, rotation, sbb);
    }

    private void decorateNetherwart(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y, boolean isTop) {
        StructureTFDecorator netherDeco = this.deco;
        this.makePillarFrame(world, sbb, netherDeco, rotation, 12, y, 9, 4, 4, 7, true);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 10, 14, y + 1, 14, Blocks.field_150425_aM.func_176223_P(), rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 2, 10, 14, y + 2, 14, Blocks.field_150388_bm.func_176223_P(), rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 4, 10, 14, y + 4, 14, Blocks.field_150425_aM.func_176223_P(), rotation);
        this.makePillarFrame(world, sbb, netherDeco, rotation, 5, y, 12, 3, isTop ? 4 : 9, 3, true);
        this.setBlockStateRotated(world, netherDeco.blockState, 6, y + 1, 13, rotation, sbb);
        this.setBlockStateRotated(world, netherDeco.blockState, 6, y + (isTop ? 4 : 9), 13, rotation, sbb);
        this.setSpawnerRotated(world, 6, y + 3, 13, rotation, VanillaEntityNames.BLAZE, sbb);
        this.destroyTower(world, decoRNG, 12, y, 3, 2, sbb);
    }

    private void decorateBotanical(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y) {
        this.makePillarFrame(world, sbb, this.deco, rotation, 12, y, 12, 4, 4, 4, true);
        this.fillBlocksRotated(world, sbb, 13, y + 1, 13, 14, y + 1, 14, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, 13, y + 4, 13, 14, y + 4, 14, this.deco.blockState, rotation);
        this.placeRandomPlant(world, decoRNG, 13, y + 2, 13, rotation, sbb);
        this.placeRandomPlant(world, decoRNG, 13, y + 2, 14, rotation, sbb);
        this.placeRandomPlant(world, decoRNG, 14, y + 2, 13, rotation, sbb);
        this.placeRandomPlant(world, decoRNG, 14, y + 2, 14, rotation, sbb);
        for (int py = 1; py <= 4; ++py) {
            this.setBlockStateRotated(world, this.deco.pillarState, 12, y + py, 4, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.pillarState, 15, y + py, 4, rotation, sbb);
        }
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, true), 13, y + 1, 4, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, true), 14, y + 1, 4, rotation, sbb);
        this.placeTreasureRotated(world, 13, y + 2, 4, rotation, TFTreasure.basement, sbb);
        this.setBlockStateRotated(world, Blocks.field_150462_ai.func_176223_P(), 14, y + 2, 4, rotation, sbb);
        IBlockState slab = Blocks.field_150376_bx.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP).func_177226_a((IProperty)BlockWoodSlab.field_176557_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, true), 12, y + 1, 7, rotation, sbb);
        this.setBlockStateRotated(world, slab, 13, y + 1, 7, rotation, sbb);
        this.setBlockStateRotated(world, slab, 14, y + 1, 7, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, true), 15, y + 1, 7, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, true), 12, y + 1, 10, rotation, sbb);
        this.setBlockStateRotated(world, slab, 13, y + 1, 10, rotation, sbb);
        this.setBlockStateRotated(world, slab, 14, y + 1, 10, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, true), 15, y + 1, 10, rotation, sbb);
        for (int x = 12; x <= 15; ++x) {
            this.placeRandomPlant(world, decoRNG, x, y + 2, 7, rotation, sbb);
            this.placeRandomPlant(world, decoRNG, x, y + 2, 10, rotation, sbb);
        }
        this.placeTreePlanter(world, decoRNG.nextInt(5), 6, y + 1, 12, rotation, sbb);
    }

    private void placeTreePlanter(World world, int treeNum, int x, int y, int z, Rotation rotation, StructureBoundingBox sbb) {
        this.setBlockStateRotated(world, this.deco.pillarState, x + 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.pillarState, x + 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.pillarState, x - 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.pillarState, x - 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), x - 1, y, z + 0, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, false), x + 1, y, z + 0, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), x + 0, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false), x + 0, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150346_d.func_176223_P(), x, y, z, rotation, sbb);
        int dx = this.getXWithOffsetRotated(x, z, rotation);
        int dy = this.func_74862_a(y + 1);
        int dz = this.getZWithOffsetRotated(x, z, rotation);
        if (sbb.func_175898_b((Vec3i)new BlockPos(dx, dy, dz))) {
            Object treeGen;
            switch (treeNum) {
                default: {
                    treeGen = new WorldGenTrees(false);
                    break;
                }
                case 1: {
                    IBlockState leaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE);
                    IBlockState wood = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
                    treeGen = new WorldGenTrees(true, 3, wood, leaves, false);
                    break;
                }
                case 2: {
                    treeGen = new WorldGenBirchTree(true, false);
                    break;
                }
                case 3: {
                    treeGen = new TFGenSmallTwilightOak(false);
                    break;
                }
                case 4: {
                    treeGen = new TFGenSmallRainboak(false);
                }
            }
            for (int i = 0; i < 100 && !treeGen.func_180709_b(world, world.field_73012_v, new BlockPos(dx, dy, dz)); ++i) {
            }
        }
    }

    private void placeRandomPlant(World world, Random decoRNG, int x, int y, int z, Rotation rotation, StructureBoundingBox sbb) {
        int potMeta = decoRNG.nextInt(15);
        IBlockState flowerPotState = Blocks.field_150457_bL.func_176223_P().func_177226_a((IProperty)BlockFlowerPot.field_176444_a, (Comparable)Integer.valueOf(potMeta));
        this.setBlockStateRotated(world, flowerPotState, x, y, z, rotation, sbb);
    }

    private void makeBottomEntrance(World world, Random decoRNG, StructureBoundingBox sbb, Rotation rotation, int y) {
        this.makeFirePit(world, this.deco, 13, y + 1, 3, rotation, sbb);
        this.makeFirePit(world, this.deco, 3, y + 1, 13, rotation, sbb);
        this.makeFirePit(world, this.deco, 13, y + 1, 13, rotation, sbb);
        this.makePillarFrame(world, sbb, this.deco, rotation, 7, y, 7, 3, 4, 3, false);
    }

    protected void addTimberMaze(World world, Random rand, StructureBoundingBox sbb, int bottom, int top) {
        int spacing = 5;
        Rotation floorside = Rotation.NONE;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            floorside = floorside.func_185830_a(Rotation.CLOCKWISE_90);
            this.makeTimberBeams(world, rand, sbb, floorside, y, y == bottom && bottom != spacing, y >= top - spacing, top);
        }
    }

    protected void makeTimberBeams(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y, boolean isBottom, boolean isTop, int top) {
        int x;
        int z;
        IBlockState beamID = TFBlocks.twilight_log.func_176223_P();
        IBlockState beamStateNS = beamID.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
        IBlockState beamStateUD = beamID.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
        IBlockState beamStateEW = beamID.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        for (z = 1; z < this.size - 1; ++z) {
            this.setBlockStateRotated(world, beamStateNS, 4, y, z, rotation, sbb);
            this.setBlockStateRotated(world, beamStateNS, 9, y, z, rotation, sbb);
            this.setBlockStateRotated(world, beamStateNS, 14, y, z, rotation, sbb);
        }
        z = this.pickBetweenExcluding(3, this.size - 3, rand, 4, 9, 14);
        for (x = 5; x < 9; ++x) {
            this.setBlockStateRotated(world, beamStateEW, x, y, z, rotation, sbb);
        }
        z = this.pickBetweenExcluding(3, this.size - 3, rand, 4, 9, 14);
        for (x = 10; x < 14; ++x) {
            this.setBlockStateRotated(world, beamStateEW, x, y, z, rotation, sbb);
        }
        int x1 = 4;
        int z1 = this.pickFrom(rand, 4, 9, 14);
        int x2 = 9;
        int z2 = this.pickFrom(rand, 4, 9, 14);
        int x3 = 14;
        int z3 = this.pickFrom(rand, 4, 9, 14);
        for (int by = 1; by < 5; ++by) {
            if (!isBottom || this.checkPost(world, x1, y - 5, z1, rotation, sbb)) {
                this.setBlockStateRotated(world, beamStateUD, x1, y - by, z1, rotation, sbb);
                this.setBlockStateRotated(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST), x1 + 1, y - by, z1, rotation, sbb);
            }
            if (!isBottom || this.checkPost(world, x2, y - 5, z2, rotation, sbb)) {
                this.setBlockStateRotated(world, beamStateUD, x2, y - by, z2, rotation, sbb);
            }
            if (isBottom && !this.checkPost(world, x3, y - 5, z3, rotation, sbb)) continue;
            this.setBlockStateRotated(world, beamStateUD, x3, y - by, z3, rotation, sbb);
            this.setBlockStateRotated(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.EAST), x3 - 1, y - by, z3, rotation, sbb);
        }
        if (isTop) {
            Rotation topFloorRotation = RotationUtil.ROTATIONS[(this.field_74887_e.field_78895_b + top + 1) % 4];
            int ladderX = 4;
            int ladderZ = 10;
            for (int by = 1; by < 5; ++by) {
                this.setBlockStateRotated(world, beamStateUD, ladderX, y + by, 9, topFloorRotation, sbb);
                this.setBlockStateRotated(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.NORTH), ladderX, y + by, ladderZ, topFloorRotation, sbb);
            }
            this.setBlockStateRotated(world, AIR, ladderX, y + 6, 9, topFloorRotation, sbb);
            this.setBlockStateRotated(world, this.deco.fenceState, ladderX + 1, y + 5, ladderZ, topFloorRotation, sbb);
            this.setBlockStateRotated(world, this.deco.fenceState, ladderX - 1, y + 5, ladderZ, topFloorRotation, sbb);
            this.setBlockStateRotated(world, this.deco.fenceState, ladderX + 1, y + 6, ladderZ, topFloorRotation, sbb);
            this.setBlockStateRotated(world, this.deco.fenceState, ladderX - 1, y + 6, ladderZ, topFloorRotation, sbb);
        }
        if (!isBottom && !isTop) {
            int sx = this.pickFrom(rand, 6, 7, 11);
            int sz = this.pickFrom(rand, 6, 11, 12);
            this.makeMiniGhastSpawner(world, rand, y, sx, sz, sbb);
        }
        int lx = this.pickFrom(rand, 2, 12, 16);
        int lz = 2 + rand.nextInt(15);
        this.setBlockStateRotated(world, Blocks.field_150379_bu.func_176223_P(), lx, y + 2, lz, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), rand.nextBoolean() ? BlockLever.EnumOrientation.DOWN_X : BlockLever.EnumOrientation.DOWN_Z, rotation, false), lx, y + 1, lz, rotation, sbb);
    }

    private void makeMiniGhastSpawner(World world, Random rand, int y, int sx, int sz, StructureBoundingBox sbb) {
        TileEntityMobSpawner spawner = this.setSpawner(world, sx, y + 2, sz, sbb, TFEntityNames.MINI_GHAST);
        if (spawner != null) {
            NBTTagCompound tags = new NBTTagCompound();
            spawner.func_189515_b(tags);
            tags.func_74777_a("SpawnRange", (short)16);
            tags.func_74777_a("MaxNearbyEntities", (short)2);
            tags.func_74777_a("SpawnCount", (short)1);
            spawner.func_145839_a(tags);
        }
    }

    protected void addBuilderPlatforms(World world, Random rand, StructureBoundingBox sbb, int bottom, int top) {
        int y;
        int spacing = 5;
        Rotation floorside = Rotation.NONE;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (y = bottom; y < top - spacing; y += spacing) {
            this.makeBuilderPlatforms(world, rand, sbb, floorside, y, y == bottom && bottom != spacing, y >= top - spacing);
            floorside = floorside.func_185830_a(Rotation.CLOCKWISE_90);
            floorside = floorside.func_185830_a(RotationUtil.ROTATIONS[rand.nextInt(3)]);
        }
        this.makeBuilderPlatform(world, rand, Rotation.CLOCKWISE_90, bottom, 5, true, sbb);
        this.makeBuilderPlatform(world, rand, Rotation.COUNTERCLOCKWISE_90, bottom, 5, true, sbb);
        for (y = bottom - 4; y < bottom; ++y) {
            this.setBlockStateRotated(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST), 1, y, 5, Rotation.CLOCKWISE_90, sbb);
            this.setBlockStateRotated(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST), 1, y, 5, Rotation.COUNTERCLOCKWISE_90, sbb);
        }
        this.addTopBuilderPlatform(world, rand, bottom, top, spacing, sbb);
    }

    protected void makeBuilderPlatforms(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y, boolean bottom, boolean top) {
        int z = this.size / 2 + rand.nextInt(5) - rand.nextInt(5);
        this.makeBuilderPlatform(world, rand, rotation, y, z, false, sbb);
        this.setBlockStateRotated(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST), 1, y + 1, z, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST), 1, y + 2, z, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST), 1, y + 3, z, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST), 1, y + 4, z, rotation, sbb);
        this.makeBuilderPlatform(world, rand, rotation, y + 5, z, true, sbb);
        if (y % 2 == 1) {
            int sx = this.pickFrom(rand, 5, 9, 13);
            int sz = sx == 9 ? (rand.nextBoolean() ? 5 : 13) : 9;
            IBlockState antibuilder = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.ANTIBUILDER));
            this.setBlockStateRotated(world, antibuilder, sx, y + 2, sz, rotation, sbb);
        } else {
            int sx = rand.nextBoolean() ? 5 : 13;
            int sz = rand.nextBoolean() ? 5 : 13;
            this.makeLampCluster(world, rand, sx, y, sz, rotation, sbb);
        }
    }

    private void addTopBuilderPlatform(World world, Random rand, int bottom, int top, int spacing, StructureBoundingBox sbb) {
        Rotation rotation = RotationUtil.ROTATIONS[(this.field_74887_e.field_78895_b + top + 1) % 4];
        this.fillBlocksRotated(world, sbb, 5, top - spacing, 9, 7, top - spacing, 11, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, 6, top - spacing, 9, 6, top, 9, this.deco.accentState, rotation);
        this.fillBlocksRotated(world, sbb, 6, top - spacing + 1, 10, 6, top - 1, 10, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.NORTH), rotation);
        this.setBlockStateRotated(world, AIR, 6, top + 1, 9, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.fenceState, 5, top + 0, 10, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.fenceState, 7, top + 0, 10, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.fenceState, 5, top + 1, 10, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.fenceState, 7, top + 1, 10, rotation, sbb);
        IBlockState inactiveBuilder = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE));
        this.setBlockStateRotated(world, inactiveBuilder, 7, top - spacing, 10, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), rand.nextBoolean() ? BlockLever.EnumOrientation.UP_Z : BlockLever.EnumOrientation.UP_X, rotation, false), 7, top - spacing + 1, 11, rotation, sbb);
    }

    private void makeBuilderPlatform(World world, Random rand, Rotation rotation, int y, int z, boolean hole, StructureBoundingBox sbb) {
        this.setBlockStateRotated(world, this.deco.accentState, 1, y, z - 1, rotation, sbb);
        if (!hole) {
            this.setBlockStateRotated(world, this.deco.accentState, 1, y, z - 0, rotation, sbb);
        }
        this.setBlockStateRotated(world, this.deco.accentState, 1, y, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 2, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 2, y, z - 0, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, 2, y, z + 1, rotation, sbb);
        IBlockState inactiveBuilder = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE));
        this.setBlockStateRotated(world, inactiveBuilder, 2, y, hole ? z + 1 : z - 1, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), rand.nextBoolean() ? BlockLever.EnumOrientation.UP_Z : BlockLever.EnumOrientation.UP_X, rotation, false), 2, y + 1, z + 0, rotation, sbb);
    }

    private void makeLampCluster(World world, Random rand, int sx, int y, int sz, Rotation rotation, StructureBoundingBox sbb) {
        int lz;
        int ly;
        int lx;
        int i;
        int radius = 4;
        block7: for (i = 0; i < 5; ++i) {
            lx = sx;
            ly = y;
            lz = sz;
            for (int move = 0; move < 10; ++move) {
                EnumFacing facing;
                this.setBlockStateRotated(world, Blocks.field_150379_bu.func_176223_P(), lx, ly, lz, rotation, sbb);
                int direction = rand.nextInt(8);
                if (direction > 5) {
                    direction -= 2;
                }
                if ((lx += (facing = EnumFacing.field_82609_l[direction]).func_82601_c()) > sx + radius || lx < sx - radius || (ly += facing.func_96559_d()) > y + radius || ly < y - radius || (lz += facing.func_82599_e()) > sz + radius || lz < sz - radius) continue block7;
            }
        }
        block9: for (i = 0; i < 5; ++i) {
            EnumFacing direction;
            int move;
            lx = sx;
            ly = y;
            lz = sz;
            EnumFacing[] directions = new EnumFacing[10];
            for (move = 0; move < 10; ++move) {
                int direction2 = rand.nextInt(8);
                if (direction2 > 5) {
                    direction2 -= 2;
                }
                directions[move] = EnumFacing.field_82609_l[direction2];
            }
            for (move = 0; move < 10 && (lx += (direction = directions[move]).func_82601_c()) <= sx + radius && lx >= sx - radius && (ly += direction.func_96559_d()) <= y + radius && ly >= y - radius && (lz += direction.func_82599_e()) <= sz + radius && lz >= sz - radius; ++move) {
                BlockLever.EnumOrientation orientation;
                if (this.getBlockStateFromPosRotated(world, lx, ly, lz, sbb, rotation).func_177230_c() == Blocks.field_150379_bu) continue;
                switch (direction) {
                    case NORTH: {
                        orientation = BlockLever.EnumOrientation.SOUTH;
                        break;
                    }
                    case SOUTH: {
                        orientation = BlockLever.EnumOrientation.NORTH;
                        break;
                    }
                    case EAST: {
                        orientation = BlockLever.EnumOrientation.WEST;
                        break;
                    }
                    case WEST: {
                        orientation = BlockLever.EnumOrientation.EAST;
                        break;
                    }
                    case UP: {
                        orientation = BlockLever.EnumOrientation.UP_Z;
                        break;
                    }
                    default: {
                        orientation = BlockLever.EnumOrientation.DOWN_X;
                    }
                }
                this.setBlockStateRotated(world, ComponentTFDarkTowerMain.getLeverState(Blocks.field_150442_at.func_176223_P(), orientation, rotation, false), lx, ly, lz, rotation, sbb);
                continue block9;
            }
        }
    }
}

