/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import twilightforest.TwilightForestMod;
import twilightforest.client.texture.GradientMappedTexture;
import twilightforest.client.texture.GradientNode;

public class MoltenFieryTexture
extends TextureAtlasSprite {
    private final ResourceLocation textureDependency;
    private float minimumValue;
    private float maximumValue;
    private static final GradientNode[] GRADIENT_MAP = new GradientNode[]{new GradientNode(0.0f, -16251386), new GradientNode(0.2f, -15133933), new GradientNode(0.7f, -12836061)};

    public MoltenFieryTexture(ResourceLocation textureDependency, ResourceLocation spriteName) {
        super(spriteName.toString());
        this.textureDependency = textureDependency;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        int i;
        TextureAtlasSprite sprite = textureGetter.apply(this.textureDependency);
        this.func_94217_a(sprite);
        this.field_110982_k = sprite.field_110982_k;
        this.field_110976_a = Lists.newArrayList();
        int minimumValue = 255;
        int maximumValue = 0;
        for (i = 0; i < sprite.func_110970_k(); ++i) {
            int[][] textureFrom = (int[][])sprite.func_147965_a(i).clone();
            int[][] textureTo = new int[textureFrom.length][];
            for (int j = 0; j < textureFrom.length; ++j) {
                textureTo[j] = new int[textureFrom[j].length];
                System.arraycopy(textureFrom[j], 0, textureTo[j], 0, textureFrom[j].length);
            }
            for (int pixel : textureTo[0]) {
                if ((pixel >> 24 & 0xFF) == 0) continue;
                minimumValue = Math.min(minimumValue, MoltenFieryTexture.getPerceptualBrightness(pixel));
                maximumValue = Math.max(maximumValue, MoltenFieryTexture.getPerceptualBrightness(pixel));
            }
            this.field_110976_a.add(i, textureTo);
        }
        if (minimumValue > maximumValue) {
            this.minimumValue = (float)maximumValue / 255.0f;
            this.maximumValue = (float)minimumValue / 255.0f;
        } else {
            this.minimumValue = (float)minimumValue / 255.0f;
            this.maximumValue = (float)maximumValue / 255.0f;
        }
        for (i = 0; i < this.field_110976_a.size(); ++i) {
            int[][] texture = (int[][])this.field_110976_a.get(i);
            for (int l = 0; l < texture.length; ++l) {
                for (int j = 0; j < texture[l].length; ++j) {
                    texture[l][j] = GradientMappedTexture.getGradient(texture[l][j], GRADIENT_MAP, this.minimumValue, this.maximumValue);
                }
            }
        }
        TwilightForestMod.LOGGER.debug("Autogenerated " + this.func_94215_i() + " from " + this.textureDependency);
        return false;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of((Object)this.textureDependency);
    }

    private static int getPerceptualBrightness(int col) {
        return MoltenFieryTexture.getPerceptualBrightness((double)(col >> 16 & 0xFF) / 255.0, (double)(col >> 8 & 0xFF) / 255.0, (double)(col & 0xFF) / 255.0);
    }

    private static int getPerceptualBrightness(double r, double g, double b) {
        return (int)(Math.sqrt(0.241 * r * r + 0.691 * g * g + 0.068 * b * b) * 255.0);
    }
}

