/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twilightforest.block.BlockTFAuroraBrick;
import twilightforest.block.BlockTFAuroraPillar;
import twilightforest.block.BlockTFAuroraSlab;
import twilightforest.block.BlockTFAuroralizedGlass;
import twilightforest.block.BlockTFBossSpawner;
import twilightforest.block.BlockTFBurntThorns;
import twilightforest.block.BlockTFCastleBlock;
import twilightforest.block.BlockTFCastleDoor;
import twilightforest.block.BlockTFCastleMagic;
import twilightforest.block.BlockTFCastlePillar;
import twilightforest.block.BlockTFCastleStairs;
import twilightforest.block.BlockTFCastleUnlock;
import twilightforest.block.BlockTFCicada;
import twilightforest.block.BlockTFCinderFurnace;
import twilightforest.block.BlockTFCinderLog;
import twilightforest.block.BlockTFCompressed;
import twilightforest.block.BlockTFDarkLeaves;
import twilightforest.block.BlockTFDeadrock;
import twilightforest.block.BlockTFExperiment115;
import twilightforest.block.BlockTFFireJet;
import twilightforest.block.BlockTFFirefly;
import twilightforest.block.BlockTFFireflyJar;
import twilightforest.block.BlockTFFluffyCloud;
import twilightforest.block.BlockTFFluid;
import twilightforest.block.BlockTFForceField;
import twilightforest.block.BlockTFGiantCobble;
import twilightforest.block.BlockTFGiantLeaves;
import twilightforest.block.BlockTFGiantLog;
import twilightforest.block.BlockTFGiantObsidian;
import twilightforest.block.BlockTFHedge;
import twilightforest.block.BlockTFHugeGloomBlock;
import twilightforest.block.BlockTFHugeLilyPad;
import twilightforest.block.BlockTFHugeStalk;
import twilightforest.block.BlockTFHugeWaterLily;
import twilightforest.block.BlockTFKnightmetalBlock;
import twilightforest.block.BlockTFLapisBlock;
import twilightforest.block.BlockTFLeaves;
import twilightforest.block.BlockTFLeaves3;
import twilightforest.block.BlockTFLog;
import twilightforest.block.BlockTFMagicLeaves;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.block.BlockTFMagicLogSpecial;
import twilightforest.block.BlockTFMazestone;
import twilightforest.block.BlockTFMiniatureStructure;
import twilightforest.block.BlockTFMoonworm;
import twilightforest.block.BlockTFNagastone;
import twilightforest.block.BlockTFNagastoneEtched;
import twilightforest.block.BlockTFNagastonePillar;
import twilightforest.block.BlockTFNagastoneStairs;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.BlockTFPortal;
import twilightforest.block.BlockTFRipeTorchCluster;
import twilightforest.block.BlockTFRoots;
import twilightforest.block.BlockTFSapling;
import twilightforest.block.BlockTFShield;
import twilightforest.block.BlockTFSlider;
import twilightforest.block.BlockTFSpiralBrick;
import twilightforest.block.BlockTFStairs;
import twilightforest.block.BlockTFThornRose;
import twilightforest.block.BlockTFThorns;
import twilightforest.block.BlockTFTowerDevice;
import twilightforest.block.BlockTFTowerTranslucent;
import twilightforest.block.BlockTFTowerWood;
import twilightforest.block.BlockTFTrollRoot;
import twilightforest.block.BlockTFTrollSteinn;
import twilightforest.block.BlockTFTrophy;
import twilightforest.block.BlockTFTrophyPedestal;
import twilightforest.block.BlockTFUberousSoil;
import twilightforest.block.BlockTFUncraftingTable;
import twilightforest.block.BlockTFUnderBrick;
import twilightforest.block.BlockTFUnripeTorchCluster;
import twilightforest.block.BlockTFWispyCloud;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.enums.CastleBrickVariant;

@Mod.EventBusSubscriber(modid="twilightforest")
public final class RegisterBlockEvent {
    public static final Fluid moltenFiery;
    public static final Fluid moltenKnightmetal;
    public static final Fluid essenceFiery;
    public static final ResourceLocation moltenFieryStill;
    public static final ResourceLocation moltenFieryFlow;
    public static final ResourceLocation moltenKnightmetalStill;
    public static final ResourceLocation moltenKnightmetalFlow;
    public static final ResourceLocation essenceFieryStill;
    public static final ResourceLocation essenceFieryFlow;

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        BlockRegistryHelper blocks = new BlockRegistryHelper((IForgeRegistry<Block>)event.getRegistry());
        blocks.register("twilight_log", "Log", (Block)new BlockTFLog());
        blocks.register("root", "Roots", new BlockTFRoots());
        blocks.register("twilight_leaves", "Leaves", (Block)new BlockTFLeaves());
        blocks.register("firefly", "Firefly", new BlockTFFirefly());
        blocks.register("cicada", "Cicada", new BlockTFCicada());
        blocks.register("twilight_portal", "Portal", (Block)new BlockTFPortal());
        blocks.register("maze_stone", "Mazestone", new BlockTFMazestone());
        blocks.register("hedge", "Hedge", new BlockTFHedge());
        blocks.register("boss_spawner", "BossSpawner", new BlockTFBossSpawner().func_149722_s());
        blocks.register("firefly_jar", "FireflyJar", new BlockTFFireflyJar());
        blocks.register("twilight_plant", "Plant", (Block)new BlockTFPlant());
        blocks.register("uncrafting_table", "UncraftingTable", new BlockTFUncraftingTable());
        blocks.register("fire_jet", "FireJet", new BlockTFFireJet());
        blocks.register("naga_stone", "Nagastone", new BlockTFNagastone());
        blocks.register("twilight_sapling", "Sapling", (Block)new BlockTFSapling());
        blocks.register("moonworm", "Moonworm", new BlockTFMoonworm());
        blocks.register("magic_log", "MagicLog", (Block)new BlockTFMagicLog());
        blocks.register("magic_leaves", "MagicLeaves", (Block)new BlockTFMagicLeaves());
        blocks.register("magic_log_core", "MagicLogSpecial", (Block)new BlockTFMagicLogSpecial());
        blocks.register("tower_wood", "TowerStone", new BlockTFTowerWood());
        blocks.register("tower_device", "TowerDevice", new BlockTFTowerDevice());
        blocks.register("tower_translucent", "TowerTranslucent", new BlockTFTowerTranslucent());
        blocks.register("trophy", "Trophy", (Block)new BlockTFTrophy());
        blocks.register("stronghold_shield", "Shield", new BlockTFShield());
        blocks.register("trophy_pedestal", "TrophyPedestal", new BlockTFTrophyPedestal());
        blocks.register("aurora_block", "AuroraBrick", new BlockTFAuroraBrick());
        blocks.register("underbrick", "UnderBrick", new BlockTFUnderBrick());
        blocks.register("thorns", "Thorns", (Block)new BlockTFThorns());
        blocks.register("burnt_thorns", "BurntThorns", (Block)new BlockTFBurntThorns());
        blocks.register("thorn_rose", "ThornRose", new BlockTFThornRose());
        blocks.register("twilight_leaves_3", "Leaves3", (Block)new BlockTFLeaves3());
        blocks.register("deadrock", "Deadrock", new BlockTFDeadrock());
        blocks.register("dark_leaves", "DarkLeaves", new BlockTFDarkLeaves());
        blocks.register("aurora_pillar", "AuroraPillar", (Block)new BlockTFAuroraPillar());
        blocks.register("aurora_slab", "AuroraSlab", (Block)new BlockTFAuroraSlab(false));
        blocks.register("double_aurora_slab", "AuroraDoubleSlab", (Block)new BlockTFAuroraSlab(true));
        blocks.register("trollsteinn", "TrollSteinn", new BlockTFTrollSteinn());
        blocks.register("wispy_cloud", "WispyCloud", (Block)new BlockTFWispyCloud());
        blocks.register("fluffy_cloud", "FluffyCloud", new BlockTFFluffyCloud());
        blocks.register("giant_cobblestone", "GiantCobble", new BlockTFGiantCobble());
        blocks.register("giant_log", "GiantLog", new BlockTFGiantLog());
        blocks.register("giant_leaves", "GiantLeaves", new BlockTFGiantLeaves());
        blocks.register("giant_obsidian", "GiantObsidian", new BlockTFGiantObsidian());
        blocks.register("uberous_soil", "UberousSoil", new BlockTFUberousSoil());
        blocks.register("huge_stalk", "HugeStalk", new BlockTFHugeStalk());
        blocks.register("huge_mushgloom", "HugeGloomBlock", (Block)new BlockTFHugeGloomBlock());
        blocks.register("trollvidr", "TrollVidr", new BlockTFTrollRoot());
        blocks.register("unripe_trollber", "UnripeTrollBer", new BlockTFUnripeTorchCluster());
        blocks.register("trollber", "TrollBer", new BlockTFRipeTorchCluster());
        blocks.register("knightmetal_block", "KnightmetalBlock", new BlockTFKnightmetalBlock());
        blocks.register("huge_lilypad", "HugeLilyPad", (Block)new BlockTFHugeLilyPad());
        blocks.register("huge_waterlily", "HugeWaterLily", (Block)new BlockTFHugeWaterLily());
        blocks.register("slider", "Slider", (Block)new BlockTFSlider());
        BlockTFCastleBlock castleBrick = new BlockTFCastleBlock();
        IBlockState castleState = castleBrick.func_176223_P();
        blocks.register("castle_brick", "CastleBrick", castleBrick);
        blocks.register("castle_stairs_brick", "CastleStairsBrick", (Block)new BlockTFStairs(castleState));
        blocks.register("castle_stairs_worn", "CastleStairsWorn", (Block)new BlockTFStairs(castleState.func_177226_a(BlockTFCastleBlock.VARIANT, (Comparable)((Object)CastleBrickVariant.WORN))));
        blocks.register("castle_stairs_cracked", "CastleStairsCracked", (Block)new BlockTFStairs(castleState.func_177226_a(BlockTFCastleBlock.VARIANT, (Comparable)((Object)CastleBrickVariant.CRACKED))));
        blocks.register("castle_stairs_mossy", "CastleStairsMossy", (Block)new BlockTFStairs(castleState.func_177226_a(BlockTFCastleBlock.VARIANT, (Comparable)((Object)CastleBrickVariant.MOSSY))));
        BlockTFCastlePillar castlePillar = new BlockTFCastlePillar();
        blocks.register("castle_pillar", "CastlePillar", castlePillar);
        blocks.register("castle_stairs", "CastleStairs", (Block)new BlockTFCastleStairs(castlePillar.func_176223_P()));
        blocks.register("castle_rune_brick", "CastleMagic", new BlockTFCastleMagic());
        blocks.register("force_field", "ForceField", (Block)new BlockTFForceField());
        blocks.register("cinder_furnace", "CinderFurnaceIdle", new BlockTFCinderFurnace(false));
        blocks.register("cinder_furnace_lit", "CinderFurnaceLit", new BlockTFCinderFurnace(true));
        blocks.register("cinder_log", "CinderLog", (Block)new BlockTFCinderLog());
        blocks.register("castle_door", "CastleDoor", new BlockTFCastleDoor(false));
        blocks.register("castle_door_vanished", "CastleDoorVanished", new BlockTFCastleDoor(true));
        blocks.register("castle_unlock", "CastleUnlock", new BlockTFCastleUnlock());
        blocks.register("experiment_115", "experiment115", new BlockTFExperiment115().func_149711_c(0.5f));
        blocks.register("miniature_structure", "MiniatureStructure", new BlockTFMiniatureStructure().func_149711_c(0.75f));
        blocks.register("block_storage", "BlockOfStorage", new BlockTFCompressed());
        blocks.register("lapis_block", "BlockOfLapisTF", new BlockTFLapisBlock());
        blocks.register("spiral_bricks", "SpiralBricks", new BlockTFSpiralBrick());
        Block etchedNagastone = new BlockTFNagastoneEtched().func_149711_c(1.5f).func_149752_b(10.0f);
        blocks.register("etched_nagastone", "EtchedNagastone", etchedNagastone);
        blocks.register("nagastone_stairs", "NagastoneStairs", new BlockTFNagastoneStairs(etchedNagastone.func_176223_P()).func_149711_c(1.5f).func_149752_b(10.0f));
        blocks.register("nagastone_pillar", "NagastonePillar", new BlockTFNagastonePillar().func_149711_c(1.5f).func_149752_b(10.0f));
        Block etchedNagastoneMossy = new BlockTFNagastoneEtched().func_149711_c(1.5f).func_149752_b(10.0f);
        blocks.register("etched_nagastone_mossy", "EtchedNagastoneMossy", etchedNagastoneMossy);
        blocks.register("nagastone_stairs_mossy", "NagastoneStairsMossy", new BlockTFNagastoneStairs(etchedNagastoneMossy.func_176223_P()).func_149711_c(1.5f).func_149752_b(10.0f));
        blocks.register("nagastone_pillar_mossy", "NagastonePillarMossy", new BlockTFNagastonePillar().func_149711_c(1.5f).func_149752_b(10.0f));
        Block etchedNagastoneWeathered = new BlockTFNagastoneEtched().func_149711_c(1.5f).func_149752_b(10.0f);
        blocks.register("etched_nagastone_weathered", "EtchedNagastoneWeathered", etchedNagastoneWeathered);
        blocks.register("nagastone_stairs_weathered", "NagastoneStairsWeathered", new BlockTFNagastoneStairs(etchedNagastoneWeathered.func_176223_P()).func_149711_c(1.5f).func_149752_b(10.0f));
        blocks.register("nagastone_pillar_weathered", "NagastonePillarWeathered", new BlockTFNagastonePillar().func_149711_c(1.5f).func_149752_b(10.0f));
        blocks.register("auroralized_glass", "AuroralizedGlass", (Block)new BlockTFAuroralizedGlass());
        RegisterBlockEvent.registerFluidBlock(blocks, moltenFiery);
        RegisterBlockEvent.registerFluidBlock(blocks, moltenKnightmetal);
        RegisterBlockEvent.registerFluidBlock("fiery_essence", blocks, essenceFiery);
    }

    public static List<ModelRegisterCallback> getBlockModels() {
        return ImmutableList.copyOf((Collection)BlockRegistryHelper.blockModels);
    }

    private static Fluid registerFluid(Fluid fluid) {
        fluid.setUnlocalizedName(fluid.getName());
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        return fluid;
    }

    private static void registerFluidBlock(BlockRegistryHelper blocks, Fluid fluid) {
        RegisterBlockEvent.registerFluidBlock("molten_" + fluid.getName(), blocks, fluid);
    }

    private static void registerFluidBlock(String registryName, BlockRegistryHelper blocks, Fluid fluid) {
        Block block = new BlockTFFluid(fluid, Material.field_151587_i).func_149663_c("twilightforest." + fluid.getName()).func_149715_a(1.0f);
        blocks.register(registryName, block);
    }

    static {
        moltenFieryStill = new ResourceLocation("twilightforest", "blocks/molten_fiery_still");
        moltenFieryFlow = new ResourceLocation("twilightforest", "blocks/molten_fiery_flow");
        moltenKnightmetalStill = new ResourceLocation("twilightforest", "blocks/molten_knightmetal_still");
        moltenKnightmetalFlow = new ResourceLocation("twilightforest", "blocks/molten_knightmetal_flow");
        essenceFieryStill = new ResourceLocation("twilightforest", "blocks/fluid_fiery_still");
        essenceFieryFlow = new ResourceLocation("twilightforest", "blocks/fluid_fiery_flow");
        moltenFiery = RegisterBlockEvent.registerFluid(new Fluid("fierymetal", moltenFieryStill, moltenFieryFlow).setTemperature(1000).setLuminosity(15));
        moltenKnightmetal = RegisterBlockEvent.registerFluid(new Fluid("knightmetal", moltenKnightmetalStill, moltenKnightmetalFlow).setTemperature(1000).setLuminosity(15));
        essenceFiery = RegisterBlockEvent.registerFluid(new Fluid("fiery_essence", essenceFieryStill, essenceFieryFlow).setTemperature(1000));
    }

    private static class BlockRegistryHelper {
        private final IForgeRegistry<Block> registry;
        private static List<ModelRegisterCallback> blockModels = new ArrayList<ModelRegisterCallback>();

        BlockRegistryHelper(IForgeRegistry<Block> registry) {
            this.registry = registry;
        }

        void register(String registryName, String translationKey, Block block) {
            block.func_149663_c("twilightforest." + translationKey);
            this.register(registryName, block);
        }

        void register(String registryName, Block block) {
            block.setRegistryName("twilightforest", registryName);
            if (block instanceof ModelRegisterCallback) {
                blockModels.add((ModelRegisterCallback)block);
            }
            this.registry.register((IForgeRegistryEntry)block);
        }
    }
}

