/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.TFBlocks;
import twilightforest.enums.PlantVariant;
import twilightforest.world.TFWorld;
import twilightforest.world.feature.TFGenDarkCanopyTree;
import twilightforest.world.feature.TFGenTallGrass;
import twilightforest.world.feature.TFTreeGenerator;

public class TFDarkForestBiomeDecorator
extends TFBiomeDecorator {
    private TFTreeGenerator darkCanopyTreeGen = new TFGenDarkCanopyTree();
    private TFGenTallGrass worldGenDeadBush = new TFGenTallGrass(TFBlocks.twilight_plant.func_176223_P().func_177226_a(BlockTFPlant.VARIANT, (Comparable)((Object)PlantVariant.DEADBUSH)), 8);
    private TFGenTallGrass worldGenForestGrass = new TFGenTallGrass(TFBlocks.twilight_plant.func_176223_P().func_177226_a(BlockTFPlant.VARIANT, (Comparable)((Object)PlantVariant.FORESTGRASS)));
    private TFGenTallGrass worldGenMushgloom = new TFGenTallGrass(TFBlocks.twilight_plant.func_176223_P().func_177226_a(BlockTFPlant.VARIANT, (Comparable)((Object)PlantVariant.MUSHGLOOM)));

    @Override
    public void func_180292_a(World world, Random rand, Biome biome, BlockPos pos) {
        TFFeature nearFeature = TFFeature.getNearestFeature(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, world);
        if (nearFeature.areChunkDecorationsEnabled) {
            int ry;
            int rz;
            int rx;
            int ry2;
            int rz2;
            int rx2;
            int i;
            int nc = (int)this.canopyPerChunk + (rand.nextFloat() < this.canopyPerChunk - (float)((int)this.canopyPerChunk) ? 1 : 0);
            for (i = 0; i < nc; ++i) {
                rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
                rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
                this.darkCanopyTreeGen.func_180709_b(world, rand, world.func_175645_m(new BlockPos(rx2, 0, rz2)));
            }
            for (i = 0; i < this.field_76832_z; ++i) {
                rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
                rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
                ry2 = this.getGroundLevel(world, new BlockPos(rx2, 0, rz2));
                WorldGenAbstractTree var5 = biome.func_150567_a(rand);
                var5.func_175904_e();
                var5.func_180709_b(world, rand, new BlockPos(rx2, ry2, rz2));
            }
            for (i = 0; i < this.field_76804_C; ++i) {
                rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
                rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
                ry2 = rand.nextInt(128);
                this.worldGenDeadBush.func_180709_b(world, rand, new BlockPos(rx2, ry2, rz2));
            }
            for (i = 0; i < this.field_76804_C; ++i) {
                rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
                rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
                ry2 = rand.nextInt(128);
                this.worldGenForestGrass.func_180709_b(world, rand, new BlockPos(rx2, ry2, rz2));
            }
            for (i = 0; i < this.field_76798_D; ++i) {
                if (rand.nextInt(8) == 0) {
                    rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
                    rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
                    ry2 = this.getGroundLevel(world, new BlockPos(rx2, 0, rz2));
                    this.field_76828_s.func_180709_b(world, rand, new BlockPos(rx2, ry2, rz2));
                }
                if (rand.nextInt(16) == 0) {
                    rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
                    rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
                    ry2 = this.getGroundLevel(world, new BlockPos(rx2, 0, rz2));
                    this.field_76827_t.func_180709_b(world, rand, new BlockPos(rx2, ry2, rz2));
                }
                if (rand.nextInt(24) != 0) continue;
                rx2 = pos.func_177958_n() + rand.nextInt(16) + 8;
                rz2 = pos.func_177952_p() + rand.nextInt(16) + 8;
                ry2 = this.getGroundLevel(world, new BlockPos(rx2, 0, rz2));
                this.worldGenMushgloom.func_180709_b(world, rand, new BlockPos(rx2, ry2, rz2));
            }
            if (rand.nextInt(4) == 0) {
                rx = pos.func_177958_n() + rand.nextInt(16) + 8;
                rz = pos.func_177952_p() + rand.nextInt(16) + 8;
                ry = rand.nextInt(128);
                this.field_76828_s.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
            }
            if (rand.nextInt(8) == 0) {
                rx = pos.func_177958_n() + rand.nextInt(16) + 8;
                rz = pos.func_177952_p() + rand.nextInt(16) + 8;
                ry = rand.nextInt(128);
                this.field_76827_t.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
            }
            if (rand.nextInt(32) == 0) {
                rx = pos.func_177958_n() + rand.nextInt(16) + 8;
                rz = pos.func_177952_p() + rand.nextInt(16) + 8;
                ry = this.getGroundLevel(world, new BlockPos(rx, 0, rz));
                new WorldGenPumpkin().func_180709_b(world, rand, new BlockPos(rx, ry, rz));
            }
        }
        this.decorateUnderground(world, rand, pos);
        this.decorateOnlyOres(world, rand, pos);
    }

    private int getGroundLevel(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        int lastDirt = TFWorld.SEALEVEL;
        for (int y = TFWorld.SEALEVEL; y < TFWorld.CHUNKHEIGHT - 1; ++y) {
            Block blockID = chunk.func_177435_g(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p())).func_177230_c();
            if (blockID == Blocks.field_150349_c) {
                return y + 1;
            }
            if (blockID != Blocks.field_150346_d && blockID != Blocks.field_150348_b && blockID != Blocks.field_150351_n) continue;
            lastDirt = y + 1;
        }
        return lastDirt;
    }
}

