/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.advancements.TFAdvancements;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFPortal;
import twilightforest.block.TFBlocks;
import twilightforest.network.PacketStructureProtection;
import twilightforest.network.PacketStructureProtectionClear;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.StructureBoundingBoxUtils;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.TFWorld;
import twilightforest.world.WorldProviderTwilightForest;

@Mod.EventBusSubscriber(modid="twilightforest")
public class TFTickHandler {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K && !TFConfig.disablePortalCreation && event.phase == TickEvent.Phase.END && player.field_70173_aa % 20 == 0) {
            if (TFConfig.adminOnlyPortals) {
                if (FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_187452_a(player.func_146103_bH()) != 0) {
                    TFTickHandler.checkForPortalCreation(player, world, 4.0f);
                }
            } else {
                TFTickHandler.checkForPortalCreation(player, world, 32.0f);
            }
        }
        if (!world.field_72995_K && event.phase == TickEvent.Phase.END && player.field_70173_aa % 20 == 0 && world.func_82736_K().func_82766_b("tfEnforcedProgression") && world.field_73011_w instanceof WorldProviderTwilightForest && !player.func_184812_l_() && !player.func_175149_v()) {
            TFTickHandler.checkBiomeForProgression(player, world);
        }
        if (!world.field_72995_K && event.phase == TickEvent.Phase.END && player.field_70173_aa % 100 == 0 && world.func_82736_K().func_82766_b("tfEnforcedProgression") && world.field_73011_w instanceof WorldProviderTwilightForest) {
            if (player.func_184812_l_() || player.func_175149_v()) {
                TFTickHandler.sendAllClearPacket(world, player);
            } else {
                TFTickHandler.checkForLockedStructuresSendPacket(player, world);
            }
        }
    }

    private static void sendStructureProtectionPacket(World world, EntityPlayer player, StructureBoundingBox sbb) {
        PacketStructureProtection message = new PacketStructureProtection(sbb);
        if (player instanceof EntityPlayerMP) {
            TFPacketHandler.CHANNEL.sendTo((IMessage)message, (EntityPlayerMP)player);
        }
    }

    private static void sendAllClearPacket(World world, EntityPlayer player) {
        PacketStructureProtectionClear message = new PacketStructureProtectionClear();
        if (player instanceof EntityPlayerMP) {
            TFPacketHandler.CHANNEL.sendTo((IMessage)message, (EntityPlayerMP)player);
        }
    }

    private static boolean checkForLockedStructuresSendPacket(EntityPlayer player, World world) {
        IChunkGenerator uncheckedChunkProvider = TFWorld.getChunkGenerator(world);
        if (!(uncheckedChunkProvider instanceof ChunkGeneratorTFBase)) {
            return false;
        }
        ChunkGeneratorTFBase chunkProvider = (ChunkGeneratorTFBase)uncheckedChunkProvider;
        int px = MathHelper.func_76128_c((double)player.field_70165_t);
        int pz = MathHelper.func_76128_c((double)player.field_70161_v);
        if (chunkProvider != null && chunkProvider.isBlockNearFullStructure(px, pz, 100)) {
            StructureBoundingBox fullSBB = chunkProvider.getFullSBBNear(px, pz, 100);
            Vec3i center = StructureBoundingBoxUtils.getCenter(fullSBB);
            TFFeature nearFeature = TFFeature.getFeatureForRegion(center.func_177958_n() >> 4, center.func_177952_p() >> 4, world);
            if (!nearFeature.hasProtectionAura || nearFeature.doesPlayerHaveRequiredAdvancements(player)) {
                TFTickHandler.sendAllClearPacket(world, player);
                return false;
            }
            TFTickHandler.sendStructureProtectionPacket(world, player, fullSBB);
            return true;
        }
        return false;
    }

    private static void checkForPortalCreation(EntityPlayer player, World world, float rangeToCheck) {
        if (world.field_73011_w.getDimension() == 0 || world.field_73011_w.getDimension() == TFConfig.dimension.dimensionID || TFConfig.allowPortalsInOtherDimensions) {
            HashMap validItems = Maps.newHashMap();
            for (String s : TFConfig.portalCreationItems) {
                Item item;
                String[] split = s.split(":");
                if (split.length < 2 || (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0], split[1]))) == null) continue;
                int meta = -1;
                if (split.length > 2) {
                    try {
                        meta = Integer.parseInt(split[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                validItems.put(item, meta);
            }
            if (validItems.isEmpty()) {
                validItems.put(Items.field_151045_i, -1);
            }
            List itemList = world.func_72872_a(EntityItem.class, player.func_174813_aQ().func_72314_b((double)rangeToCheck, (double)rangeToCheck, (double)rangeToCheck));
            for (EntityItem entityItem : itemList) {
                IBlockState state = world.func_180495_p(entityItem.func_180425_c());
                if (!validItems.containsKey(entityItem.func_92059_d().func_77973_b())) continue;
                int metadata = (Integer)validItems.get(entityItem.func_92059_d().func_77973_b());
                if (state.func_177230_c() != Blocks.field_150355_j && state != TFBlocks.portal.func_176223_P().func_177226_a(BlockTFPortal.DISALLOW_RETURN, (Comparable)Boolean.valueOf(true)) || metadata != -1 && entityItem.func_92059_d().func_77960_j() != metadata) continue;
                Random rand = new Random();
                for (int k = 0; k < 2; ++k) {
                    double d = rand.nextGaussian() * 0.02;
                    double d1 = rand.nextGaussian() * 0.02;
                    double d2 = rand.nextGaussian() * 0.02;
                    world.func_175688_a(EnumParticleTypes.SPELL, entityItem.field_70165_t, entityItem.field_70163_u + 0.2, entityItem.field_70161_v, d, d1, d2, new int[0]);
                }
                if (!((BlockTFPortal)TFBlocks.portal).tryToCreatePortal(world, entityItem.func_180425_c(), entityItem)) continue;
                TFAdvancements.MADE_TF_PORTAL.trigger((EntityPlayerMP)player);
                return;
            }
        }
    }

    private static void checkBiomeForProgression(EntityPlayer player, World world) {
        Biome currentBiome = world.func_180494_b(new BlockPos((Entity)player));
        if (currentBiome instanceof TFBiomeBase) {
            boolean dangerousBiome;
            TFBiomeBase tfBiome = (TFBiomeBase)currentBiome;
            boolean bl = dangerousBiome = !tfBiome.doesPlayerHaveRequiredAchievement(player);
            if (dangerousBiome) {
                tfBiome.enforceProgession(player, world);
            }
        }
    }
}

