/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.weather;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.LangFluid;
import crazypants.enderio.base.machine.gui.GuiInventoryMachineBase;
import crazypants.enderio.base.machine.gui.PowerBar;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.obelisk.weather.ContainerWeatherObelisk;
import crazypants.enderio.machines.machine.obelisk.weather.PacketActivateWeather;
import crazypants.enderio.machines.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.machines.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiWeatherObelisk
extends GuiInventoryMachineBase<TileWeatherObelisk> {
    @Nonnull
    private static final Rectangle RECTANGLE_TANK = new Rectangle(22, 11, 16, 63);
    private IconButton buttonStart;

    public GuiWeatherObelisk(@Nonnull InventoryPlayer inventory, @Nonnull TileWeatherObelisk tileEntity) {
        super(tileEntity, (Container)new ContainerWeatherObelisk(inventory, tileEntity), "weather_obelisk");
        this.addProgressTooltip(79, 29, 18, 31);
        this.addToolTip(new GuiToolTip(RECTANGLE_TANK, new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Lang.GUI_WEATHER_FTANK.get());
                this.text.add(LangFluid.MB((IFluidTank)((TileWeatherObelisk)GuiWeatherObelisk.this.getTileEntity()).getInputTank()));
            }
        });
        this.addDrawingElement(new PowerBar(tileEntity, this, 9, 11, 63));
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        if (RECTANGLE_TANK.contains(mouseX, mouseY)) {
            return ((TileWeatherObelisk)this.getTileEntity()).getInputTank().getFluid();
        }
        return super.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146999_f / 2 - 8;
        int y = 58;
        this.buttonStart = new IconButton((IGuiScreen)this, 0, x, y, (IWidgetIcon)IconEIO.TICK);
        this.func_189646_b((GuiButton)this.buttonStart);
        this.buttonStart.onGuiInit();
        this.refreshButtons();
        ((ContainerWeatherObelisk)this.field_147002_h).createGhostSlots((List<GhostSlot>)this.getGhostSlotHandler().getGhostSlots());
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (((TileWeatherObelisk)this.getTileEntity()).func_145831_w().func_82737_E() % 20L == 0L) {
            this.refreshButtons();
        }
    }

    private void refreshButtons() {
        FluidStack fs = ((TileWeatherObelisk)this.getTileEntity()).getInputTank().getFluid();
        if (fs == null) {
            this.buttonStart.field_146124_l = false;
            return;
        }
        TileWeatherObelisk.WeatherTask task = TileWeatherObelisk.WeatherTask.fromFluid(fs.getFluid());
        this.buttonStart.field_146124_l = ((TileWeatherObelisk)this.getTileEntity()).canStartTask(task);
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        this.bindGuiTexture();
        this.func_73729_b(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        int x = this.getGuiLeft() + 22;
        int y = this.getGuiTop() + 11;
        RenderUtil.renderGuiTank((FluidTank)((TileWeatherObelisk)this.getTileEntity()).getInputTank(), (double)x, (double)y, (double)0.0, (double)16.0, (double)63.0);
        this.bindGuiTexture();
        this.func_73729_b(x, y, 186, 33, 16, 63);
        if (this.shouldRenderProgress() && ((TileWeatherObelisk)this.getTileEntity()).getActiveTask() != null) {
            int barHeight = this.getProgressScaled(31);
            Color color = ((TileWeatherObelisk)this.getTileEntity()).getActiveTask().color;
            GlStateManager.func_179124_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.func_73729_b(this.getGuiLeft() + 81, this.getGuiTop() + 58 - barHeight, this.getXSize(), 32 - barHeight, 12, barHeight);
        }
        super.func_146976_a(par1, par2, par3);
    }

    protected void func_146284_a(@Nonnull GuiButton b) throws IOException {
        super.func_146284_a(b);
        if (b.field_146127_k >= 0 && b.field_146127_k <= 2) {
            ((TileWeatherObelisk)this.getTileEntity()).startTask();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketActivateWeather((TileWeatherObelisk)this.getTileEntity(), true));
        }
    }
}

