/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.baselegacy;

import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.capability.LegacyMachineWrapper;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

@Storable
public abstract class AbstractInventoryMachineEntity
extends AbstractMachineEntity {
    @Store(value={NBTAction.SAVE, NBTAction.ITEM})
    @Nonnull
    protected ItemStack[] inventory;
    @Nonnull
    protected final SlotDefinition slotDefinition;

    public AbstractInventoryMachineEntity(@Nonnull SlotDefinition slotDefinition) {
        this.slotDefinition = slotDefinition;
        this.inventory = new ItemStack[slotDefinition.getNumSlots()];
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = Prep.getEmpty();
        }
    }

    @Override
    protected void onAfterNbtRead() {
        super.onAfterNbtRead();
        if (this.inventory.length < this.slotDefinition.getNumSlots()) {
            ItemStack[] tmp = this.inventory;
            this.inventory = new ItemStack[this.slotDefinition.getNumSlots()];
            for (int i = 0; i < tmp.length; ++i) {
                this.inventory[i] = tmp[i];
            }
        }
    }

    @Nonnull
    public SlotDefinition getSlotDefinition() {
        return this.slotDefinition;
    }

    public boolean isValidUpgrade(@Nonnull ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinUpgradeSlot(); i <= this.slotDefinition.getMaxUpgradeSlot(); ++i) {
            if (!this.isItemValidForSlot(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(@Nonnull ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (!this.isItemValidForSlot(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidOutput(@Nonnull ItemStack itemstack) {
        for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot(); ++i) {
            if (!this.isItemValidForSlot(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public final boolean isItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        if (i < 0 || Prep.isInvalid(itemstack) || i >= this.slotDefinition.getNumSlots()) {
            return false;
        }
        if (this.slotDefinition.isUpgradeSlot(i)) {
            return CapacitorHelper.isValidUpgrade(itemstack);
        }
        return this.isMachineItemValidForSlot(i, itemstack);
    }

    public abstract boolean isMachineItemValidForSlot(int var1, @Nonnull ItemStack var2);

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (dir == null || !this.shouldDoWorkThisTick(20) || !this.hasStuffToPush()) {
            return false;
        }
        return ItemTools.move(this.getPushLimit(), (IBlockAccess)this.field_145850_b, (TileEntity)this, dir, this.func_174877_v().func_177972_a(dir), dir.func_176734_d()) == ItemTools.MoveResult.MOVED;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        if (dir == null || !this.shouldDoWorkThisTick(20) || !this.hasSpaceToPull()) {
            return false;
        }
        return ItemTools.move(this.getPullLimit(), (IBlockAccess)this.field_145850_b, this.func_174877_v().func_177972_a(dir), dir.func_176734_d(), (TileEntity)this, dir) == ItemTools.MoveResult.MOVED;
    }

    protected boolean hasStuffToPush() {
        for (int slot = this.slotDefinition.minOutputSlot; slot <= this.slotDefinition.maxOutputSlot; ++slot) {
            ItemStack itemStack = this.inventory[slot];
            if (itemStack == null || !Prep.isValid(itemStack)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSpaceToPull() {
        boolean hasSpace = false;
        for (int slot = this.slotDefinition.minInputSlot; slot <= this.slotDefinition.maxInputSlot && !hasSpace; ++slot) {
            ItemStack itemStack = this.inventory[slot];
            hasSpace = itemStack == null || Prep.isInvalid(itemStack) ? true : itemStack.func_190916_E() < Math.min(itemStack.func_77976_d(), this.getInventoryStackLimit(slot));
        }
        return hasSpace;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing1) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing1 != null) {
            return (T)new LegacyMachineWrapper(this, facing1);
        }
        return (T)super.getCapability(capability, facing1);
    }

    public int getSizeInventory() {
        return this.slotDefinition.getNumSlots();
    }

    public int getInventoryStackLimit(int slot) {
        return this.getInventoryStackLimit();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return Prep.getEmpty();
        }
        ItemStack itemStack = this.inventory[slot];
        return itemStack == null ? Prep.getEmpty() : itemStack;
    }

    public void setInventorySlotContents(int slot, @Nonnull ItemStack contents) {
        this.inventory[slot] = contents.func_77946_l();
        if (this.inventory[slot].func_190916_E() > this.getInventoryStackLimit(slot)) {
            this.inventory[slot].func_190920_e(this.getInventoryStackLimit(slot));
            contents.func_190918_g(this.getInventoryStackLimit(slot));
            Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)contents);
        }
        this.func_70296_d();
    }

    @Nonnull
    public InventoryWrapper getAsInventory() {
        return new InventoryWrapper();
    }

    public class InventoryWrapper
    implements IInventory {
        public AbstractInventoryMachineEntity getOwner() {
            return AbstractInventoryMachineEntity.this;
        }

        @Nonnull
        public String func_70005_c_() {
            return AbstractInventoryMachineEntity.this.getMachineName();
        }

        public boolean func_145818_k_() {
            return false;
        }

        @Nonnull
        public ITextComponent func_145748_c_() {
            return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return AbstractInventoryMachineEntity.this.getSizeInventory();
        }

        public boolean func_191420_l() {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (!Prep.isValid(this.func_70301_a(i))) continue;
                return false;
            }
            return true;
        }

        @Nonnull
        public ItemStack func_70301_a(int index) {
            return AbstractInventoryMachineEntity.this.getStackInSlot(index);
        }

        @Nonnull
        public ItemStack func_70298_a(int index, int count) {
            ItemStack item = this.func_70301_a(index);
            if (Prep.isValid(item)) {
                if (item.func_190916_E() <= count) {
                    this.func_70299_a(index, Prep.getEmpty());
                    return item;
                }
                ItemStack split = item.func_77979_a(count);
                this.func_70299_a(index, item);
                return split;
            }
            return Prep.getEmpty();
        }

        @Nonnull
        public ItemStack func_70304_b(int index) {
            ItemStack res = this.func_70301_a(index);
            this.func_70299_a(index, Prep.getEmpty());
            return res;
        }

        public void func_70299_a(int index, @Nonnull ItemStack stack) {
            AbstractInventoryMachineEntity.this.setInventorySlotContents(index, stack);
        }

        public int func_70297_j_() {
            return AbstractInventoryMachineEntity.this.getInventoryStackLimit();
        }

        public void func_70296_d() {
            AbstractInventoryMachineEntity.this.func_70296_d();
        }

        public boolean func_70300_a(@Nonnull EntityPlayer player) {
            return AbstractInventoryMachineEntity.this.isUseableByPlayer(player);
        }

        public void func_174889_b(@Nonnull EntityPlayer player) {
        }

        public void func_174886_c(@Nonnull EntityPlayer player) {
        }

        public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
            return AbstractInventoryMachineEntity.this.isItemValidForSlot(index, stack);
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.func_70299_a(i, Prep.getEmpty());
            }
        }
    }
}

