/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Item;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;

public class Output
extends AbstractConditional {
    private int amount;
    private String nbt;
    private Item item;
    private boolean required = true;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        super.readResolve();
        if (this.item == null) {
            throw new InvalidRecipeConfigException("Missing name in <output>");
        }
        if (this.isValid()) {
            if (this.amount < 0) {
                throw new InvalidRecipeConfigException("Invalid negative amount in <output>");
            }
            if (this.amount > this.item.getItemStack().func_77976_d()) {
                throw new InvalidRecipeConfigException("Invalid amount in <output>, bigger than maximum stack size");
            }
            if (this.amount == 0) {
                this.amount = 1;
            }
        }
        this.item.getThing().setSize(this.amount);
        String nbt_nullchecked = this.nbt;
        if (nbt_nullchecked != null && !nbt_nullchecked.trim().isEmpty()) {
            try {
                this.item.getThing().setNbt(JsonToNBT.func_180713_a((String)nbt_nullchecked));
            }
            catch (NBTException e) {
                throw new InvalidRecipeConfigException(nbt_nullchecked + " is not valid NBT json.");
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.item.enforceValidity();
    }

    @Override
    public boolean isValid() {
        return this.item != null && this.item.isValid();
    }

    @Override
    public boolean isActive() {
        return super.isActive() && (this.required || this.isValid());
    }

    @Nonnull
    public ItemStack getItemStack() {
        ItemStack itemStack = this.item.getItemStack().func_77946_l();
        itemStack.func_190920_e(this.amount);
        return itemStack;
    }

    public boolean hasAlternatives() {
        return this.item.getThing().getItemStacks().size() > 1;
    }

    @Nonnull
    public NNList<ItemStack> getAlternatives() {
        NNList list = this.item.getThing().getItemStacks().copy();
        list.remove(0);
        for (ItemStack itemStack : list) {
            itemStack.func_190920_e(this.amount);
        }
        return list;
    }

    @Nonnull
    public Things getThing() {
        return this.item.getThing();
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("amount".equals(name)) {
            this.amount = Integer.valueOf(value);
            return true;
        }
        if ("nbt".equals(name)) {
            this.nbt = value;
            return true;
        }
        if ("name".equals(name)) {
            this.item = (Item)new Item().setAllowDelaying(false);
            this.item.setName(value);
            this.item.readResolve();
            return true;
        }
        if ("required".equals(name)) {
            this.required = Boolean.parseBoolean(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public void register(@Nonnull String recipeName) {
    }
}

