/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.redstone.signals;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.conduit.redstone.signals.Signal;
import crazypants.enderio.base.filter.redstone.IOutputSignalFilter;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class BundledSignal {
    @Nonnull
    private final Map<DyeColor, Signal> bundle = new EnumMap<DyeColor, Signal>(DyeColor.class);
    @Nonnull
    private final Map<DyeColor, Map<Integer, Signal>> bundleSignals = new EnumMap<DyeColor, Map<Integer, Signal>>(DyeColor.class);

    public BundledSignal() {
        for (DyeColor color : DyeColor.values()) {
            this.bundle.put(color, new Signal(CombinedSignal.NONE, -1));
            this.bundleSignals.put(color, new HashMap());
        }
    }

    @Nonnull
    public Signal getSignal(@Nonnull DyeColor color) {
        Signal result = this.bundle.get(color);
        return result;
    }

    public void addSignal(@Nonnull DyeColor color, @Nonnull Signal signal) {
        Map<Integer, Signal> signalMap = this.bundleSignals.get(color);
        if (!signalMap.containsKey(signal.getId())) {
            signalMap.put(signal.getId(), signal);
        } else if (signalMap.get(signal.getId()).getStrength() != signal.getStrength()) {
            signalMap.put(signal.getId(), signal);
        }
        int str = 0;
        for (Signal sig : signalMap.values()) {
            if ((str += sig.getStrength()) < 15) continue;
            str = 15;
            break;
        }
        this.bundle.get(color).setStrength(str);
    }

    public void set(@Nonnull DyeColor color, @Nonnull Signal signal) {
        this.bundle.put(color, signal);
    }

    public void reset(@Nonnull DyeColor color) {
        this.bundle.remove(color);
    }

    public void clear() {
        for (Signal sig : this.bundle.values()) {
            sig.resetSignal();
        }
    }

    @Nonnull
    public CombinedSignal getFilteredSignal(@Nonnull DyeColor color, @Nonnull IOutputSignalFilter filter) {
        return filter.apply(color, this);
    }

    @Nonnull
    public Collection<Signal> getSignals() {
        return this.bundle.values();
    }
}

