/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.collect.Lists;
import java.util.List;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import openblocks.client.renderer.block.canvas.TextureOrientation;

public class StencilCoverQuadBuilder {
    private final AxisAlignedBB bounds;
    private final VertexFormat format;
    private final int tint;
    private final List<BakedQuad> quads = Lists.newArrayList();
    private static final Vector3f NORMAL_NORTH = new Vector3f(0.0f, 0.0f, -1.0f);
    private static final Vector3f NORMAL_SOUTH = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Vector3f NORMAL_EAST = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f NORMAL_WEST = new Vector3f(-1.0f, 0.0f, 0.0f);
    private static final Vector3f NORMAL_DOWN = new Vector3f(0.0f, -1.0f, 0.0f);

    public StencilCoverQuadBuilder(AxisAlignedBB bounds, VertexFormat format, int tint) {
        this.bounds = bounds;
        this.format = format;
        this.tint = tint;
    }

    private void add(TextureAtlasSprite texture, TextureOrientation rotation, EnumFacing face, float x, float y, float z, Vector3f right, Vector3f down) {
        Vertex[] vertices = new Vertex[]{new Vertex(x, y, z, 0.0f, 0.0f), new Vertex(x + down.x, y + down.y, z + down.z, 0.0f, 1.0f), new Vertex(x + right.x + down.x, y + right.y + down.y, z + right.z + down.z, 1.0f, 1.0f), new Vertex(x + right.x, y + right.y, z + right.z, 1.0f, 0.0f)};
        UnpackedBakedQuad.Builder builderCcw = this.createQuadBuilder(texture, face);
        UnpackedBakedQuad.Builder builderCw = this.createQuadBuilder(texture, face.func_176734_d());
        for (int v = 0; v < 4; ++v) {
            Vertex textureV = vertices[v];
            Vertex positionV = vertices[rotation.shift(v)];
            this.addQuad(builderCcw, face, texture, positionV, textureV);
            textureV = vertices[3 - v];
            positionV = vertices[rotation.shift(3 - v)];
            this.addQuad(builderCw, face.func_176734_d(), texture, positionV, textureV);
        }
        this.quads.add((BakedQuad)builderCcw.build());
        this.quads.add((BakedQuad)builderCw.build());
    }

    private UnpackedBakedQuad.Builder createQuadBuilder(TextureAtlasSprite sprite, EnumFacing face) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setApplyDiffuseLighting(true);
        builder.setQuadOrientation(face);
        builder.setQuadTint(this.tint);
        builder.setTexture(sprite);
        return builder;
    }

    private void addQuad(UnpackedBakedQuad.Builder builder, EnumFacing face, TextureAtlasSprite sprite, Vertex position, Vertex texture) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            VertexFormatElement el = this.format.func_177348_c(e);
            switch (el.func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{position.x, position.y, position.z});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{face.func_82601_c(), face.func_96559_d(), face.func_82599_e()});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (el.func_177369_e() == 0) {
                        builder.put(e, new float[]{sprite.func_94214_a((double)(16.0f * texture.u)), sprite.func_94207_b((double)(16.0f * texture.v))});
                        continue block6;
                    }
                    builder.put(e, new float[]{0.0f, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public void add(EnumFacing side, TextureAtlasSprite texture, TextureOrientation rotation) {
        switch (side) {
            case NORTH: {
                this.add(texture, rotation, EnumFacing.NORTH, 1.0f, 1.0f, (float)this.bounds.field_72339_c, NORMAL_WEST, NORMAL_DOWN);
                break;
            }
            case SOUTH: {
                this.add(texture, rotation, EnumFacing.SOUTH, 0.0f, 1.0f, (float)this.bounds.field_72334_f, NORMAL_EAST, NORMAL_DOWN);
                break;
            }
            case EAST: {
                this.add(texture, rotation, EnumFacing.EAST, (float)this.bounds.field_72336_d, 1.0f, 1.0f, NORMAL_NORTH, NORMAL_DOWN);
                break;
            }
            case WEST: {
                this.add(texture, rotation, EnumFacing.WEST, (float)this.bounds.field_72340_a, 1.0f, 0.0f, NORMAL_SOUTH, NORMAL_DOWN);
                break;
            }
            case UP: {
                this.add(texture, rotation, EnumFacing.UP, 0.0f, (float)this.bounds.field_72337_e, 0.0f, NORMAL_EAST, NORMAL_SOUTH);
                break;
            }
            case DOWN: {
                this.add(texture, rotation, EnumFacing.DOWN, 0.0f, (float)this.bounds.field_72338_b, 1.0f, NORMAL_EAST, NORMAL_NORTH);
                break;
            }
            default: {
                throw new AssertionError(side);
            }
        }
    }

    public List<BakedQuad> build() {
        return this.quads;
    }

    private static class Vertex {
        public final float x;
        public final float y;
        public final float z;
        public final float u;
        public final float v;

        public Vertex(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
        }

        public String toString() {
            return String.format("[%f,%f,%f][%f,%f]", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.u), Float.valueOf(this.v));
        }
    }
}

