/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.common.CraneRegistry;
import openblocks.common.entity.EntityMagnet;
import openblocks.common.item.ItemCraneBackpack;
import org.lwjgl.opengl.GL11;

public class ModelCraneBackpack
extends ModelBiped {
    public static final ModelCraneBackpack instance = new ModelCraneBackpack();
    private static final ResourceLocation texture = new ResourceLocation(ItemCraneBackpack.TEXTURE_CRANE);
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private final ModelRenderer arm;

    public ModelCraneBackpack() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.field_78115_e = new ModelRenderer((ModelBase)this, 0, 0);
        this.field_78115_e.func_78787_b(this.field_78090_t, this.field_78089_u);
        this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_78115_e.func_78789_a(-4.0f, 0.0f, -2.0f, 8, 12, 8);
        this.field_78115_e.func_78784_a(32, 0);
        this.field_78115_e.func_78789_a(-1.0f, -16.0f, 6.0f, 2, 24, 2);
        this.arm = new ModelRenderer((ModelBase)this, 0, 0);
        this.arm.func_78787_b(this.field_78090_t, this.field_78089_u);
        this.arm.func_78793_a(0.0f, -16.0f, 7.0f);
        this.arm.func_78789_a(-1.0f, 0.0f, 1.0f, 2, 2, 42);
    }

    public void func_78087_a(float swingTime, float swingAmpl, float rightArmAngle, float headAngleX, float headAngleY, float scale, Entity entity) {
        super.func_78087_a(swingTime, swingAmpl, rightArmAngle, headAngleX, headAngleY, scale, entity);
        if (this.field_78117_n) {
            this.arm.field_78798_e = -0.15f;
            this.arm.field_82908_p = -0.125f;
        } else {
            this.arm.field_78798_e = 7.0f;
            this.arm.field_82908_p = 0.0f;
        }
    }

    public void func_78088_a(Entity entity, float swingTime, float swingAmpl, float rightArmAngle, float headAngleX, float headAngleY, float scale) {
        this.field_78117_n = entity != null && entity.func_70093_af();
        this.func_78087_a(swingTime, swingAmpl, rightArmAngle, headAngleX, headAngleY, scale, entity);
        this.field_78115_e.func_78785_a(scale);
        this.arm.field_78796_g = (float)Math.PI + this.field_78116_c.field_78796_g;
        this.arm.func_78785_a(scale);
    }

    private static float interpolateAngle(float current, float prev, float partialTickTime) {
        float interpolated = prev + partialTickTime * (current - prev);
        return (90.0f + interpolated) * ((float)Math.PI / 180);
    }

    private static double interpolatePos(double current, double prev, float partialTickTime) {
        return prev + (double)partialTickTime * (current - prev);
    }

    @SubscribeEvent
    public void renderLines(RenderPlayerEvent.Pre evt) {
        double armLength;
        EntityPlayer player = evt.getEntityPlayer();
        if (!ItemCraneBackpack.isWearingCrane((EntityLivingBase)player)) {
            return;
        }
        EntityMagnet magnet = CraneRegistry.instance.getMagnetForPlayer((EntityLivingBase)player);
        if (magnet == null) {
            return;
        }
        float partialRenderTick = evt.getPartialRenderTick();
        double playerX = ModelCraneBackpack.interpolatePos(player.field_70165_t, player.field_70142_S, partialRenderTick) - TileEntityRendererDispatcher.field_147554_b;
        double playerY = ModelCraneBackpack.interpolatePos(player.field_70163_u, player.field_70137_T, partialRenderTick) - TileEntityRendererDispatcher.field_147555_c;
        double playerZ = ModelCraneBackpack.interpolatePos(player.field_70161_v, player.field_70136_U, partialRenderTick) - TileEntityRendererDispatcher.field_147552_d;
        float offset = ModelCraneBackpack.interpolateAngle(player.field_70761_aq, player.field_70760_ar, partialRenderTick);
        float head = ModelCraneBackpack.interpolateAngle(player.field_70759_as, player.field_70758_at, partialRenderTick);
        double armX = playerX;
        double armY = playerY += (double)player.func_70047_e();
        double armZ = playerZ;
        if (player.func_70093_af()) {
            armY += 0.7;
            armLength = 2.0;
        } else {
            armX += -0.45 * (double)MathHelper.func_76134_b((float)offset);
            armY += 0.65;
            armZ += -0.45 * (double)MathHelper.func_76126_a((float)offset);
            armLength = 2.4;
        }
        armX += armLength * (double)MathHelper.func_76134_b((float)head);
        armZ += armLength * (double)MathHelper.func_76126_a((float)head);
        double magnetX = ModelCraneBackpack.interpolatePos(magnet.field_70165_t, magnet.field_70142_S, partialRenderTick) - TileEntityRendererDispatcher.field_147554_b;
        double magnetY = ModelCraneBackpack.interpolatePos(magnet.field_70163_u, magnet.field_70137_T, partialRenderTick) - TileEntityRendererDispatcher.field_147555_c + (double)magnet.field_70131_O - 0.1;
        double magnetZ = ModelCraneBackpack.interpolatePos(magnet.field_70161_v, magnet.field_70136_U, partialRenderTick) - TileEntityRendererDispatcher.field_147552_d;
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GL11.glEnable((int)2852);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glLineStipple((int)3, (short)1365);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)armX, (double)armY, (double)armZ);
        GL11.glVertex3d((double)magnetX, (double)magnetY, (double)magnetZ);
        GL11.glEnd();
        GL11.glDisable((int)2852);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        ModelCraneBackpack.drawLine(magnetX, magnetY, magnetZ, armX, armY, armZ);
    }

    private static void drawLineFPP(EntityPlayer player, float partialTickTime) {
        EntityMagnet magnet = CraneRegistry.instance.getMagnetForPlayer((EntityLivingBase)player);
        if (magnet == null) {
            return;
        }
        float yaw = ModelCraneBackpack.interpolateAngle(player.field_70177_z, player.field_70126_B, partialTickTime);
        double posX = 1.9 * (double)MathHelper.func_76134_b((float)yaw);
        double posZ = 1.9 * (double)MathHelper.func_76126_a((float)yaw);
        double centerX = ModelCraneBackpack.interpolatePos(player.field_70165_t, player.field_70142_S, partialTickTime);
        double centerY = ModelCraneBackpack.interpolatePos(player.field_70163_u, player.field_70137_T, partialTickTime);
        double centerZ = ModelCraneBackpack.interpolatePos(player.field_70161_v, player.field_70136_U, partialTickTime);
        double magnetX = ModelCraneBackpack.interpolatePos(magnet.field_70165_t, magnet.field_70142_S, partialTickTime) - centerX;
        double magnetY = ModelCraneBackpack.interpolatePos(magnet.field_70163_u, magnet.field_70137_T, partialTickTime) - centerY + (double)magnet.field_70131_O - 0.05;
        double magnetZ = ModelCraneBackpack.interpolatePos(magnet.field_70161_v, magnet.field_70136_U, partialTickTime) - centerZ;
        ModelCraneBackpack.drawLine(magnetX, magnetY, magnetZ, posX, (double)player.func_70047_e() + 0.6, posZ);
    }

    private static void drawLine(double x1, double y1, double z1, double x2, double y2, double z2) {
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GL11.glEnable((int)2852);
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glLineStipple((int)5, (short)21845);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)x1, (double)y1, (double)z1);
        GL11.glVertex3d((double)x2, (double)y2, (double)z2);
        GL11.glEnd();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glLineStipple((int)5, (short)-21846);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)x1, (double)y1, (double)z1);
        GL11.glVertex3d((double)x2, (double)y2, (double)z2);
        GL11.glEnd();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2852);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_187441_d((float)1.0f);
    }

    private void drawArm(RenderWorldLastEvent evt, EntityPlayer player) {
        TextureManager tex = Minecraft.func_71410_x().func_110434_K();
        tex.func_110577_a(texture);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GL11.glPushMatrix();
        GL11.glRotated((double)(-player.field_70177_z), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslatef((float)0.0f, (float)(player.func_70047_e() + 1.6f), (float)-1.0f);
        this.arm.field_78796_g = 0.0f;
        this.arm.func_78785_a(0.0625f);
        GL11.glPopMatrix();
        GlStateManager.func_179145_e();
    }

    @SubscribeEvent
    public void renderFppArm(RenderWorldLastEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O != 0) {
            return;
        }
        Entity rve = mc.func_175606_aa();
        if (!(rve instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)rve;
        if (!ItemCraneBackpack.isWearingCrane((EntityLivingBase)player)) {
            return;
        }
        this.drawArm(evt, player);
        ModelCraneBackpack.drawLineFPP(player, evt.getPartialTicks());
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }
}

