/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util;

public class LampUtil {
    private static Class coloredLights;
    private static boolean initialized;

    public static boolean shouldColorLight() {
        if (!initialized) {
            try {
                coloredLights = Class.forName("coloredlightscore.src.api.CLApi");
            }
            catch (ClassNotFoundException e) {
                coloredLights = null;
            }
            initialized = true;
        }
        return coloredLights != null;
    }

    public static int toBrightness(int color) {
        return Math.round(LampUtil.brightness(color) * 15.0f);
    }

    public static float brightness(int color) {
        int r = color >> 10 & 0x1F;
        int g = color >> 5 & 0x1F;
        int b = color & 0x1F;
        return (float)(r + g + b) / 93.0f;
    }

    static {
        initialized = false;
    }
}

