/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.item;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.IMediaProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.tape.IItemTapeStorage;
import pl.asie.computronics.api.tape.ITapeStorage;
import pl.asie.computronics.item.entity.EntityItemIndestructable;
import pl.asie.computronics.oc.manual.IItemWithDocumentation;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tape.TapeStorage;
import pl.asie.computronics.util.StringUtil;
import pl.asie.computronics.util.internal.IItemWithColor;
import pl.asie.lib.util.color.ItemColorizer;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.media.IMediaProvider", modid="computercraft"), @Optional.Interface(iface="dan200.computercraft.api.media.IMedia", modid="computercraft")})
public class ItemTape
extends Item
implements IItemTapeStorage,
IMedia,
IMediaProvider,
IItemWithDocumentation,
IItemWithColor {
    public static final int L_SECOND = 6000;
    public static final int L_MINUTE = 360000;
    private static final int TAPE_COUNT = 10;
    private static final int[] DEFAULT_LENGTHS = new int[]{4, 8, 16, 32, 64, 2, 6, 16, 128, 128};
    private int[] sizes;
    private static final String[] TAPE_NAMES = new String[]{"tape_iron", "tape_gold", "tape_gold", "tape_diamond", "tape_nether_star", "tape_copper", "tape_steel", "tape_greg", "tape_nether_star", "tape_ig"};

    public ItemTape(String lengths) {
        this.func_77655_b("computronics.tape");
        this.func_77637_a(Computronics.tab);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        String[] l = lengths.split(",");
        this.sizes = new int[10];
        for (int i = 0; i < 10; ++i) {
            if (i < l.length) {
                try {
                    this.sizes[i] = Integer.parseInt(l[i]) * 360000;
                }
                catch (NumberFormatException e) {
                    Computronics.log.error("Property 'tapedrive.tapeLengths' in computronics.cfg contains entry that is not a number! Setting entry " + String.valueOf(i + 1) + " ['" + l[i] + "'] to " + DEFAULT_LENGTHS[i]);
                    e.printStackTrace();
                    this.sizes[i] = DEFAULT_LENGTHS[i] * 360000;
                }
                if (this.sizes[i] > 0) continue;
                this.sizes[i] = 4;
                continue;
            }
            Computronics.log.warn("Property 'tapedrive.tapeLengths' contains too few entries, setting entry " + String.valueOf(i + 1) + " to " + DEFAULT_LENGTHS[i]);
            this.sizes[i] = DEFAULT_LENGTHS[i] * 360000;
        }
    }

    public String getLabel(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("label") ? stack.func_77978_p().func_74779_i("label") : "";
    }

    public boolean setLabel(ItemStack stack, String label) {
        if (stack.func_190926_b()) {
            return false;
        }
        stack.func_77978_p().func_74778_a("label", label);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> text, ITooltipFlag flag) {
        String label;
        int size = this.getSize(stack);
        int len = (int)Math.floor(size / 360000);
        if (stack.func_77978_p() != null && (label = this.getLabel(stack)).length() > 0) {
            text.add(TextFormatting.WHITE + "" + TextFormatting.ITALIC + label);
        }
        text.add(TextFormatting.GRAY + StringUtil.localizeAndFormat("tooltip.computronics.tape.length", "" + len));
        switch (stack.func_77952_i()) {
            case 7: {
                text.add(TextFormatting.AQUA + StringUtil.localize("tooltip.computronics.tape.balanced"));
                break;
            }
            case 9: {
                String[] local;
                for (String s : local = StringUtil.localize("tooltip.computronics.tape.ig").replace("\\n", "\n").split("\\n")) {
                    text.add(TextFormatting.AQUA + s);
                }
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tabs, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if ((i == 7 || i == 9) && !Mods.isLoaded("gregtech")) continue;
            list.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    public int getSize(ItemStack stack) {
        return this.getSize(stack.func_77952_i());
    }

    public int getSize(int meta) {
        return this.sizes[meta % this.sizes.length];
    }

    @Override
    public ITapeStorage getStorage(ItemStack stack) {
        NBTTagCompound nbt;
        String storageName;
        int size = this.getSize(stack);
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("storage") && Computronics.storage.exists(storageName = (nbt = stack.func_77978_p()).func_74779_i("storage"))) {
            return Computronics.storage.get(storageName, size, 0);
        }
        TapeStorage storage = Computronics.storage.newStorage(size);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("storage", storage.getUniqueId());
        return storage;
    }

    public String func_77667_c(ItemStack itemstack) {
        if (itemstack.func_190926_b() && itemstack.func_77952_i() == 9) {
            return "item.computronics.tape.ig";
        }
        return super.func_77667_c(itemstack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77952_i() == 9;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        if (itemstack.func_190926_b() && itemstack.func_77952_i() == 9) {
            EntityItemIndestructable newTapeEntity = new EntityItemIndestructable(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
            newTapeEntity.func_174867_a(40);
            newTapeEntity.field_70159_w = location.field_70159_w;
            newTapeEntity.field_70181_x = location.field_70181_x;
            newTapeEntity.field_70179_y = location.field_70179_y;
            return newTapeEntity;
        }
        return super.createEntity(world, location, itemstack);
    }

    public void registerItemModels() {
        if (!Computronics.proxy.isClient()) {
            return;
        }
        for (int i = 0; i < TAPE_NAMES.length; ++i) {
            Computronics.proxy.registerItemModel(this, i, "computronics:" + TAPE_NAMES[i]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack stack, int pass) {
        return pass == 0 ? -1 : (ItemColorizer.hasColor(stack) ? ItemColorizer.getColor(stack) : -1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77952_i() == 8 || super.func_77636_d(stack);
    }

    @Optional.Method(modid="computercraft")
    public IMedia getMedia(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_190916_E() > 0 && stack.func_77973_b() instanceof ItemTape) {
            return (IMedia)stack.func_77973_b();
        }
        return null;
    }

    @Optional.Method(modid="computercraft")
    public String getAudioTitle(ItemStack stack) {
        return null;
    }

    @Optional.Method(modid="computercraft")
    public SoundEvent getAudio(ItemStack stack) {
        return null;
    }

    @Optional.Method(modid="computercraft")
    public IMount createDataMount(ItemStack stack, World world) {
        return null;
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return "tape";
    }
}

