/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TurtleUpgradeBase
implements ITurtleUpgrade {
    private ResourceLocation upgradeID;
    private static final Map<TurtleSide, Matrix4f> standardBlockMatrixMap = new HashMap<TurtleSide, Matrix4f>();

    public TurtleUpgradeBase(String id) {
        this.upgradeID = new ResourceLocation("computronics", id);
    }

    public ResourceLocation getUpgradeID() {
        return this.upgradeID;
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, EnumFacing direction) {
        return null;
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    public int getLegacyUpgradeID() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, TurtleSide side) {
        return Pair.of((Object)Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.getCraftingItem()), (Object)this.getStandardBlockMatrixForSide(side));
    }

    protected Matrix4f getStandardBlockMatrixForSide(TurtleSide side) {
        return standardBlockMatrixMap.get(side);
    }

    static {
        standardBlockMatrixMap.put(TurtleSide.Left, new Matrix4f(0.0f, 0.0f, -1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.5f, 0.0f, -1.0f, 0.0f, 1.40625f, 0.0f, 0.0f, 0.0f, 2.0f));
        standardBlockMatrixMap.put(TurtleSide.Right, new Matrix4f(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.5f, 0.0f, -1.0f, 0.0f, 1.40625f, 0.0f, 0.0f, 0.0f, 2.0f));
    }
}

