/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.tinkering;

import c4.conarm.ConstructsArmory;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.events.ArmoryEvent;
import c4.conarm.lib.modifiers.AccessoryModifier;
import c4.conarm.lib.tinkering.TinkersArmor;
import c4.conarm.lib.utils.RecipeMatchHolder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import org.apache.logging.log4j.Level;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ArmorBuilder {
    @Nonnull
    public static ItemStack tryBuildArmor(NonNullList<ItemStack> stacks, String name, Collection<ArmorCore> possibleArmor) {
        int length = -1;
        for (int i = 0; i < stacks.size(); ++i) {
            if (((ItemStack)stacks.get(i)).func_190926_b()) {
                if (length >= 0) continue;
                length = i;
                continue;
            }
            if (length < 0) continue;
            return ItemStack.field_190927_a;
        }
        if (length < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStackList input = ItemStackList.of(stacks);
        for (Item item : possibleArmor) {
            ItemStack output;
            if (!(item instanceof ArmorCore) || (output = ((ArmorCore)item).buildItemFromStacks((NonNullList<ItemStack>)input)).func_190926_b()) continue;
            if (name != null && !name.isEmpty()) {
                output.func_151001_c(name);
            }
            return output;
        }
        return ItemStack.field_190927_a;
    }

    public static void rebuildArmor(NBTTagCompound rootNBT, TinkersArmor tinkersArmor) throws TinkerGuiException {
        boolean broken = TagUtil.getToolTag((NBTTagCompound)rootNBT).func_74767_n("Broken");
        NBTTagList materialTag = TagUtil.getBaseMaterialsTagList((NBTTagCompound)rootNBT);
        List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)materialTag);
        List<PartMaterialType> pms = tinkersArmor.getRequiredComponents();
        while (materials.size() < pms.size()) {
            materials.add(Material.UNKNOWN);
        }
        for (int i = 0; i < pms.size(); ++i) {
            if (pms.get(i).isValidMaterial((Material)materials.get(i))) continue;
            materials.set(i, Material.UNKNOWN);
        }
        NBTTagCompound toolTag = tinkersArmor.buildTag(materials);
        TagUtil.setToolTag((NBTTagCompound)rootNBT, (NBTTagCompound)toolTag);
        rootNBT.func_74782_a("StatsOriginal", (NBTBase)toolTag.func_74737_b());
        NBTTagList modifiersTagOld = TagUtil.getModifiersTagList((NBTTagCompound)rootNBT);
        rootNBT.func_82580_o("Modifiers");
        rootNBT.func_74782_a("Modifiers", (NBTBase)new NBTTagList());
        rootNBT.func_82580_o("ench");
        rootNBT.func_82580_o("EnchantEffect");
        rootNBT.func_82580_o("Traits");
        tinkersArmor.addMaterialTraits(rootNBT, materials);
        ArmoryEvent.OnItemBuilding.fireEvent(rootNBT, (ImmutableList<Material>)ImmutableList.copyOf((Collection)materials), tinkersArmor);
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList((NBTTagCompound)rootNBT);
        NBTTagList modifiersTag = TagUtil.getModifiersTagList((NBTTagCompound)rootNBT);
        for (int i = 0; i < modifiers.func_74745_c(); ++i) {
            int indexAcc;
            String identifier = modifiers.func_150307_f(i);
            IModifier modifier = TinkerRegistry.getModifier((String)identifier);
            if (modifier == null) {
                ConstructsArmory.logger.log(Level.ERROR, "Missing modifier: " + identifier);
                continue;
            }
            int index = TinkerUtil.getIndexInList((NBTTagList)modifiersTagOld, (String)modifier.getIdentifier());
            NBTTagCompound tag = index >= 0 ? modifiersTagOld.func_150305_b(index) : new NBTTagCompound();
            modifier.applyEffect(rootNBT, tag);
            if (!tag.func_82582_d()) {
                int indexNew = TinkerUtil.getIndexInList((NBTTagList)modifiersTag, (String)modifier.getIdentifier());
                if (indexNew >= 0) {
                    modifiersTag.func_150304_a(indexNew, (NBTBase)tag);
                } else {
                    modifiersTag.func_74742_a((NBTBase)tag);
                }
            }
            if (!(modifier instanceof AccessoryModifier) || (indexAcc = TinkerUtil.getIndexInList((NBTTagList)modifiers, (String)modifier.getIdentifier())) < 0) continue;
            NBTTagList newList = new NBTTagList();
            for (int s = 0; s < modifiers.func_74745_c(); ++s) {
                if (s == indexAcc) continue;
                newList.func_74742_a(modifiers.func_179238_g(s));
            }
            newList.func_74742_a(modifiers.func_179238_g(indexAcc));
            TagUtil.setBaseModifiersTagList((NBTTagCompound)rootNBT, (NBTTagList)newList);
        }
        toolTag = TagUtil.getToolTag((NBTTagCompound)rootNBT);
        int freeModifiers = toolTag.func_74762_e("FreeModifiers");
        toolTag.func_74768_a("FreeModifiers", Math.max(0, freeModifiers -= TagUtil.getBaseModifiersUsed((NBTTagCompound)rootNBT)));
        if (broken) {
            toolTag.func_74757_a("Broken", true);
        }
        TagUtil.setToolTag((NBTTagCompound)rootNBT, (NBTTagCompound)toolTag);
        if (freeModifiers < 0) {
            throw new TinkerGuiException(Util.translateFormatted((String)"gui.error.not_enough_modifiers", (Object[])new Object[]{-freeModifiers}));
        }
    }

    @Nonnull
    public static ItemStack tryModifyArmor(NonNullList<ItemStack> input, ItemStack toolStack, boolean removeItems) throws TinkerGuiException {
        int i;
        ItemStack copy = toolStack.func_77946_l();
        NonNullList stacks = Util.deepCopyFixedNonNullList(input);
        NonNullList usedStacks = Util.deepCopyFixedNonNullList(input);
        HashSet appliedModifiers = Sets.newHashSet();
        for (IModifier modifier : ArmoryRegistry.getAllArmorModifiers()) {
            Optional<RecipeMatch.Match> matchOptional;
            do {
                matchOptional = RecipeMatchHolder.matches(modifier, (NonNullList<ItemStack>)stacks);
                ItemStack backup = copy.func_77946_l();
                if (!matchOptional.isPresent()) continue;
                RecipeMatch.Match match = matchOptional.get();
                while (match.amount > 0) {
                    TinkerGuiException caughtException = null;
                    boolean canApply = false;
                    try {
                        canApply = modifier.canApply(copy, toolStack);
                    }
                    catch (TinkerGuiException e) {
                        caughtException = e;
                    }
                    if (canApply) {
                        modifier.apply(copy);
                        appliedModifiers.add(modifier);
                        --match.amount;
                        continue;
                    }
                    if (caughtException != null && !appliedModifiers.contains(modifier)) {
                        throw caughtException;
                    }
                    copy = backup;
                    RecipeMatch.removeMatch((NonNullList)stacks, (RecipeMatch.Match)match);
                    break;
                }
                if (match.amount != 0) continue;
                RecipeMatch.removeMatch((NonNullList)stacks, (RecipeMatch.Match)match);
                RecipeMatch.removeMatch((NonNullList)usedStacks, (RecipeMatch.Match)match);
            } while (matchOptional.isPresent());
        }
        for (i = 0; i < input.size(); ++i) {
            if (((ItemStack)input.get(i)).func_190926_b() || !ItemStack.func_77989_b((ItemStack)((ItemStack)input.get(i)), (ItemStack)((ItemStack)stacks.get(i)))) continue;
            if (!appliedModifiers.isEmpty()) {
                throw new TinkerGuiException(Util.translateFormatted((String)"gui.error.no_modifier_for_item", (Object[])new Object[]{((ItemStack)input.get(i)).func_82833_r()}));
            }
            return ItemStack.field_190927_a;
        }
        if (removeItems) {
            for (i = 0; i < input.size(); ++i) {
                if (((ItemStack)usedStacks.get(i)).func_190926_b()) {
                    ((ItemStack)input.get(i)).func_190920_e(0);
                    continue;
                }
                ((ItemStack)input.get(i)).func_190920_e(((ItemStack)usedStacks.get(i)).func_190916_E());
            }
        }
        if (!appliedModifiers.isEmpty()) {
            if (copy.func_77973_b() instanceof TinkersArmor) {
                NBTTagCompound root = TagUtil.getTagSafe((ItemStack)copy);
                ArmorBuilder.rebuildArmor(root, (TinkersArmor)copy.func_77973_b());
                copy.func_77982_d(root);
            }
            return copy;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack tryReplaceArmorParts(ItemStack armorStack, NonNullList<ItemStack> partsIn, boolean removeItems) throws TinkerGuiException {
        if (armorStack == null || !(armorStack.func_77973_b() instanceof TinkersArmor)) {
            return ItemStack.field_190927_a;
        }
        ItemStackList inputItems = ItemStackList.of((Collection)Util.deepCopyFixedNonNullList(partsIn));
        if (!TinkerEvent.OnToolPartReplacement.fireEvent((NonNullList)inputItems, (ItemStack)armorStack)) {
            return ItemStack.field_190927_a;
        }
        NonNullList armorParts = Util.deepCopyFixedNonNullList((NonNullList)inputItems);
        TIntIntHashMap assigned = new TIntIntHashMap();
        TinkersArmor armor = (TinkersArmor)armorStack.func_77973_b();
        NBTTagList materialList = TagUtil.getBaseMaterialsTagList((ItemStack)armorStack).func_74737_b();
        for (int i2 = 0; i2 < armorParts.size(); ++i2) {
            ItemStack part = (ItemStack)armorParts.get(i2);
            if (part.func_190926_b()) continue;
            if (!(part.func_77973_b() instanceof IToolPart)) {
                return ItemStack.field_190927_a;
            }
            int candidate = -1;
            List<PartMaterialType> pms = armor.getRequiredComponents();
            for (int j2 = 0; j2 < pms.size(); ++j2) {
                PartMaterialType pmt = pms.get(j2);
                String partMat = ((IToolPart)part.func_77973_b()).getMaterial(part).getIdentifier();
                String currentMat = materialList.func_150307_f(j2);
                if (!pmt.isValid(part) || partMat.equals(currentMat) || assigned.valueCollection().contains(j2)) continue;
                candidate = j2;
                if (i2 <= j2) break;
            }
            if (candidate < 0) {
                return ItemStack.field_190927_a;
            }
            assigned.put(i2, candidate);
        }
        if (assigned.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        assigned.forEachEntry((i, j) -> {
            String mat = ((IToolPart)((ItemStack)armorParts.get(i)).func_77973_b()).getMaterial((ItemStack)armorParts.get(i)).getIdentifier();
            materialList.func_150304_a(j, (NBTBase)new NBTTagString(mat));
            if (removeItems && i < partsIn.size() && !((ItemStack)partsIn.get(i)).func_190926_b()) {
                ((ItemStack)partsIn.get(i)).func_190918_g(1);
            }
            return true;
        });
        TinkersArmor tinkersArmor = (TinkersArmor)armorStack.func_77973_b();
        ItemStack copyToCheck = tinkersArmor.buildItem(TinkerUtil.getMaterialsFromTagList((NBTTagList)materialList));
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList((ItemStack)armorStack);
        for (int i3 = 0; i3 < modifiers.func_74745_c(); ++i3) {
            String id = modifiers.func_150307_f(i3);
            IModifier mod = TinkerRegistry.getModifier((String)id);
            if (mod == null || mod.canApply(copyToCheck, copyToCheck)) continue;
            throw new TinkerGuiException();
        }
        ItemStack output = armorStack.func_77946_l();
        TagUtil.setBaseMaterialsTagList((ItemStack)output, (NBTTagList)materialList);
        NBTTagCompound tag = TagUtil.getTagSafe((ItemStack)output);
        ArmorBuilder.rebuildArmor(tag, (TinkersArmor)output.func_77973_b());
        output.func_77982_d(tag);
        if (output.func_77952_i() > output.func_77958_k()) {
            String error = I18n.func_74837_a((String)"gui.error.not_enough_durability", (Object[])new Object[]{output.func_77952_i() - output.func_77958_k()});
            throw new TinkerGuiException(error);
        }
        return output;
    }
}

