/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.book.content;

import c4.conarm.common.ConstructsRegistry;
import c4.conarm.lib.ArmoryRegistry;
import c4.conarm.lib.armor.ArmorCore;
import c4.conarm.lib.materials.ArmorMaterialType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.gui.book.GuiBook;
import slimeknights.mantle.client.gui.book.element.BookElement;
import slimeknights.mantle.client.gui.book.element.ElementItem;
import slimeknights.mantle.client.gui.book.element.ElementText;
import slimeknights.mantle.util.LocUtils;
import slimeknights.tconstruct.library.book.content.ContentMaterial;
import slimeknights.tconstruct.library.book.elements.ElementTinkerItem;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;

public class ContentArmorMaterial
extends ContentMaterial {
    public static final String ID = "armormaterial";
    private transient Material material;

    public ContentArmorMaterial(Material material) {
        super(material);
        this.material = material;
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        this.addTitle(list, this.material.getLocalizedNameColored(), true);
        this.addDisplayItems(list, rightSide ? GuiBook.PAGE_WIDTH - 18 : 0);
        int col_margin = 22;
        int top = 15;
        int left = rightSide ? 0 : col_margin;
        int y = top + 10;
        int x = left + 10;
        int w = GuiBook.PAGE_WIDTH / 2 - 10;
        LinkedHashSet<ITrait> allTraits = new LinkedHashSet<ITrait>();
        this.addStatsDisplay(x, y, w, list, allTraits, ArmorMaterialType.CORE);
        this.addStatsDisplay(x + w, y, w - 10, list, allTraits, ArmorMaterialType.PLATES);
        this.addStatsDisplay(x, y += 55 + 10 * this.material.getAllTraitsForStats(ArmorMaterialType.CORE).size(), w - 10, list, allTraits, ArmorMaterialType.TRIM);
        String flavour = (String)this.parent.parent.parent.strings.get(String.format("%s.flavour", this.material.getIdentifier()));
        if (flavour != null) {
            TextData flavourData = new TextData("\"" + flavour + "\"");
            flavourData.italic = true;
            list.add((BookElement)new ElementText(x + w, y, w - 16, 60, new TextData[]{flavourData}));
        }
    }

    private void addStatsDisplay(int x, int y, int w, ArrayList<BookElement> list, LinkedHashSet<ITrait> allTraits, String stattype) {
        IMaterialStats stats = this.material.getStats(stattype);
        if (stats == null) {
            return;
        }
        List traits = this.material.getAllTraitsForStats(stats.getIdentifier());
        allTraits.addAll(traits);
        LinkedList parts = Lists.newLinkedList();
        for (IToolPart iToolPart : ArmoryRegistry.armorParts) {
            if (!iToolPart.hasUseForStat(stats.getIdentifier())) continue;
            parts.add(iToolPart.getItemstackWithMaterial(this.material));
        }
        if (parts.size() > 0) {
            ElementTinkerItem display = new ElementTinkerItem(x, y + 1, 0.5f, (Collection)parts);
            list.add((BookElement)display);
        }
        ElementText name = new ElementText(x + 10, y, w - 10, 10, stats.getLocalizedName());
        name.text[0].underlined = true;
        list.add((BookElement)name);
        y += 12;
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(ContentArmorMaterial.getStatLines(stats));
        arrayList.addAll(ContentArmorMaterial.getTraitLines((List)traits, (Material)this.material));
        list.add((BookElement)new ElementText(x, y, w, GuiBook.PAGE_HEIGHT, (Collection)arrayList));
    }

    public static List<TextData> getStatLines(IMaterialStats stats) {
        ArrayList<TextData> lineData = new ArrayList<TextData>();
        for (int i = 0; i < stats.getLocalizedInfo().size(); ++i) {
            TextData text = new TextData((String)stats.getLocalizedInfo().get(i));
            String line = (String)stats.getLocalizedDesc().get(i);
            text.tooltip = LocUtils.convertNewlines((String)line).split("\n");
            lineData.add(text);
            lineData.add(new TextData("\n"));
        }
        return lineData;
    }

    private void addDisplayItems(ArrayList<BookElement> list, int x) {
        ElementTinkerItem elementItem;
        ArrayList displayArmor = Lists.newArrayList();
        int y = 10;
        if (!this.material.getRepresentativeItem().func_190926_b()) {
            displayArmor.add(new ElementTinkerItem(this.material.getRepresentativeItem()));
        }
        if (this.material.isCraftable()) {
            ItemStack partbuilder = new ItemStack((Block)TinkerTools.toolTables, 1, BlockToolTable.TableTypes.PartBuilder.meta);
            elementItem = new ElementTinkerItem(partbuilder);
            elementItem.tooltip = ImmutableList.of((Object)this.parent.translate("material.craft_partbuilder"));
            displayArmor.add(elementItem);
        }
        if (this.material.isCastable()) {
            ItemStack basin = new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.BASIN.getMeta());
            elementItem = new ElementTinkerItem(basin);
            String text = this.parent.translate("material.craft_casting");
            elementItem.tooltip = ImmutableList.of((Object)String.format(text, this.material.getFluid().getLocalizedName(new FluidStack(this.material.getFluid(), 0))));
            displayArmor.add(elementItem);
        }
        ArmorCore[] armory = new ArmorCore[]{ConstructsRegistry.helmet, ConstructsRegistry.chestplate, ConstructsRegistry.leggings, ConstructsRegistry.boots};
        for (ArmorCore armor : armory) {
            if (armor == null) continue;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < armor.getRequiredComponents().size(); ++i) {
                builder.add((Object)this.material);
            }
            ItemStack builtArmor = armor.buildItem((List<Material>)builder.build());
            if (armor.hasValidMaterials(builtArmor)) {
                displayArmor.add(new ElementTinkerItem(builtArmor));
            }
            if (displayArmor.size() == 9) break;
        }
        if (!displayArmor.isEmpty()) {
            for (ElementItem element : displayArmor) {
                element.x = x;
                element.y = y;
                element.scale = 1.0f;
                y += 16;
                list.add((BookElement)element);
            }
        }
    }
}

