/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.nether;

import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.IPlantable;

public class DarkwoodTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final IBlockState log;
    public final IBlockState leaves;
    public final IBlockState flowering;
    public final IBlockState fruiting;
    public final boolean seekHeight;

    public DarkwoodTreeGenerator(int treeHeight, IBlockState log, IBlockState leaves, IBlockState flowering, IBlockState fruiting, boolean seekHeight) {
        this.minTreeHeight = treeHeight;
        this.log = log;
        this.leaves = leaves;
        this.flowering = flowering;
        this.fruiting = fruiting;
        this.seekHeight = seekHeight;
    }

    public DarkwoodTreeGenerator(int treeHeight, IBlockState log, IBlockState leaves, IBlockState flowering, IBlockState fruiting) {
        this(treeHeight, log, leaves, flowering, fruiting, true);
    }

    BlockPos findGround(World world, BlockPos pos) {
        boolean foundGround = false;
        int height = pos.func_177956_o();
        BlockPos position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p());
        do {
            Block underBlock;
            if ((underBlock = world.func_180495_p(position = position.func_177977_b()).func_177230_c()) != Blocks.field_150424_aL && underBlock != Blocks.field_150425_aM && underBlock != NaturaNether.netherTaintedSoil && position.func_177956_o() >= 0) continue;
            foundGround = true;
        } while (!foundGround);
        return position.func_177984_a();
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    @Override
    public void generateTree(Random rand, World worldIn, BlockPos position) {
        int heightRange = rand.nextInt(3) + this.minTreeHeight;
        if (heightRange < 4) {
            heightRange = 4;
        }
        if (this.seekHeight && (position = this.findGround(worldIn, position)).func_177956_o() < 0) {
            return;
        }
        if (position.func_177956_o() >= 1 && position.func_177956_o() + heightRange + 1 <= 256) {
            boolean isSoil;
            if (!this.checkIfCanGrow(position, heightRange, worldIn)) {
                return;
            }
            IBlockState state = worldIn.func_180495_p(position.func_177977_b());
            Block soil = state.func_177230_c();
            boolean bl = isSoil = soil != null && soil.canSustainPlant(state, (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP, (IPlantable)NaturaNether.netherSapling) || soil == Blocks.field_150424_aL;
            if (isSoil && position.func_177956_o() < 256 - heightRange - 1) {
                soil.onPlantGrow(state, worldIn, position.func_177977_b(), position);
                this.placeCanopy(worldIn, rand, position, heightRange);
                this.placeTrunk(worldIn, position, heightRange);
            }
        }
    }

    private boolean checkIfCanGrow(BlockPos position, int heightRange, World worldIn) {
        boolean canGrowTree = true;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + heightRange; ++y) {
            int range = 1;
            if (y == position.func_177956_o()) {
                range = 0;
            }
            if (y >= position.func_177956_o() + 1 + heightRange - 2) {
                range = 2;
            }
            for (int x = position.func_177958_n() - range; x <= position.func_177958_n() + range && canGrowTree; ++x) {
                for (int z = position.func_177952_p() - range; z <= position.func_177952_p() + range && canGrowTree; ++z) {
                    if (y >= 0 && y < worldIn.func_72940_L()) {
                        pos.func_181079_c(x, y, z);
                        IBlockState state = worldIn.func_180495_p((BlockPos)pos);
                        Block block = state.func_177230_c();
                        if (worldIn.func_175623_d((BlockPos)pos) || block.isAir(state, (IBlockAccess)worldIn, (BlockPos)pos) || block.isLeaves(state, (IBlockAccess)worldIn, (BlockPos)pos) || block == Blocks.field_150424_aL || block == Blocks.field_150425_aM || block == NaturaNether.netherTaintedSoil || block.isWood((IBlockAccess)worldIn, (BlockPos)pos)) continue;
                        canGrowTree = false;
                        continue;
                    }
                    canGrowTree = false;
                }
            }
        }
        return canGrowTree;
    }

    protected void placeCanopy(World world, Random random, BlockPos pos, int height) {
        for (int y = pos.func_177956_o() - 3 + height; y <= pos.func_177956_o() + height; ++y) {
            int subract = y - (pos.func_177956_o() + height);
            int subract2 = 1 - subract / 2;
            for (int x = pos.func_177958_n() - subract2; x <= pos.func_177958_n() + subract2; ++x) {
                int mathX = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - subract2; z <= pos.func_177952_p() + subract2; ++z) {
                    BlockPos blockpos;
                    IBlockState state;
                    int mathZ = z - pos.func_177952_p();
                    if (Math.abs(mathX) == subract2 && Math.abs(mathZ) == subract2 && (random.nextInt(2) == 0 || subract == 0) || (state = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c() != null && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                    world.func_180501_a(blockpos, this.getRandomizedLeaves(random), 2);
                }
            }
        }
    }

    protected void placeTrunk(World world, BlockPos pos, int height) {
        for (int localHeight = 0; localHeight < height; ++localHeight) {
            BlockPos blockpos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + localHeight, pos.func_177952_p());
            IBlockState state = world.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (!block.isAir(state, (IBlockAccess)world, blockpos) && block != null && !block.isLeaves(state, (IBlockAccess)world, blockpos)) continue;
            world.func_180501_a(blockpos, this.log, 2);
        }
    }

    protected IBlockState getRandomizedLeaves(Random random) {
        return random.nextInt(25) == 0 ? this.fruiting : (random.nextInt(15) == 0 ? this.flowering : this.leaves);
    }
}

