/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

public class Quat {
    private static final double EPS = 1.0E-12;
    public double x;
    public double y;
    public double z;
    public double w;

    public Quat(Quat q) {
        this(q.x, q.y, q.z, q.w);
    }

    public Quat(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void normalize() {
        double mag = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        this.x *= mag;
        this.y *= mag;
        this.z *= mag;
        this.w *= mag;
    }

    public void interpolate(Quat q, double t) {
        double s2;
        double s1;
        double dot = this.x * q.x + this.y * q.y + this.z * q.z + this.w * q.w;
        if (dot < 0.0) {
            q.x = -q.x;
            q.y = -q.y;
            q.z = -q.z;
            q.w = -q.w;
            dot = -dot;
        }
        if (1.0 - dot > 1.0E-12) {
            double om = Math.acos(dot);
            double sinom = Math.sin(om);
            s1 = Math.sin((1.0 - t) * om) / sinom;
            s2 = Math.sin(t * om) / sinom;
        } else {
            s1 = 1.0 - t;
            s2 = t;
        }
        this.w = s1 * this.w + s2 * q.w;
        this.x = s1 * this.x + s2 * q.x;
        this.y = s1 * this.y + s2 * q.y;
        this.z = s1 * this.z + s2 * q.z;
    }

    public static Quat fromAxisAngle(double x, double y, double z, double angle) {
        double sin = Math.sin(angle / 2.0);
        return new Quat(x * sin, y * sin, z * sin, Math.cos(angle / 2.0));
    }
}

