/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.structure;

import com.google.common.base.Predicate;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageUUID;
import thebetweenlands.common.block.structure.BlockSlabBetweenlands;
import thebetweenlands.common.block.structure.BlockStairsBetweenlands;
import thebetweenlands.common.block.terrain.BlockCragrock;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.world.gen.feature.WorldGenBlockReplacementCluster;
import thebetweenlands.common.world.gen.feature.WorldGenHelper;
import thebetweenlands.common.world.gen.feature.WorldGenMossCluster;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class WorldGenIdolHeads
extends WorldGenHelper {
    private IBlockState solid = BlockRegistry.SMOOTH_CRAGROCK.func_176223_P();
    private IBlockState slab = BlockRegistry.SMOOTH_CRAGROCK_SLAB.func_176223_P();
    private IBlockState stairs = BlockRegistry.SMOOTH_CRAGROCK_STAIRS.func_176223_P();
    private IBlockState octine = BlockRegistry.OCTINE_BLOCK.func_176223_P();
    private final WorldGenerator crackGen = new WorldGenBlockReplacementCluster(BlockRegistry.CRAGROCK.func_176223_P(), (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)BlockRegistry.SMOOTH_CRAGROCK));
    private final WorldGenerator crackGenSlabs = new WorldGenBlockReplacementCluster(BlockRegistry.CRAGROCK_BRICK_SLAB.func_176223_P(), (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)BlockRegistry.SMOOTH_CRAGROCK_SLAB)).setInheritProperties(true);
    private final WorldGenerator crackGenStairs = new WorldGenBlockReplacementCluster(BlockRegistry.CRAGROCK_BRICK_STAIRS.func_176223_P(), (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)BlockRegistry.SMOOTH_CRAGROCK_STAIRS)).setInheritProperties(true);
    private final WorldGenerator mossGen = new WorldGenBlockReplacementCluster(BlockRegistry.CRAGROCK.func_176223_P().func_177226_a(BlockCragrock.VARIANT, (Comparable)((Object)BlockCragrock.EnumCragrockType.MOSSY_2)), (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)BlockRegistry.SMOOTH_CRAGROCK));
    private final WorldGenerator lichenClusterGen = new WorldGenMossCluster(BlockRegistry.LICHEN.func_176223_P());
    private final WorldGenerator mossClusterGen = new WorldGenMossCluster(BlockRegistry.MOSS.func_176223_P());

    public WorldGenIdolHeads() {
        this.depth = 8;
        this.width = 8;
        this.height = 8;
    }

    public boolean generateStructure(World world, Random rand, int x, int y, int z) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int xx = x - this.depth / 2; xx <= x + this.depth / 2; ++xx) {
            for (int zz = z - this.width / 2; zz <= z + this.width / 2; ++zz) {
                int yy;
                for (yy = y + 1; yy < y + this.height; ++yy) {
                    if (world.func_175623_d((BlockPos)checkPos.func_181079_c(xx, yy, zz)) || world.func_180495_p((BlockPos)checkPos.func_181079_c(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)checkPos.func_181079_c(xx, yy, zz))) continue;
                    return false;
                }
                for (yy = y; yy >= y - 5 && (world.func_175623_d((BlockPos)checkPos.func_181079_c(xx, yy, zz)) || world.func_180495_p((BlockPos)checkPos.func_181079_c(xx, yy, zz)).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)checkPos.func_181079_c(xx, yy, zz))); --yy) {
                    if (yy > y - 5) continue;
                    return false;
                }
            }
        }
        int direction = rand.nextInt(4);
        int headType = rand.nextInt(3);
        int xx = x;
        int zz = z;
        switch (headType) {
            case 0: {
                this.rotatedCubeVolume(world, xx, y, zz, 1, 0, 2, this.solid, 6, 4, 5, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 0, 3, 4, this.solid, 1, 2, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 7, 3, 4, this.solid, 1, 2, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 5, 1, this.solid, 6, 2, 6, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 4, 3, this.solid, 6, 1, 4, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 3, 0, this.solid, 2, 4, 3, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 3, 1, this.solid, 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 3, 1, this.solid, 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 7, 1, this.solid, 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 7, 3, this.solid, 2, 1, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 7, 6, this.solid, 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 6, 7, this.solid, 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 4, 7, this.solid, 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 4, 3, this.octine, 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 4, 3, this.octine, 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 1, 1, this.slab, 4, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 2, 1, this.slab.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 4, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 1, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH))), 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 6, 1, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH))), 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 2, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP))), 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 6, 2, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP))), 1, 1, 1, direction, new Consumer[0]);
                break;
            }
            case 1: {
                this.rotatedCubeVolume(world, xx, y, zz, 1, 0, 2, this.solid, 6, 4, 5, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 0, 1, 4, this.solid, 1, 5, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 7, 1, 4, this.solid, 1, 5, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 1, 7, this.solid, 2, 5, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 4, 3, this.solid, 6, 3, 4, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 7, 1, this.solid, 2, 1, 6, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 6, 1, this.slab.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 2, 1, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 7, 1, this.slab, 2, 1, 6, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 7, 1, this.solid, 2, 1, 6, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 6, 1, this.slab.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 2, 1, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 3, 0, this.solid, 2, 3, 3, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 6, 1, this.solid, 2, 1, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 4, 2, this.slab, 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 4, 2, this.slab, 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 3, 1, this.solid, 4, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 5, 3, this.octine, 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 5, 3, this.octine, 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 1, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH))), 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 4, 1, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH))), 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 2, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP))), 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 4, 2, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP))), 1, 1, 1, direction, new Consumer[0]);
                break;
            }
            case 2: {
                this.rotatedCubeVolume(world, xx, y, zz, 1, 0, 2, this.solid, 6, 4, 5, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 0, 1, 4, this.solid, 1, 5, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 7, 1, 4, this.solid, 1, 5, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 2, 7, this.solid, 4, 4, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 6, 1, this.solid, 6, 1, 6, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 7, 1, this.solid, 4, 1, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 7, 4, this.solid, 4, 1, 2, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 4, 3, this.solid, 6, 2, 4, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 3, 0, this.solid, 2, 4, 3, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 1, 4, 2, this.slab, 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 4, 2, this.slab, 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 3, 1, this.solid, 4, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 5, 3, this.octine, 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 5, 3, this.octine, 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 1, 1, this.slab, 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 3, 2, 1, this.slab.func_177226_a(BlockSlabBetweenlands.HALF, (Comparable)((Object)BlockSlabBetweenlands.EnumBlockHalfBL.TOP)), 2, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 1, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH))), 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 1, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH))), 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 2, 2, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP))), 1, 1, 1, direction, new Consumer[0]);
                this.rotatedCubeVolume(world, xx, y, zz, 5, 2, 1, direction == 0 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 2 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : (direction == 1 ? this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : this.stairs.func_177226_a((IProperty)BlockStairsBetweenlands.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairsBetweenlands.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP))), 1, 1, 1, direction, new Consumer[0]);
            }
        }
        for (int i = 0; i < 40 + rand.nextInt(160); ++i) {
            int type = rand.nextInt(4);
            switch (type) {
                default: {
                    this.crackGen.func_180709_b(world, rand, new BlockPos(x - 3 + rand.nextInt(6), y + 6 - 3 + rand.nextInt(6), z - 3 + rand.nextInt(6)));
                    break;
                }
                case 1: {
                    this.crackGenSlabs.func_180709_b(world, rand, new BlockPos(x - 3 + rand.nextInt(6), y + 6 - 3 + rand.nextInt(6), z - 3 + rand.nextInt(6)));
                    break;
                }
                case 2: {
                    this.crackGenStairs.func_180709_b(world, rand, new BlockPos(x - 3 + rand.nextInt(6), y + 6 - 3 + rand.nextInt(6), z - 3 + rand.nextInt(6)));
                    break;
                }
                case 3: {
                    this.mossGen.func_180709_b(world, rand, new BlockPos(x - 3 + rand.nextInt(6), y + 6 - 3 + rand.nextInt(6), z - 3 + rand.nextInt(6)));
                }
            }
            if (rand.nextInt(4) != 0) continue;
            if (rand.nextInt(8) == 0) {
                this.lichenClusterGen.func_180709_b(world, rand, new BlockPos(x - 3 + rand.nextInt(6), y + 6 - 3 + rand.nextInt(6), z - 3 + rand.nextInt(6)));
                continue;
            }
            this.mossClusterGen.func_180709_b(world, rand, new BlockPos(x - 3 + rand.nextInt(6), y + 6 - 3 + rand.nextInt(6), z - 3 + rand.nextInt(6)));
        }
        world.func_175656_a(new BlockPos(x, y - 1, z), BlockRegistry.WEEDWOOD_CHEST.func_176223_P());
        TileEntity tile = world.func_175625_s(new BlockPos(x, y - 1, z));
        if (tile instanceof TileEntityChest) {
            ((TileEntityChest)tile).func_189404_a(LootTableRegistry.COMMON_CHEST_LOOT, rand.nextLong());
        }
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        AxisAlignedBB locationAABB = this.rotatedAABB(world, xx, y, zz, 0.0, 0.0, 0.0, 8.0, 8.0, 8.0, direction).func_72314_b(3.0, 3.0, 3.0);
        LocationStorage locationStorage = new LocationStorage(worldStorage, new StorageUUID(UUID.randomUUID()), LocalRegion.getFromBlockPos(x, z), "idol_head", EnumLocationType.IDOL_HEAD);
        locationStorage.setSeed(rand.nextLong());
        locationStorage.addBounds(locationAABB);
        locationStorage.setVisible(false);
        locationStorage.linkChunks();
        locationStorage.setDirty(true);
        worldStorage.getLocalStorageHandler().addLocalStorage(locationStorage);
        return true;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        return this.generateStructure(worldIn, rand, position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
    }
}

