/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenPlantCluster
extends WorldGenerator {
    private final IBlockState blockState;
    private final Block block;
    private final int offset;
    private final int attempts;
    private boolean isUnderwater = false;

    public WorldGenPlantCluster(IBlockState blockState, int offset, int attempts) {
        this.blockState = blockState;
        this.block = blockState.func_177230_c();
        this.offset = offset;
        this.attempts = attempts;
    }

    public WorldGenPlantCluster(IBlockState blockState) {
        this(blockState, 8, 128);
    }

    public WorldGenPlantCluster setUnderwater(boolean underwater) {
        this.isUnderwater = underwater;
        return this;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        boolean generated = false;
        IBlockState iblockstate = worldIn.func_180495_p(position);
        while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, position) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, position)) && position.func_177956_o() > 0) {
            position = position.func_177977_b();
            iblockstate = worldIn.func_180495_p(position);
        }
        for (int i = 0; i < this.attempts; ++i) {
            BlockPos blockpos = position.func_177982_a(rand.nextInt(this.offset) - rand.nextInt(this.offset), rand.nextInt(this.offset / 2 + 1) - rand.nextInt(this.offset / 2 + 1), rand.nextInt(this.offset) - rand.nextInt(this.offset));
            if (!worldIn.func_175623_d(blockpos) && (!this.isUnderwater || !worldIn.func_180495_p(blockpos).func_185904_a().func_76224_d()) || !this.block.func_176196_c(worldIn, blockpos)) continue;
            this.func_175903_a(worldIn, blockpos, this.blockState);
            generated = true;
        }
        return generated;
    }
}

