/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.container.BlockLootPot;
import thebetweenlands.common.block.structure.BlockMobSpawnerBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityLootPot;
import thebetweenlands.common.tile.spawner.MobSpawnerLogicBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public abstract class WorldGenHelper
extends WorldGenerator {
    private final boolean doBlockNotify;
    protected int width;
    protected int height;
    protected int depth;
    protected List<Predicate<IBlockState>> replaceable = new ArrayList<Predicate<IBlockState>>();
    private BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();

    protected BlockPos.MutableBlockPos getCheckPos(int x, int y, int z) {
        this.checkPos.func_181079_c(x, y, z);
        return this.checkPos;
    }

    public WorldGenHelper(int width, int height, int depth, IBlockState ... replaceable) {
        this(false);
        this.width = width;
        this.height = height;
        this.depth = depth;
        for (IBlockState state : replaceable) {
            this.replaceable.add(s -> s == state);
        }
    }

    public WorldGenHelper(IBlockState ... replaceable) {
        this(false);
        for (IBlockState state : replaceable) {
            this.replaceable.add(s -> s == state);
        }
    }

    public WorldGenHelper() {
        super(false);
        this.doBlockNotify = false;
    }

    public WorldGenHelper(boolean notify) {
        super(notify);
        this.doBlockNotify = notify;
    }

    @SafeVarargs
    public final void rotatedCubeVolume(World world, int x, int y, int z, int offsetX, int offsetY, int offsetZ, IBlockState blockState, int sizeWidth, int sizeHeight, int sizeDepth, int rotation, Consumer<BlockPos> ... callbacks) {
        this.rotatedCubeVolume(world, null, x, y, z, offsetX, offsetY, offsetZ, blockState, sizeWidth, sizeHeight, sizeDepth, rotation, callbacks);
    }

    @SafeVarargs
    public final void rotatedCubeVolume(World world, @Nullable Predicate<BlockPos> pred, int x, int y, int z, int offsetX, int offsetY, int offsetZ, IBlockState blockState, int sizeWidth, int sizeHeight, int sizeDepth, int rotation, Consumer<BlockPos> ... callbacks) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (rotation) {
            case 0: {
                for (int yy = y + offsetY; yy < y + offsetY + sizeHeight; ++yy) {
                    for (int xx = x + offsetX; xx < x + offsetX + sizeWidth; ++xx) {
                        for (int zz = z + offsetZ; zz < z + offsetZ + sizeDepth; ++zz) {
                            BlockPos pos = new BlockPos(xx, yy, zz);
                            if (pred != null && !pred.test(pos)) continue;
                            this.func_175903_a(world, pos, blockState);
                            for (Consumer<BlockPos> callback : callbacks) {
                                callback.accept(pos);
                            }
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetY; yy < y + offsetY + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetX - 1; zz > z + this.depth - offsetX - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetZ; xx < x + offsetZ + sizeDepth; ++xx) {
                            BlockPos pos = new BlockPos(xx, yy, zz);
                            if (pred != null && !pred.test(pos)) continue;
                            this.func_175903_a(world, pos, blockState);
                            for (Consumer<BlockPos> callback : callbacks) {
                                callback.accept(pos);
                            }
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetY; yy < y + offsetY + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetX - 1; xx > x + this.width - offsetX - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetZ - 1; zz > z + this.depth - offsetZ - sizeDepth - 1; --zz) {
                            BlockPos pos = new BlockPos(xx, yy, zz);
                            if (pred != null && !pred.test(pos)) continue;
                            this.func_175903_a(world, pos, blockState);
                            for (Consumer<BlockPos> callback : callbacks) {
                                callback.accept(pos);
                            }
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetY; yy < y + offsetY + sizeHeight; ++yy) {
                    for (int zz = z + offsetX; zz < z + offsetX + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetZ - 1; xx > x + this.width - offsetZ - sizeDepth - 1; --xx) {
                            BlockPos pos = new BlockPos(xx, yy, zz);
                            if (pred != null && !pred.test(pos)) continue;
                            this.func_175903_a(world, pos, blockState);
                            for (Consumer<BlockPos> callback : callbacks) {
                                callback.accept(pos);
                            }
                        }
                    }
                }
                break;
            }
        }
    }

    public final AxisAlignedBB rotatedAABB(World world, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double sizeWidth, double sizeHeight, double sizeDepth, int rotation) {
        x -= (double)(this.width / 2);
        z -= (double)(this.depth / 2);
        switch (rotation) {
            default: {
                return new AxisAlignedBB(x + offsetX, y + offsetY, z + offsetZ, x + offsetX + sizeWidth, y + offsetY + sizeHeight, z + offsetZ + sizeDepth);
            }
            case 1: {
                return new AxisAlignedBB(x + offsetZ, y + offsetY, z + (double)this.depth - offsetX - sizeWidth - 1.0, x + offsetZ + sizeDepth, y + offsetY + sizeHeight, z + (double)this.depth - offsetX - 1.0);
            }
            case 2: {
                return new AxisAlignedBB(x + (double)this.width - offsetX - sizeWidth - 1.0, y + offsetY, z + (double)this.depth - offsetZ - sizeDepth - 1.0, x + (double)this.width - offsetX - 1.0, y + offsetY + sizeHeight, z + (double)this.depth - offsetZ - 1.0);
            }
            case 3: 
        }
        return new AxisAlignedBB(x + (double)this.width - offsetZ - sizeDepth - 1.0, y + offsetY, z + offsetX, x + (double)this.width - offsetZ - 1.0, y + offsetY + sizeHeight, z + offsetX + sizeWidth);
    }

    public final BlockPos rotatePos(World world, int x, int y, int z, int offsetX, int offsetY, int offsetZ, int rotation) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (rotation) {
            default: {
                return new BlockPos(x + offsetX, y + offsetY, z + offsetZ);
            }
            case 1: {
                return new BlockPos(x + offsetZ, y + offsetY, z + this.depth - offsetX - 1);
            }
            case 2: {
                return new BlockPos(x + this.width - offsetX - 1, y + offsetY, z + this.depth - offsetZ - 1);
            }
            case 3: 
        }
        return new BlockPos(x + this.width - offsetZ - 1, y + offsetY, z + offsetX);
    }

    public final BlockPos rotatePosNoOffsets(World world, int x, int y, int z, int offsetX, int offsetY, int offsetZ, int rotation) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (rotation) {
            default: {
                return new BlockPos(x + offsetX, y + offsetY, z + offsetZ);
            }
            case 1: {
                return new BlockPos(x + offsetZ, y + offsetY, z + this.depth - offsetX);
            }
            case 2: {
                return new BlockPos(x + this.width - offsetX, y + offsetY, z + this.depth - offsetZ);
            }
            case 3: 
        }
        return new BlockPos(x + this.width - offsetZ, y + offsetY, z + offsetX);
    }

    public final BlockPos rotatePos(World world, BlockPos pos, int offsetX, int offsetY, int offsetZ, int rotation) {
        return this.rotatePos(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), offsetX, offsetY, offsetZ, rotation);
    }

    @SafeVarargs
    public final void rotatedCubeVolumeExtendedDown(World world, int x, int y, int z, int offsetX, int offsetY, int offsetZ, IBlockState blockState, int sizeWidth, int sizeHeight, int sizeDepth, int rotation, Consumer<BlockPos> ... callbacks) {
        for (int w = 0; w < sizeWidth; ++w) {
            for (int d = 0; d < sizeDepth; ++d) {
                while (y + offsetY > 0 && this.isReplaceable(world, x, y, z, offsetX + w, offsetY - 1, offsetZ + d, rotation)) {
                    --offsetY;
                    ++sizeHeight;
                }
                this.rotatedCubeVolume(world, x, y, z, offsetX + w, offsetY, offsetZ + d, blockState, 1, sizeHeight, 1, rotation, callbacks);
            }
        }
    }

    public boolean isReplaceable(World world, int x, int y, int z, int offsetX, int offsetY, int offsetZ, int rotation) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (rotation) {
            case 0: {
                BlockPos.MutableBlockPos pos = this.getCheckPos(x + offsetX, y + offsetY, z + offsetZ);
                return world.func_175667_e((BlockPos)pos) && (world.func_180495_p((BlockPos)pos).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)pos) || this.replaceable != null && this.checkReplaceablePredicates(world.func_180495_p((BlockPos)pos)));
            }
            case 1: {
                BlockPos.MutableBlockPos pos = this.getCheckPos(x + offsetZ, y + offsetY, z + this.depth - offsetX - 1);
                return world.func_175667_e((BlockPos)pos) && (world.func_180495_p((BlockPos)pos).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)pos) || this.replaceable != null && this.checkReplaceablePredicates(world.func_180495_p((BlockPos)pos)));
            }
            case 2: {
                BlockPos.MutableBlockPos pos = this.getCheckPos(x + this.width - offsetX - 1, y + offsetY, z + this.depth - offsetZ - 1);
                return world.func_175667_e((BlockPos)pos) && (world.func_180495_p((BlockPos)pos).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)pos) || this.replaceable != null && this.checkReplaceablePredicates(world.func_180495_p((BlockPos)pos)));
            }
            case 3: {
                BlockPos.MutableBlockPos pos = this.getCheckPos(x + this.width - offsetZ - 1, y + offsetY, z + offsetX);
                return world.func_175667_e((BlockPos)pos) && (world.func_180495_p((BlockPos)pos).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)pos) || this.replaceable != null && this.checkReplaceablePredicates(world.func_180495_p((BlockPos)pos)));
            }
        }
        return false;
    }

    private boolean checkReplaceablePredicates(IBlockState state) {
        for (Predicate<IBlockState> replaceable : this.replaceable) {
            if (!replaceable.test(state)) continue;
            return true;
        }
        return false;
    }

    public boolean rotatedCubeMatches(World world, int x, int y, int z, int offsetX, int offsetY, int offsetZ, int sizeWidth, int sizeHeight, int sizeDepth, int rotation, SurfaceType type) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (rotation) {
            case 0: {
                for (int yy = y + offsetY; yy < y + offsetY + sizeHeight; ++yy) {
                    for (int xx = x + offsetX; xx < x + offsetX + sizeWidth; ++xx) {
                        for (int zz = z + offsetZ; zz < z + offsetZ + sizeDepth; ++zz) {
                            if (world.func_175667_e((BlockPos)this.getCheckPos(xx, yy, zz)) && type.matches(world.func_180495_p((BlockPos)this.getCheckPos(xx, yy, zz)))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetY; yy < y + offsetY + sizeHeight; ++yy) {
                    for (int zz = z + sizeDepth - offsetX - 1; zz > z + sizeDepth - offsetX - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetZ; xx < x + offsetZ + sizeDepth; ++xx) {
                            if (world.func_175667_e((BlockPos)this.getCheckPos(xx, yy, zz)) && type.matches(world.func_180495_p((BlockPos)this.getCheckPos(xx, yy, zz)))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetY; yy < y + offsetY + sizeHeight; ++yy) {
                    for (int xx = x + sizeWidth - offsetX - 1; xx > x + sizeWidth - offsetX - sizeWidth - 1; --xx) {
                        for (int zz = z + sizeDepth - offsetZ - 1; zz > z + sizeDepth - offsetZ - sizeDepth - 1; --zz) {
                            if (world.func_175667_e((BlockPos)this.getCheckPos(xx, yy, zz)) && type.matches(world.func_180495_p((BlockPos)this.getCheckPos(xx, yy, zz)))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetY; yy < y + offsetY + sizeHeight; ++yy) {
                    for (int zz = z + offsetX; zz < z + offsetX + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetZ - 1; xx > x + this.width - offsetZ - sizeDepth - 1; --xx) {
                            if (world.func_175667_e((BlockPos)this.getCheckPos(xx, yy, zz)) && type.matches(world.func_180495_p((BlockPos)this.getCheckPos(xx, yy, zz)))) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    public void rotatedLootPot(World world, Random rand, int x, int y, int z, int offsetX, int offsetY, int offsetZ, int rotation, int min, int max, int chance, ResourceLocation lootTable) {
        x -= this.width / 2;
        z -= this.depth / 2;
        if (rand.nextInt(chance) == 0) {
            return;
        }
        switch (rotation) {
            case 0: {
                this.generateLootPot(world, rand, new BlockPos(x + offsetX, y + offsetY, z + offsetZ), min, max, lootTable);
                break;
            }
            case 1: {
                this.generateLootPot(world, rand, new BlockPos(x + offsetZ, y + offsetY, z + this.depth - offsetX - 1), min, max, lootTable);
                break;
            }
            case 2: {
                this.generateLootPot(world, rand, new BlockPos(x + this.width - offsetX - 1, y + offsetY, z + this.depth - offsetZ - 1), min, max, lootTable);
                break;
            }
            case 3: {
                this.generateLootPot(world, rand, new BlockPos(x + this.width - offsetZ - 1, y + offsetY, z + offsetX), min, max, lootTable);
            }
        }
    }

    public void rotatedLootChest(World world, Random rand, int x, int y, int z, int offsetX, int offsetY, int offsetZ, int rotation, int min, int max, int chance, int sequenceStart, ResourceLocation lootTable) {
        x -= this.width / 2;
        z -= this.depth / 2;
        if (rand.nextInt(chance) == 0) {
            return;
        }
        switch (rotation) {
            case 0: {
                this.generateLootChest(world, rand, new BlockPos(x + offsetX, y + offsetY, z + offsetZ), min, max, this.getStateFromRotation(sequenceStart, rotation, BlockRegistry.WEEDWOOD_CHEST.func_176223_P(), EnumRotationSequence.CHEST), lootTable);
                break;
            }
            case 1: {
                this.generateLootChest(world, rand, new BlockPos(x + offsetZ, y + offsetY, z + this.depth - offsetX - 1), min, max, this.getStateFromRotation(sequenceStart, rotation, BlockRegistry.WEEDWOOD_CHEST.func_176223_P(), EnumRotationSequence.CHEST), lootTable);
                break;
            }
            case 2: {
                this.generateLootChest(world, rand, new BlockPos(x + this.width - offsetX - 1, y + offsetY, z + this.depth - offsetZ - 1), min, max, this.getStateFromRotation(sequenceStart, rotation, BlockRegistry.WEEDWOOD_CHEST.func_176223_P(), EnumRotationSequence.CHEST), lootTable);
                break;
            }
            case 3: {
                this.generateLootChest(world, rand, new BlockPos(x + this.width - offsetZ - 1, y + offsetY, z + offsetX), min, max, this.getStateFromRotation(sequenceStart, rotation, BlockRegistry.WEEDWOOD_CHEST.func_176223_P(), EnumRotationSequence.CHEST), lootTable);
            }
        }
    }

    public MobSpawnerLogicBetweenlands rotatedSpawner(World world, int x, int y, int z, int offsetX, int offsetY, int offsetZ, int rotation, String mob) {
        BlockPos pos = new BlockPos(x, y, z).func_177982_a(-(this.width / 2), 0, -(this.depth / 2));
        IBlockState spawner = BlockRegistry.MOB_SPAWNER.func_176223_P();
        switch (rotation) {
            case 0: {
                pos = pos.func_177982_a(offsetX, offsetY, offsetZ);
                this.func_175903_a(world, pos, spawner);
                BlockMobSpawnerBetweenlands.setMob(world, pos, mob, new Consumer[0]);
                return BlockMobSpawnerBetweenlands.getLogic(world, pos);
            }
            case 1: {
                pos = pos.func_177982_a(offsetZ, offsetY, this.depth - offsetX - 1);
                this.func_175903_a(world, pos, spawner);
                BlockMobSpawnerBetweenlands.setMob(world, pos, mob, new Consumer[0]);
                return BlockMobSpawnerBetweenlands.getLogic(world, pos);
            }
            case 2: {
                pos = pos.func_177982_a(this.width - offsetX - 1, offsetY, this.depth - offsetZ - 1);
                this.func_175903_a(world, pos, spawner);
                BlockMobSpawnerBetweenlands.setMob(world, pos, mob, new Consumer[0]);
                return BlockMobSpawnerBetweenlands.getLogic(world, pos);
            }
        }
        pos = pos.func_177982_a(this.width - offsetZ - 1, offsetY, offsetX);
        this.func_175903_a(world, pos, spawner);
        BlockMobSpawnerBetweenlands.setMob(world, pos, mob, new Consumer[0]);
        return BlockMobSpawnerBetweenlands.getLogic(world, pos);
    }

    public boolean rotatedCubeCantReplace(World world, int x, int y, int z, int offsetA, int offsetB, int offsetC, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        x -= this.width / 2;
        z -= this.depth / 2;
        switch (direction) {
            case 0: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + offsetA; xx < x + offsetA + sizeWidth; ++xx) {
                        for (int zz = z + offsetC; zz < z + offsetC + sizeDepth; ++zz) {
                            if (world.func_175667_e((BlockPos)this.getCheckPos(xx, yy, zz)) && this.isReplaceable(world, xx, yy, zz, 0, 0, 0, 0)) continue;
                            return true;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + this.depth - offsetA - 1; zz > z + this.depth - offsetA - sizeWidth - 1; --zz) {
                        for (int xx = x + offsetC; xx < x + offsetC + sizeDepth; ++xx) {
                            if (world.func_175667_e((BlockPos)this.getCheckPos(xx, yy, zz)) && this.isReplaceable(world, xx, yy, zz, 0, 0, 0, 0)) continue;
                            return true;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int xx = x + this.width - offsetA - 1; xx > x + this.width - offsetA - sizeWidth - 1; --xx) {
                        for (int zz = z + this.depth - offsetC - 1; zz > z + this.depth - offsetC - sizeDepth - 1; --zz) {
                            if (world.func_175667_e((BlockPos)this.getCheckPos(xx, yy, zz)) && this.isReplaceable(world, xx, yy, zz, 0, 0, 0, 0)) continue;
                            return true;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = y + offsetB; yy < y + offsetB + sizeHeight; ++yy) {
                    for (int zz = z + offsetA; zz < z + offsetA + sizeWidth; ++zz) {
                        for (int xx = x + this.width - offsetC - 1; xx > x + this.width - offsetC - sizeDepth - 1; --xx) {
                            if (world.func_175667_e((BlockPos)this.getCheckPos(xx, yy, zz)) && this.isReplaceable(world, xx, yy, zz, 0, 0, 0, 0)) continue;
                            return true;
                        }
                    }
                }
                break;
            }
        }
        return false;
    }

    public void generateLootPot(World world, Random random, BlockPos pos, int min, int max, ResourceLocation list) {
        this.func_175903_a(world, pos, this.getRandomLootPot(random));
        TileEntityLootPot lootPot = BlockLootPot.getTileEntity((IBlockAccess)world, pos);
        if (lootPot != null) {
            lootPot.setLootTable(list, random.nextLong());
        }
    }

    public void generateLootChest(World world, Random random, BlockPos pos, int min, int max, IBlockState state, ResourceLocation lootTable) {
        this.func_175903_a(world, pos, state);
        TileEntity chest = world.func_175625_s(pos);
        if (chest instanceof TileEntityChest) {
            ((TileEntityChest)chest).func_189404_a(lootTable, random.nextLong());
        }
    }

    public IBlockState getStateFromRotation(int start, int rotation, IBlockState state, EnumRotationSequence enumRotationSequence) {
        return state.func_177230_c().func_176203_a(enumRotationSequence.sequence[(rotation + start) % enumRotationSequence.sequence.length]);
    }

    public IBlockState getRandomLootPot(Random random) {
        int randDirection = random.nextInt(4) + 2;
        switch (random.nextInt(3)) {
            case 0: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_1)).func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)EnumFacing.func_82600_a((int)randDirection));
            }
            case 1: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_2)).func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)EnumFacing.func_82600_a((int)randDirection));
            }
        }
        return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_3)).func_177226_a((IProperty)BlockLootPot.FACING, (Comparable)EnumFacing.func_82600_a((int)randDirection));
    }

    protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
        if (this.doBlockNotify) {
            worldIn.func_180501_a(pos, state, 19);
        } else {
            worldIn.func_180501_a(pos, state, 18);
        }
    }

    public static enum EnumRotationSequence {
        STAIR(0, 3, 1, 2),
        UPSIDE_DOWN_STAIR(4, 7, 5, 6),
        CHEST(2, 5, 3, 4),
        LOG_SIDEWAYS(4, 8),
        PILLAR_SIDEWAYS(8, 7);

        private int[] sequence;

        private EnumRotationSequence(int ... sequence) {
            this.sequence = sequence;
        }
    }
}

