/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.registries.BlockRegistry;

public class WorldGenFluidPool
extends WorldGenerator {
    private final Block block;
    private final List<Block> blackListedBlocks = ImmutableList.of((Object)BlockRegistry.BETWEENSTONE_TILES, (Object)BlockRegistry.BETWEENSTONE_BRICK_STAIRS, (Object)BlockRegistry.BETWEENSTONE_BRICKS, (Object)BlockRegistry.BETWEENSTONE_BRICK_SLAB);
    private final double size;
    private int minY = 0;

    public WorldGenFluidPool(Block blockIn, double size) {
        super(true);
        this.block = blockIn;
        this.size = size;
    }

    public WorldGenFluidPool(Block blockIn) {
        this(blockIn, 1.0);
    }

    public WorldGenFluidPool setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int oy;
        int ox;
        position = position.func_177982_a(-8, 0, -8);
        while (position.func_177956_o() > 5 && worldIn.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        if (position.func_177956_o() <= 4 + this.minY) {
            return false;
        }
        position = position.func_177979_c(4);
        for (int xx = 0; xx < 16; ++xx) {
            for (int zz = 0; zz < 16; ++zz) {
                for (int yy = 0; yy < 8; ++yy) {
                    if (!this.blackListedBlocks.contains(worldIn.func_180495_p(position.func_177982_a(xx, yy, zz)).func_177230_c())) continue;
                    return false;
                }
            }
        }
        boolean[] isInPool = new boolean[2048];
        int blobs = rand.nextInt(4) + 4;
        for (int blob = 0; blob < blobs; ++blob) {
            double sx = (rand.nextDouble() * 6.0 + 3.0) * this.size;
            double sy = (rand.nextDouble() * 4.0 + 2.0) * this.size;
            double sz = (rand.nextDouble() * 6.0 + 3.0) * this.size;
            double bx = rand.nextDouble() * (16.0 - sx - 2.0) + 1.0 + sx / 2.0;
            double by = rand.nextDouble() * (8.0 - sy - 4.0) + 2.0 + sy / 2.0;
            double bz = rand.nextDouble() * (16.0 - sz - 2.0) + 1.0 + sz / 2.0;
            for (int ox2 = 1; ox2 < 15; ++ox2) {
                for (int oz = 1; oz < 15; ++oz) {
                    for (int oy2 = 1; oy2 < 7; ++oy2) {
                        double dx = ((double)ox2 - bx) / (sx / 2.0);
                        double dy = ((double)oy2 - by) / (sy / 2.0);
                        double dz = ((double)oz - bz) / (sz / 2.0);
                        double dst = dx * dx + dy * dy + dz * dz;
                        if (!(dst < 1.0)) continue;
                        isInPool[(ox2 * 16 + oz) * 8 + oy2] = true;
                    }
                }
            }
        }
        for (ox = 0; ox < 16; ++ox) {
            for (int oz = 0; oz < 16; ++oz) {
                for (oy = 0; oy < 8; ++oy) {
                    boolean isOuterBlock;
                    boolean bl = isOuterBlock = !isInPool[(ox * 16 + oz) * 8 + oy] && (ox < 15 && isInPool[((ox + 1) * 16 + oz) * 8 + oy] || ox > 0 && isInPool[((ox - 1) * 16 + oz) * 8 + oy] || oz < 15 && isInPool[(ox * 16 + oz + 1) * 8 + oy] || oz > 0 && isInPool[(ox * 16 + (oz - 1)) * 8 + oy] || oy < 7 && isInPool[(ox * 16 + oz) * 8 + oy + 1] || oy > 0 && isInPool[(ox * 16 + oz) * 8 + (oy - 1)]);
                    if (!isOuterBlock) continue;
                    Material material = worldIn.func_180495_p(position.func_177982_a(ox, oy, oz)).func_185904_a();
                    if (oy >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (oy >= 4 || material.func_76220_a() || worldIn.func_180495_p(position.func_177982_a(ox, oy, oz)).func_177230_c() == this.block) continue;
                    return false;
                }
            }
        }
        for (ox = 0; ox < 16; ++ox) {
            for (int oz = 0; oz < 16; ++oz) {
                for (oy = 0; oy < 8; ++oy) {
                    if (!isInPool[(ox * 16 + oz) * 8 + oy]) continue;
                    this.func_175903_a(worldIn, position.func_177982_a(ox, oy, oz), oy >= 4 ? Blocks.field_150350_a.func_176223_P() : this.block.func_176223_P());
                }
            }
        }
        return true;
    }
}

