/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Stack;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.block.plant.BlockCaveMoss;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.feature.WorldGenCave;
import thebetweenlands.util.CubicBezier;

public class WorldGenCaveMoss
extends WorldGenCave {
    private static final CubicBezier HEIGHT_CDF = new CubicBezier(0.75f, 0.0f, 0.9f, 1.0f);
    private static final int MIN_RADIUS = 3;
    private static final int MAX_RADIUS = 6;
    private static final int MAX_HEIGHT = 5;

    public WorldGenCaveMoss() {
        super(false);
    }

    public boolean func_180709_b(World world, Random random, BlockPos origin) {
        int i;
        if (!this.isGoodStart(world, origin)) {
            return false;
        }
        int radius = random.nextInt(4) + 3;
        int radiusSq = radius * radius;
        Stack<BlockPos> searching = new Stack<BlockPos>();
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        ArrayList<WorldGenCave.PlantLocation> locations = new ArrayList<WorldGenCave.PlantLocation>();
        BlockPos start = origin.func_177982_a(0, -1, 0);
        searching.push(start);
        checked.add(start);
        while (!searching.isEmpty()) {
            BlockPos pos = (BlockPos)searching.pop();
            double distSq = pos.func_177954_c((double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p());
            if ((double)random.nextFloat() > distSq / (double)radiusSq) {
                locations.add(new WorldGenCave.PlantLocation(world, pos));
            }
            for (EnumFacing dir : this.directions) {
                BlockPos offsetPos = pos.func_177972_a(dir);
                if (offsetPos.func_177954_c((double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p()) > (double)radiusSq || !this.supports(world, offsetPos.func_177982_a(0, 1, 0)) || checked.contains(offsetPos)) continue;
                searching.push(offsetPos);
                checked.add(offsetPos);
            }
        }
        if (locations.size() < 3) {
            return false;
        }
        float[] heights = new float[locations.size()];
        for (i = 0; i < locations.size(); ++i) {
            heights[i] = HEIGHT_CDF.eval((float)i / (float)(locations.size() - 1));
        }
        Collections.shuffle(locations, random);
        for (i = 0; i < locations.size(); ++i) {
            WorldGenCave.PlantLocation location = (WorldGenCave.PlantLocation)locations.get(i);
            BlockPos pos = location.getPos();
            int height = location.getHeight();
            if (height > 5) {
                height = 5;
            }
            height = (int)(heights[i] * (float)(height - 1) + 1.0f);
            for (int dy = 0; dy < height; ++dy) {
                this.func_175903_a(world, pos.func_177982_a(0, -dy, 0), BlockRegistry.CAVE_MOSS.func_176223_P().func_177226_a((IProperty)BlockCaveMoss.CAN_GROW, (Comparable)Boolean.valueOf(false)));
            }
        }
        return true;
    }
}

