/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import thebetweenlands.common.registries.BiomeRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.feature.FractalOpenSimplexNoise;
import thebetweenlands.util.MathUtils;
import thebetweenlands.util.OpenSimplexNoise;

public class MapGenCavesBetweenlands
extends MapGenBase {
    private static final int CHUNK_SIZE = 16;
    private static final double XZ_CAVE_SCALE = 0.08;
    private static final double Y_CAVE_SCALE = 0.15;
    private static final double XZ_FORM_SCALE = 0.5;
    private static final double Y_FORM_SCALE = 0.3;
    private static final double FORM_SCALE = 0.4;
    private static final double XZ_BREAK_SCALE = 0.05;
    private static final double BREAK_SCALE = 0.85;
    private static final double BASE_LIMIT = -0.3;
    private static final int LOWER_BOUND = 10;
    private static final int UPPER_BOUND = 20;
    private static final double SHOULDNT_BREAK = 3.5;
    private static final double RIDGE_EXTENTS = 0.5;
    private OpenSimplexNoise cave;
    private OpenSimplexNoise seaLevelBreak;
    private FractalOpenSimplexNoise form;
    private List<BiomeBetweenlands> noBreakBiomes;
    private BiomeWeights biomeWeights;
    private double[] noiseField = new double[10449];
    private double[] seaBreakNoiseField = new double[256];

    public MapGenCavesBetweenlands(long seed) {
        this.cave = new OpenSimplexNoise(seed);
        this.seaLevelBreak = new OpenSimplexNoise(seed + 1L);
        this.form = new FractalOpenSimplexNoise(seed + 2L, 4, 0.1);
        this.noBreakBiomes = Lists.newArrayList((Object[])new BiomeBetweenlands[]{BiomeRegistry.DEEP_WATERS, BiomeRegistry.COARSE_ISLANDS, BiomeRegistry.MARSH_0, BiomeRegistry.MARSH_1, BiomeRegistry.PATCHY_ISLANDS, BiomeRegistry.SLUDGE_PLAINS, BiomeRegistry.SWAMPLANDS_CLEARING});
    }

    public void setBiomeTerrainWeights(BiomeWeights biomeWeights) {
        this.biomeWeights = biomeWeights;
    }

    public void func_186125_a(World world, int chunkX, int chunkZ, ChunkPrimer primer) {
        int z;
        int x;
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (x = 0; x < 9; ++x) {
            for (z = 0; z < 9; ++z) {
                int y = 0;
                while (y < 129) {
                    int index = (x * 9 + z) * 129 + y;
                    int bx = cx + x * 2;
                    int bz = cz + z * 2;
                    int by = y++;
                    this.noiseField[index] = this.sampleNoise(bx, by, bz);
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                this.seaBreakNoiseField[x * 16 + z] = this.seaLevelBreak.eval((double)(cx + x) * 0.05, (double)(cz + z) * 0.05);
            }
        }
        for (x = 0; x < 8; ++x) {
            int indexXC = x * 9;
            int indexXN = (x + 1) * 9;
            for (int z2 = 0; z2 < 8; ++z2) {
                int indexXCZC = (indexXC + z2) * 129;
                int indexXCZN = (indexXC + z2 + 1) * 129;
                int indexXNZC = (indexXN + z2) * 129;
                int indexXNZN = (indexXN + z2 + 1) * 129;
                for (int y = 0; y < 128; ++y) {
                    double valXCZCYC = this.noiseField[indexXCZC + y];
                    double valXCZNYC = this.noiseField[indexXCZN + y];
                    double valXNZCYC = this.noiseField[indexXNZC + y];
                    double valXNZNYC = this.noiseField[indexXNZN + y];
                    double valXCZCYN = this.noiseField[indexXCZC + y + 1];
                    double valXCZNYN = this.noiseField[indexXCZN + y + 1];
                    double valXNZCYN = this.noiseField[indexXNZC + y + 1];
                    double valXNZNYN = this.noiseField[indexXNZN + y + 1];
                    double stepXAxisYCZC = (valXNZCYC - valXCZCYC) * 0.5;
                    double stepXAxisYCZN = (valXNZNYC - valXCZNYC) * 0.5;
                    double stepXAxisYNZC = (valXNZCYN - valXCZCYN) * 0.5;
                    double stepXAxisYNZN = (valXNZNYN - valXCZNYN) * 0.5;
                    double currentValXCZCYC = valXCZCYC;
                    double currentValXCZNYC = valXCZNYC;
                    double currentValXCZCYN = valXCZCYN;
                    double currentValXCZNYN = valXCZNYN;
                    for (int xo = 0; xo < 2; ++xo) {
                        double currentValYCZC = currentValXCZCYC;
                        double currentValYNZC = currentValXCZCYN;
                        double stepZAxisYC = (currentValXCZNYC - currentValXCZCYC) * 0.5;
                        double stepZAxisYN = (currentValXCZNYN - currentValXCZCYN) * 0.5;
                        int bx = x * 2 + xo;
                        for (int zo = 0; zo < 2; ++zo) {
                            int level;
                            double stepYAxis = (currentValYNZC - currentValYCZC) * 0.5;
                            double currentValYC = currentValYNZC - stepYAxis;
                            int bz = z2 * 2 + zo;
                            Biome biome = world.func_180494_b((BlockPos)pos.func_181079_c(cx + bx, 0, cz + bz));
                            double shouldntBreak = this.noBreakBiomes.contains(biome) ? 3.5 : (double)(1.0f - this.biomeWeights.get(bx, bz)) * 3.5;
                            if (biome instanceof BiomeBetweenlands) {
                                IBlockState state;
                                for (level = (int)(biome.func_185355_j() - biome.func_185360_m()); level <= (int)(biome.func_185355_j() + biome.func_185360_m()) && (state = primer.func_177856_a(bx, level, bz)).func_185904_a() != Material.field_151579_a && !state.func_185904_a().func_76224_d(); ++level) {
                                }
                            } else {
                                IBlockState state;
                                for (level = 0; level <= 140 && (state = primer.func_177856_a(bx, level, bz)).func_185904_a() != Material.field_151579_a && !state.func_185904_a().func_76224_d(); ++level) {
                                }
                            }
                            for (int yo = 0; yo < 1; ++yo) {
                                IBlockState state;
                                int surfaceDist;
                                double noise = currentValYC += stepYAxis;
                                int by = y + yo;
                                double limit = -0.3;
                                if (by <= 10) {
                                    limit = (limit + 1.0) / 10.0 * (double)by - 1.0;
                                }
                                if ((surfaceDist = level - by) <= 20) {
                                    noise += (shouldntBreak + MathUtils.linearTransformd(this.seaBreakNoiseField[bx * 16 + bz], -1.0, 1.0, 0.0, 1.0)) * 0.85 * (double)(1.0f - (float)surfaceDist / 20.0f);
                                }
                                if ((state = primer.func_177856_a(bx, by, bz)).func_177230_c() == BlockRegistry.SWAMP_WATER && noise < limit + 0.25 && noise > limit) {
                                    primer.func_177855_a(bx, by, bz, BlockRegistry.COARSE_SWAMP_DIRT.func_176223_P());
                                    continue;
                                }
                                if (!(noise < limit) || state.func_177230_c() == BlockRegistry.BETWEENLANDS_BEDROCK) continue;
                                primer.func_177855_a(bx, by, bz, by > 15 ? Blocks.field_150350_a.func_176223_P() : BlockRegistry.SWAMP_WATER.func_176223_P());
                            }
                            currentValYCZC += stepZAxisYC;
                            currentValYNZC += stepZAxisYN;
                        }
                        currentValXCZCYC += stepXAxisYCZC;
                        currentValXCZNYC += stepXAxisYCZN;
                        currentValXCZCYN += stepXAxisYNZC;
                        currentValXCZNYN += stepXAxisYNZN;
                    }
                }
            }
        }
    }

    private double sampleNoise(int x, int y, int z) {
        return this.cave.eval((double)x * 0.08, (double)y * 0.15, (double)z * 0.08) + this.form.eval((double)x * 0.5, (double)y * 0.3, (double)z * 0.5) * 0.4;
    }
}

