/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.biome.decorator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.ChunkGeneratorBetweenlands;
import thebetweenlands.common.world.gen.biome.decorator.DecorationHelper;
import thebetweenlands.common.world.gen.biome.decorator.DecoratorPositionProvider;
import thebetweenlands.common.world.gen.feature.OreGens;

public class BiomeDecoratorBetweenlands
extends DecoratorPositionProvider {
    private static final List<String> profiledGenerators = new ArrayList<String>();
    private static boolean decorating;
    private final Biome biome;

    public BiomeDecoratorBetweenlands(Biome biome) {
        this.biome = biome;
    }

    @Override
    public Biome getBiome() {
        return this.biome;
    }

    public final void decorate(World world, ChunkGeneratorBetweenlands generator, Random rand, int x, int z) {
        this.init(world, this.biome, generator, rand, x, z);
        boolean wasDecorating = decorating;
        decorating = true;
        if (!wasDecorating) {
            profiledGenerators.clear();
            this.getProfiler().func_76320_a(this.getBiome().getRegistryName().func_110623_a());
        }
        this.decorate();
        if (!wasDecorating) {
            this.getProfiler().func_76319_b();
        }
        if (!wasDecorating) {
            decorating = false;
        }
    }

    protected void decorate() {
        this.startProfilerSection("ores");
        this.generateOres();
        this.endProfilerSection();
        this.startProfilerSection("caves");
        this.generate(DecorationHelper::populateCaves);
        this.endProfilerSection();
        this.startProfilerSection("stagnantWater");
        this.generate(2.0f, DecorationHelper::generateStagnantWaterPool);
        this.endProfilerSection();
        this.startProfilerSection("undergroundRuins");
        this.generate(200.0f, DecorationHelper::generateUndergroundRuins);
        this.endProfilerSection();
        this.startProfilerSection("undergroundSpawners");
        this.generate(1.0f, DecorationHelper::generateSpawner);
        this.endProfilerSection();
        this.startProfilerSection("tarPoolDungeons");
        this.generate(1.0f, DecorationHelper::generateTarPoolDungeon);
        this.endProfilerSection();
    }

    protected void generateOres() {
        this.generateOre(22.0f, 12, OreGens.SULFUR, 45, 128);
        this.generateOre(6.0f, 12, OreGens.SYRMORITE, 85, 105);
        this.generateOre(5.0f, 12, OreGens.BONE_ORE, 45, 128);
        this.generateOre(4.5f, 12, OreGens.OCTINE, 45, 70);
        this.generateOre(4.0f, 12, OreGens.SWAMP_DIRT, 45, 95);
        this.generateOre(0.2f, 12, OreGens.LIMESTONE, 45, 95);
        this.generateOre(1.0f, 12, OreGens.VALONITE, 0, 45);
        this.generateOre(3.0f, 12, OreGens.SCABYST, 0, 45);
        this.generateOre(70.0f, 2, OreGens.LIFE_GEM, 0, 15);
        Random rand = this.getRand();
        World world = this.getWorld();
        int cycles = rand.nextInt(4) == 0 ? 1 + rand.nextInt(3) : 0;
        block5: for (int i = 0; i < cycles; ++i) {
            if (rand.nextInt(9 / cycles + 1) != 0) continue;
            int xx = this.getX() + this.offsetXZ();
            int zz = this.getZ() + this.offsetXZ();
            int yy = world.func_175645_m(new BlockPos(xx, 0, zz)).func_177956_o() - 1;
            boolean hasMud = false;
            for (int yo = 0; yo < 16; ++yo) {
                if (world.func_180495_p(new BlockPos(xx, yy + yo, zz)).func_177230_c() != BlockRegistry.SWAMP_WATER || world.func_180495_p(new BlockPos(xx, yy + yo - 1, zz)).func_177230_c() != BlockRegistry.MUD) continue;
                hasMud = true;
                yy = yy + yo - 1;
            }
            if (!hasMud) continue;
            switch (rand.nextInt(3)) {
                case 0: {
                    world.func_175656_a(new BlockPos(xx, yy, zz), BlockRegistry.AQUA_MIDDLE_GEM_ORE.func_176223_P());
                    break block5;
                }
                case 1: {
                    world.func_175656_a(new BlockPos(xx, yy, zz), BlockRegistry.CRIMSON_MIDDLE_GEM_ORE.func_176223_P());
                    break block5;
                }
                case 2: {
                    world.func_175656_a(new BlockPos(xx, yy, zz), BlockRegistry.GREEN_MIDDLE_GEM_ORE.func_176223_P());
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
        }
    }

    protected void generateOre(float tries, int padding, WorldGenerator oreGen, int minY, int maxY) {
        tries = MathHelper.func_76141_d((float)tries) + (this.getRand().nextFloat() <= tries - (float)MathHelper.func_76141_d((float)tries) ? 1 : 0);
        int i = 0;
        while ((float)i < tries) {
            int xx = this.getX() + this.offsetXZ(padding);
            int yy = minY + this.getRand().nextInt(maxY - minY);
            int zz = this.getZ() + this.offsetXZ(padding);
            BlockPos pos = new BlockPos(xx, yy, zz);
            if (this.getWorld().func_175697_a(pos, padding)) {
                oreGen.func_180709_b(this.getWorld(), this.getRand(), pos);
            }
            ++i;
        }
    }

    public boolean generate(float tries, Function<BiomeDecoratorBetweenlands, Boolean> generator) {
        boolean generated = false;
        tries = MathHelper.func_76141_d((float)tries) + (this.getRand().nextFloat() <= tries - (float)MathHelper.func_76141_d((float)tries) ? 1 : 0);
        int i = 0;
        while ((float)i < tries) {
            if (generator.apply(this).booleanValue()) {
                generated = true;
            }
            ++i;
        }
        return generated;
    }

    public boolean generate(Function<BiomeDecoratorBetweenlands, Boolean> generator) {
        return this.generate(1.0f, generator);
    }

    public Profiler getProfiler() {
        return this.getWorld().field_72984_F;
    }

    public boolean isProfilingEnabled() {
        return BetweenlandsConfig.DEBUG.debug;
    }

    public boolean isRecursiveProfilingEnabled() {
        return false;
    }

    public void startProfilerSection(String name) {
        if (this.isProfilingEnabled() && this.getProfiler().field_76327_a && (this.isRecursiveProfilingEnabled() || !profiledGenerators.contains(this.getProfiler().func_76322_c()))) {
            this.getProfiler().func_76320_a(name);
            if (!this.isRecursiveProfilingEnabled()) {
                String section = this.getProfiler().func_76322_c();
                profiledGenerators.add(section);
            }
        }
    }

    public void endProfilerSection() {
        if (this.isProfilingEnabled() && this.getProfiler().field_76327_a) {
            if (!this.isRecursiveProfilingEnabled()) {
                String section = this.getProfiler().func_76322_c();
                boolean contained = profiledGenerators.remove(section);
                if (!"[UNKNOWN]".equals(section) && contained) {
                    this.getProfiler().func_76319_b();
                }
            } else {
                this.getProfiler().func_76319_b();
            }
        }
    }
}

