/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.biome.spawning.MobSpawnHandler;
import thebetweenlands.common.world.gen.ContextBetweenlands;
import thebetweenlands.common.world.gen.biome.BiomeWeights;
import thebetweenlands.common.world.gen.biome.decorator.BiomeDecoratorBetweenlands;
import thebetweenlands.common.world.gen.biome.generator.BiomeGenerator;
import thebetweenlands.common.world.gen.feature.MapGenCavesBetweenlands;
import thebetweenlands.common.world.gen.feature.MapGenGiantRoots;
import thebetweenlands.common.world.gen.feature.MapGenRavineBetweenlands;

public class ChunkGeneratorBetweenlands
implements IChunkGenerator {
    public final Block baseBlock;
    public final Block layerBlock;
    public final IBlockState baseBlockState;
    public final IBlockState layerBlockState;
    private final Random rand;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private final World worldObj;
    private final double[] heightMap;
    private final float[] biomeWeights;
    private double[] surfaceNoiseBuffer = new double[256];
    private float[] terrainBiomeWeights = new float[25];
    private float[] interpolatedTerrainBiomeWeights = new float[256];
    private Biome[] biomesForGeneration;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    private final long seed;
    private final int layerHeight;
    private MapGenCavesBetweenlands caveGenerator;
    private MapGenBase ravineGenerator;
    private MapGenBase giantRootGenerator;
    private NoiseGeneratorSimplex treeNoise;
    private NoiseGeneratorSimplex speleothemDensityNoise;
    public static boolean debugRecord = false;
    private Set<ChunkProvide> chunkProvides = Collections.synchronizedSet(new LinkedHashSet());
    private int maxSigLen;
    private int maxProvides;

    public ChunkGeneratorBetweenlands(World world, long seed, Block baseBlock, Block layerBlock, int layerHeight) {
        this.baseBlock = baseBlock;
        this.baseBlockState = baseBlock.func_176223_P();
        this.layerBlock = layerBlock;
        this.layerBlockState = layerBlock.func_176223_P();
        this.layerHeight = layerHeight;
        this.worldObj = world;
        this.seed = seed;
        this.rand = new Random(seed);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.biomeWeights[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.treeNoise = new NoiseGeneratorSimplex(this.rand);
        this.speleothemDensityNoise = new NoiseGeneratorSimplex(this.rand);
        ContextBetweenlands ctx = new ContextBetweenlands(this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.surfaceNoise, this.scaleNoise, this.depthNoise, this.treeNoise, this.speleothemDensityNoise);
        ctx = (ContextBetweenlands)TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.minLimitPerlinNoise = ctx.getLPerlin1();
        this.maxLimitPerlinNoise = ctx.getLPerlin2();
        this.mainPerlinNoise = ctx.getPerlin();
        this.surfaceNoise = ctx.getSurfaceNoise();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
        this.treeNoise = ctx.getTreeNoise();
        this.speleothemDensityNoise = ctx.getSpeleothemDensityNoise();
        world.func_181544_b(layerHeight);
        this.caveGenerator = new MapGenCavesBetweenlands(seed);
        this.ravineGenerator = new MapGenRavineBetweenlands();
        this.giantRootGenerator = new MapGenGiantRoots(seed);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.debugProvideHandle(chunkX, chunkZ);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(chunkX, chunkZ, chunkprimer);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                float currentVal;
                float fractionZ = (float)(z % 4) / 4.0f;
                float fractionX = (float)(x % 4) / 4.0f;
                int biomeWeightZ = z / 4;
                int biomeWeightX = x / 4;
                float weightXCZC = this.terrainBiomeWeights[biomeWeightX + biomeWeightZ * 5];
                float weightXNZC = this.terrainBiomeWeights[biomeWeightX + 1 + biomeWeightZ * 5];
                float weightXCZN = this.terrainBiomeWeights[biomeWeightX + (biomeWeightZ + 1) * 5];
                float weightXNZN = this.terrainBiomeWeights[biomeWeightX + 1 + (biomeWeightZ + 1) * 5];
                float interpZAxisXC = weightXCZC + (weightXCZN - weightXCZC) * fractionZ;
                float interpZAxisXN = weightXNZC + (weightXNZN - weightXNZC) * fractionZ;
                this.interpolatedTerrainBiomeWeights[x + z * 16] = currentVal = interpZAxisXC + (interpZAxisXN - interpZAxisXC) * fractionX;
            }
        }
        BiomeWeights biomeWeights = new BiomeWeights(this.interpolatedTerrainBiomeWeights);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBiomeBlocks(chunkX, chunkZ, chunkprimer, this.biomesForGeneration, biomeWeights);
        this.caveGenerator.setBiomeTerrainWeights(biomeWeights);
        this.caveGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        this.ravineGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                double baseBlockNoise = this.surfaceNoiseBuffer[z + x * 16];
                Biome biome = this.biomesForGeneration[z + x * 16];
                if (!(biome instanceof BiomeBetweenlands)) continue;
                BiomeGenerator generator = ((BiomeBetweenlands)biome).getBiomeGenerator();
                generator.runBiomeFeatures(chunkZ * 16 + z, chunkX * 16 + x, z, x, baseBlockNoise, chunkprimer, this, this.biomesForGeneration, biomeWeights, BiomeGenerator.EnumGeneratorPass.POST_GEN_CAVES);
            }
        }
        this.giantRootGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, chunkX, chunkZ);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 5, chunkZ * 4 - 5, 15, 15);
        this.generateHeightmap(chunkX * 4, 0, chunkZ * 4);
        for (int heightMapX = 0; heightMapX < 4; ++heightMapX) {
            int indexXC = heightMapX * 5;
            int indexXN = (heightMapX + 1) * 5;
            for (int heightMapZ = 0; heightMapZ < 4; ++heightMapZ) {
                int indexXCZC = (indexXC + heightMapZ) * 33;
                int indexXCZN = (indexXC + heightMapZ + 1) * 33;
                int indexXNZC = (indexXN + heightMapZ) * 33;
                int indexXNZN = (indexXN + heightMapZ + 1) * 33;
                for (int heightMapY = 0; heightMapY < 32; ++heightMapY) {
                    double valXCZCYC = this.heightMap[indexXCZC + heightMapY];
                    double valXCZNYC = this.heightMap[indexXCZN + heightMapY];
                    double valXNZCYC = this.heightMap[indexXNZC + heightMapY];
                    double valXNZNYC = this.heightMap[indexXNZN + heightMapY];
                    double valXCZCYN = this.heightMap[indexXCZC + heightMapY + 1];
                    double valXCZNYN = this.heightMap[indexXCZN + heightMapY + 1];
                    double valXNZCYN = this.heightMap[indexXNZC + heightMapY + 1];
                    double valXNZNYN = this.heightMap[indexXNZN + heightMapY + 1];
                    double stepYAxisXCZC = (valXCZCYN - valXCZCYC) * 0.125;
                    double stepYAxisXCZN = (valXCZNYN - valXCZNYC) * 0.125;
                    double stepYAxisXNZC = (valXNZCYN - valXNZCYC) * 0.125;
                    double stepYAxisXNZN = (valXNZNYN - valXNZNYC) * 0.125;
                    double currentValXCZCYC = valXCZCYC;
                    double currentValXCZNYC = valXCZNYC;
                    double currentValXNZCYC = valXNZCYC;
                    double currentValXNZNYC = valXNZNYC;
                    for (int blockY = 0; blockY < 8; ++blockY) {
                        double currentValXCZC = currentValXCZCYC;
                        double currentValXCZN = currentValXCZNYC;
                        double stepXAxisZC = (currentValXNZCYC - currentValXCZCYC) * 0.25;
                        double stepXAxisZN = (currentValXNZNYC - currentValXCZNYC) * 0.25;
                        for (int blockX = 0; blockX < 4; ++blockX) {
                            double stepZAxis = (currentValXCZN - currentValXCZC) * 0.25;
                            double currentValZC = currentValXCZC - stepZAxis;
                            for (int blockZ = 0; blockZ < 4; ++blockZ) {
                                double d;
                                currentValZC += stepZAxis;
                                if (d > 0.0) {
                                    primer.func_177855_a(heightMapX * 4 + blockX, heightMapY * 8 + blockY, heightMapZ * 4 + blockZ, this.baseBlockState);
                                    continue;
                                }
                                if (heightMapY * 8 + blockY > this.layerHeight) continue;
                                primer.func_177855_a(heightMapX * 4 + blockX, heightMapY * 8 + blockY, heightMapZ * 4 + blockZ, this.layerBlockState);
                            }
                            currentValXCZC += stepXAxisZC;
                            currentValXCZN += stepXAxisZN;
                        }
                        currentValXCZCYC += stepYAxisXCZC;
                        currentValXCZNYC += stepYAxisXCZN;
                        currentValXNZCYC += stepYAxisXNZC;
                        currentValXNZNYC += stepYAxisXNZN;
                    }
                }
            }
        }
    }

    private void generateHeightmap(int x, int y, int z) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, x, z, 5, 5, 200.0, 200.0, 0.5);
        float scaleXZ = 5475.296f;
        float scaleY = 5475.296f;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, x, y, z, 5, 33, 5, (double)(scaleXZ / 80.0f), (double)(scaleY / 160.0f), (double)(scaleXZ / 80.0f));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, x, y, z, 5, 33, 5, (double)scaleXZ, (double)scaleY, (double)scaleXZ);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, x, y, z, 5, 33, 5, (double)scaleXZ, (double)scaleY, (double)scaleXZ);
        int noiseIndex = 0;
        int heightMapIndex = 0;
        for (int heightMapX = 0; heightMapX < 5; ++heightMapX) {
            for (int heightMapZ = 0; heightMapZ < 5; ++heightMapZ) {
                float biomeVariation = 0.0f;
                float biomeDepth = 0.0f;
                float totalBiomeWeight = 0.0f;
                Biome centerBiome = this.biomesForGeneration[heightMapX + 5 + (heightMapZ + 5) * 15];
                float nearestOtherBiomeSq = 50.0f;
                for (int offsetX = -5; offsetX <= 5; ++offsetX) {
                    for (int offsetZ = -5; offsetZ <= 5; ++offsetZ) {
                        Biome nearbyBiome = this.biomesForGeneration[heightMapX + 5 + offsetX + (heightMapZ + 5 + offsetZ) * 15];
                        float nearbyBiomeDepth = nearbyBiome.func_185355_j();
                        float nearbyBiomeVariation = nearbyBiome.func_185360_m();
                        if (offsetX >= -2 && offsetX <= 2 && offsetZ >= -2 && offsetZ <= 2) {
                            float weight = this.biomeWeights[offsetX + 2 + (offsetZ + 2) * 5];
                            if (nearbyBiome.func_185355_j() > centerBiome.func_185355_j()) {
                                weight /= 2.0f;
                            }
                            biomeVariation += nearbyBiomeVariation * weight;
                            biomeDepth += nearbyBiomeDepth * weight;
                            totalBiomeWeight += weight;
                        }
                        float distWeighted = offsetX * offsetX + offsetZ * offsetZ;
                        if (nearbyBiome == centerBiome || !(distWeighted < nearestOtherBiomeSq)) continue;
                        nearestOtherBiomeSq = distWeighted;
                    }
                }
                this.terrainBiomeWeights[heightMapIndex] = MathHelper.func_76131_a((float)Math.max((nearestOtherBiomeSq - 2.0f) / 46.0f, 0.0f), (float)0.0f, (float)1.0f);
                biomeVariation /= totalBiomeWeight;
                biomeDepth /= totalBiomeWeight;
                double depthPerturbation = this.depthRegion[heightMapIndex] / 8000.0;
                if (depthPerturbation < 0.0) {
                    depthPerturbation = -depthPerturbation * 0.3;
                }
                if ((depthPerturbation = depthPerturbation * 3.0 - 2.0) < 0.0) {
                    if ((depthPerturbation /= 2.0) < -1.0) {
                        depthPerturbation = -1.0;
                    }
                    depthPerturbation /= 1.4;
                    depthPerturbation /= 2.0;
                } else {
                    if (depthPerturbation > 1.0) {
                        depthPerturbation = 1.0;
                    }
                    depthPerturbation /= 8.0;
                }
                ++heightMapIndex;
                for (int heightMapY = 0; heightMapY < 33; ++heightMapY) {
                    double densityOffset = ((double)heightMapY * 8.0 - (double)biomeDepth - depthPerturbation * (double)biomeVariation / 256.0) / 256.0;
                    double maxGenDensity16 = 32767.0;
                    double maxGenDensity8 = 127.0;
                    double minDensity = this.minLimitRegion[noiseIndex] / maxGenDensity16 * (double)biomeVariation / 256.0;
                    double maxDensity = this.maxLimitRegion[noiseIndex] / maxGenDensity16 * (double)biomeVariation / 256.0;
                    double mainDensity = this.mainNoiseRegion[noiseIndex] / maxGenDensity8;
                    this.heightMap[noiseIndex] = MathHelper.func_151238_b((double)minDensity, (double)maxDensity, (double)mainDensity) - densityOffset;
                    ++noiseIndex;
                }
            }
        }
    }

    public void replaceBiomeBlocks(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] biomesIn, BiomeWeights biomeWeights) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.worldObj)) {
            return;
        }
        this.surfaceNoiseBuffer = this.surfaceNoise.func_151599_a(this.surfaceNoiseBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
        ArrayList<BiomeGenerator> foundGenerators = new ArrayList<BiomeGenerator>();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                double baseBlockNoise = this.surfaceNoiseBuffer[z + x * 16];
                Biome biome = biomesIn[z + x * 16];
                if (biome instanceof BiomeBetweenlands) {
                    BiomeGenerator generator = ((BiomeBetweenlands)biome).getBiomeGenerator();
                    generator.initializeGenerators(this.seed);
                    generator.generateNoise(chunkZ, chunkX);
                    foundGenerators.add(generator);
                    generator.runBiomeFeatures(chunkZ * 16 + z, chunkX * 16 + x, z, x, baseBlockNoise, primer, this, biomesIn, biomeWeights, BiomeGenerator.EnumGeneratorPass.PRE_REPLACE_BIOME_BLOCKS);
                    generator.replaceBiomeBlocks(chunkZ * 16 + z, chunkX * 16 + x, z, x, baseBlockNoise, this.rand, this.seed, primer, this, biomesIn, biomeWeights);
                    generator.runBiomeFeatures(chunkZ * 16 + z, chunkX * 16 + x, z, x, baseBlockNoise, primer, this, biomesIn, biomeWeights, BiomeGenerator.EnumGeneratorPass.POST_REPLACE_BIOME_BLOCKS);
                    continue;
                }
                biome.func_180622_a(this.worldObj, this.rand, primer, chunkX * 16 + x, chunkZ * 16 + z, baseBlockNoise);
            }
        }
        for (BiomeGenerator gen : foundGenerators) {
            gen.resetNoise();
        }
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int bx = x * 16;
        int bz = z * 16;
        BlockPos blockPos = new BlockPos(bx, 0, bz);
        Biome biome = this.worldObj.func_180494_b(blockPos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long seedX = this.rand.nextLong() / 2L * 2L + 1L;
        long seedZ = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * seedX + (long)z * seedZ ^ this.worldObj.func_72905_C());
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)false);
        if (biome instanceof BiomeBetweenlands) {
            BiomeDecoratorBetweenlands decorator = ((BiomeBetweenlands)biome).getBiomeGenerator().getDecorator();
            if (decorator != null) {
                decorator.decorate(this.worldObj, this, this.rand, bx, bz);
            }
            if (this.worldObj instanceof WorldServer) {
                MobSpawnHandler.INSTANCE.populateChunk((WorldServer)this.worldObj, x, z);
                MobSpawnHandler.INSTANCE.populateChunk((WorldServer)this.worldObj, x + 1, z);
                MobSpawnHandler.INSTANCE.populateChunk((WorldServer)this.worldObj, x + 1, z + 1);
                MobSpawnHandler.INSTANCE.populateChunk((WorldServer)this.worldObj, x, z + 1);
            }
        } else {
            biome.func_180624_a(this.worldObj, this.rand, new BlockPos(bx, 0, bz));
            if (TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
                WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(bx + 8), (int)(bz + 8), (int)16, (int)16, (Random)this.rand);
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return ImmutableList.of();
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public double evalTreeNoise(double x, double z) {
        return this.treeNoise.func_151605_a(x, z);
    }

    public double evalSpeleothemDensityNoise(double x, double z) {
        return this.speleothemDensityNoise.func_151605_a(x, z);
    }

    private void debugProvideHandle(int x, int z) {
        if (!debugRecord) {
            return;
        }
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        boolean inside = false;
        int provides = 0;
        boolean player = false;
        int[] signature = new int[]{};
        StringBuilder[] signatureCauses = new StringBuilder[]{};
        int signatureIdx = -1;
        boolean newSignature = false;
        boolean lastOther = false;
        for (int i = 0; i < elems.length; ++i) {
            StackTraceElement elem = elems[i];
            String cls = elem.getClassName();
            String method = elem.getMethodName();
            boolean other = false;
            if ("net.minecraft.world.gen.ChunkProviderServer".equals(cls) && "provideChunk".equals(method)) {
                ++provides;
                inside = true;
                signature = Arrays.copyOf(signature, signature.length + 1);
                signatureCauses = Arrays.copyOf(signatureCauses, signature.length);
                signatureCauses[++signatureIdx] = new StringBuilder();
                newSignature = true;
                signatureCauses[signatureIdx].append("ChunkProviderServer#provideChunk\n");
            } else if (inside) {
                if ("net.minecraft.server.management.PlayerChunkMapEntry".equals(cls) && "providePlayerChunk".equals(method)) {
                    player = true;
                } else if (cls.startsWith("thebetweenlands")) {
                    int dot = cls.lastIndexOf(46);
                    if (dot > -1) {
                        signatureCauses[signatureIdx].append(cls);
                    } else {
                        signatureCauses[signatureIdx].append(cls.substring(dot + 1));
                    }
                    signatureCauses[signatureIdx].append('#').append(method).append(':').append(elem.getLineNumber()).append("\n");
                    signature[signatureIdx] = ((signature[signatureIdx] * 31 + cls.hashCode()) * 31 + method.hashCode()) * 31 + elem.getLineNumber();
                    newSignature = false;
                } else {
                    if (!lastOther) {
                        signatureCauses[signatureIdx].append("...\n");
                    }
                    other = true;
                }
            }
            lastOther = other;
        }
        if (newSignature) {
            signature = Arrays.copyOfRange(signature, 0, signature.length - 1);
        }
        if (signature.length > this.maxSigLen) {
            this.maxSigLen = signature.length;
        }
        if (provides > this.maxProvides) {
            this.maxProvides = provides;
        }
        String[] causes = new String[signatureCauses.length];
        for (int i = 0; i < signatureCauses.length; ++i) {
            causes[i] = signatureCauses[i].toString();
        }
        this.chunkProvides.add(new ChunkProvide(x, z, player, provides, causes, signature));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugGenerateChunkProvidesImage(boolean open) {
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        Set<ChunkProvide> set = this.chunkProvides;
        synchronized (set) {
            for (ChunkProvide p : this.chunkProvides) {
                if (p.x < minX) {
                    minX = p.x;
                }
                if (p.z < minZ) {
                    minZ = p.z;
                }
                if (p.x > maxX) {
                    maxX = p.x;
                }
                if (p.z <= maxZ) continue;
                maxZ = p.z;
            }
        }
        int half = (int)Math.ceil(Math.sqrt((double)this.maxSigLen / 2.0));
        int tile = 2 * half;
        int pad = 1;
        int unit = tile + pad;
        BufferedImage img = new BufferedImage((maxX - minX + 1) * unit + pad, (maxZ - minZ + 1) * unit + pad, 1);
        Graphics2D g = img.createGraphics();
        HashMultimap byCause = HashMultimap.create();
        HashSet<String> printed = new HashSet<String>();
        Set<ChunkProvide> set2 = this.chunkProvides;
        synchronized (set2) {
            for (ChunkProvide p : this.chunkProvides) {
                byCause.put((Object)p.cause[0], (Object)p);
                int px = (p.x - minX) * unit + pad;
                int pz = (p.z - minZ) * unit + pad;
                g.setColor(Color.LIGHT_GRAY);
                g.fillRect(px, pz, tile, tile);
                if (p.player) {
                    g.setColor(Color.WHITE);
                } else {
                    g.setColor(Color.MAGENTA);
                }
                g.fillRect(px, pz, half, half);
                g.setColor(new Color(Color.HSBtoRGB((1.0f - (float)(p.provides - 1) / (float)this.maxProvides) * 0.333f, 1.0f, 1.0f)));
                g.fillRect(px, pz + half, half, half);
                int i = 0;
                int j = p.signature.length - 1;
                while (i < p.signature.length) {
                    int color = p.signature[j];
                    g.setColor(new Color(color));
                    g.fillRect(px + half + i % half, pz + i / half, 1, 1);
                    if (printed.add(p.cause[i])) {
                        TheBetweenlands.logger.debug("#%s:%n%s%n", (Object)Integer.toHexString(color | 0xFF000000).substring(2), (Object)p.cause[i]);
                    }
                    ++i;
                    --j;
                }
            }
        }
        ArrayList sortedCauses = new ArrayList(byCause.keySet());
        sortedCauses.sort((arg_0, arg_1) -> ChunkGeneratorBetweenlands.lambda$debugGenerateChunkProvidesImage$0((Multimap)byCause, arg_0, arg_1));
        for (String cause : sortedCauses) {
            int c = byCause.get((Object)cause).size();
            if (c <= 2) continue;
            TheBetweenlands.logger.debug("%d caused by:%n%s%n", (Object)c, (Object)cause);
        }
        g.dispose();
        File out = new File(Minecraft.func_71410_x().field_71412_D, "chunk_provides.png");
        try {
            ImageIO.write((RenderedImage)img, "png", out);
            Desktop.getDesktop().edit(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void debugProvideReset() {
        this.chunkProvides.clear();
        this.maxSigLen = 0;
        this.maxProvides = 0;
    }

    private static /* synthetic */ int lambda$debugGenerateChunkProvidesImage$0(Multimap byCause, String s1, String s2) {
        return byCause.get((Object)s2).size() - byCause.get((Object)s1).size();
    }

    private static class ChunkProvide {
        int x;
        int z;
        boolean player;
        int provides;
        String[] cause;
        int[] signature;

        public ChunkProvide(int x, int z, boolean player, int provides, String[] cause, int[] signature) {
            this.x = x;
            this.z = z;
            this.player = player;
            this.provides = provides;
            this.cause = cause;
            this.signature = signature;
        }

        public int hashCode() {
            return this.x * 31 + this.z;
        }

        public boolean equals(Object obj) {
            return obj instanceof ChunkProvide && ((ChunkProvide)obj).x == this.x && ((ChunkProvide)obj).z == this.z;
        }
    }
}

