/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Random;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.world.World;
import thebetweenlands.common.network.datamanager.GenericDataManager;
import thebetweenlands.common.world.event.BLEnvironmentEvent;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;

public abstract class TimedEnvironmentEvent
extends BLEnvironmentEvent {
    protected static final DataParameter<Integer> TICKS = GenericDataManager.createKey(TimedEnvironmentEvent.class, DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> START_TICKS = GenericDataManager.createKey(TimedEnvironmentEvent.class, DataSerializers.field_187192_b);

    public TimedEnvironmentEvent(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    protected void initDataParameters() {
        super.initDataParameters();
        this.dataManager.register(TICKS, 20, 0);
        this.dataManager.register(START_TICKS, 0);
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (!this.getRegistry().isDisabled() && !this.isCurrentStateFromRemote()) {
            if (this.isActive() || this.canActivate()) {
                this.dataManager.set(TICKS, this.getTicks() - 1);
            }
            if (!world.field_72995_K && this.getTicks() <= 0) {
                if (this.isActive()) {
                    int offTime = this.getOffTime(world.field_73012_v);
                    this.dataManager.set(TICKS, offTime).syncImmediately();
                    this.dataManager.set(START_TICKS, offTime);
                } else {
                    int onTime = this.getOnTime(world.field_73012_v);
                    this.dataManager.set(TICKS, onTime).syncImmediately();
                    this.dataManager.set(START_TICKS, onTime);
                }
                if (this.isActive() || this.canActivate()) {
                    this.setActive(!this.isActive());
                }
            }
        }
    }

    protected boolean canActivate() {
        return true;
    }

    public void setTicks(int ticks) {
        int currTicks = this.getTicks();
        int diff = ticks - currTicks;
        this.dataManager.set(TICKS, currTicks + diff);
        this.dataManager.set(START_TICKS, Math.max(this.getStartTicks() + diff, 0));
    }

    public int getTicks() {
        return this.dataManager.get(TICKS);
    }

    public int getStartTicks() {
        return this.dataManager.get(START_TICKS);
    }

    public int getTicksElapsed() {
        return this.getStartTicks() - this.getTicks();
    }

    @Override
    public void setActive(boolean active) {
        if (!active || this.canActivate()) {
            super.setActive(active);
            if (!this.getWorld().field_72995_K) {
                if (!this.isActive()) {
                    int offTime = this.getOffTime(this.getWorld().field_73012_v);
                    this.dataManager.set(TICKS, offTime).syncImmediately();
                    this.dataManager.set(START_TICKS, offTime);
                } else {
                    int onTime = this.getOnTime(this.getWorld().field_73012_v);
                    this.dataManager.set(TICKS, onTime).syncImmediately();
                    this.dataManager.set(START_TICKS, onTime);
                }
            }
        }
    }

    @Override
    public void saveEventData() {
        super.saveEventData();
        this.getData().func_74768_a("ticks", this.getTicks());
        this.getData().func_74768_a("startTicks", this.getStartTicks());
    }

    @Override
    public void loadEventData() {
        super.loadEventData();
        this.dataManager.set(TICKS, this.getData().func_74762_e("ticks")).syncImmediately();
        this.dataManager.set(START_TICKS, this.getData().func_74762_e("startTicks"));
    }

    @Override
    public void setDefaults() {
        this.dataManager.set(TICKS, this.getOffTime(new Random()));
    }

    public abstract int getOffTime(Random var1);

    public abstract int getOnTime(Random var1);
}

