/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import thebetweenlands.api.environment.IEnvironmentEvent;
import thebetweenlands.api.environment.IEnvironmentEventRegistry;
import thebetweenlands.api.event.InitializeEnvironmentEventsEvent;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.EventAuroras;
import thebetweenlands.common.world.event.EventBloodSky;
import thebetweenlands.common.world.event.EventDenseFog;
import thebetweenlands.common.world.event.EventHeavyRain;
import thebetweenlands.common.world.event.EventRift;
import thebetweenlands.common.world.event.EventSnowfall;
import thebetweenlands.common.world.event.EventSpoopy;
import thebetweenlands.common.world.event.EventThunderstorm;
import thebetweenlands.common.world.event.EventWinter;

public class BLEnvironmentEventRegistry
implements IEnvironmentEventRegistry {
    public final EventDenseFog denseFog;
    public final IEnvironmentEvent heavyRain;
    public final EventAuroras auroras;
    public final EventBloodSky bloodSky;
    public final EventSpoopy spoopy;
    public final EventWinter winter;
    public final EventSnowfall snowfall;
    public final EventThunderstorm thunderstorm;
    public final EventRift rift;
    private World world;
    private final Map<ResourceLocation, IEnvironmentEvent> registeredEvents = new HashMap<ResourceLocation, IEnvironmentEvent>();
    private boolean disabled = false;

    public BLEnvironmentEventRegistry(World world) {
        this.world = world;
        this.denseFog = new EventDenseFog(this);
        this.heavyRain = new EventHeavyRain(this);
        this.auroras = new EventAuroras(this);
        this.bloodSky = new EventBloodSky(this);
        this.spoopy = new EventSpoopy(this);
        this.winter = new EventWinter(this);
        this.snowfall = new EventSnowfall(this);
        this.thunderstorm = new EventThunderstorm(this);
        this.rift = new EventRift(this);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    public void init() {
        if (this.world.field_73011_w instanceof WorldProviderBetweenlands) {
            this.register(this.denseFog);
            this.register(this.heavyRain);
            this.register(this.auroras);
            this.register(this.bloodSky);
            this.register(this.spoopy);
            this.register(this.winter);
            this.register(this.snowfall);
            this.register(this.thunderstorm);
            this.register(this.rift);
        }
        MinecraftForge.EVENT_BUS.post((Event)new InitializeEnvironmentEventsEvent(this));
    }

    @Override
    public void register(IEnvironmentEvent event) {
        if (this.registeredEvents.containsKey(event.getEventName())) {
            throw new RuntimeException("Duplicate environment event name: " + event.getEventName());
        }
        if (event.getRegistry() != this) {
            throw new RuntimeException(String.format("Environment event %s is already registered in another registry: %s", event.getEventName(), this));
        }
        this.registeredEvents.put(event.getEventName(), event);
    }

    @Override
    public IEnvironmentEvent unregister(IEnvironmentEvent event) {
        return this.registeredEvents.remove(event.getEventName());
    }

    @Override
    public Map<ResourceLocation, IEnvironmentEvent> getEvents() {
        return Collections.unmodifiableMap(this.registeredEvents);
    }

    public IEnvironmentEvent forName(ResourceLocation eventName) {
        return this.registeredEvents.get(eventName);
    }

    public List<IEnvironmentEvent> getActiveEvents() {
        return this.getEventsOfState(true);
    }

    @Override
    public List<IEnvironmentEvent> getEventsOfState(boolean isActive) {
        ArrayList<IEnvironmentEvent> list = new ArrayList<IEnvironmentEvent>();
        for (IEnvironmentEvent event : this.registeredEvents.values()) {
            if (event.isActive() != isActive) continue;
            list.add(event);
        }
        return list;
    }

    @Override
    public List<IEnvironmentEvent> getEventsOfStateAt(double x, double y, double z, boolean active) {
        ArrayList<IEnvironmentEvent> list = new ArrayList<IEnvironmentEvent>();
        for (IEnvironmentEvent event : this.getEvents().values()) {
            if (event.isActiveAt(x, y, z) != active) continue;
            list.add(event);
        }
        return list;
    }

    public List<ResourceLocation> getEventNames() {
        ArrayList<ResourceLocation> eventNames = new ArrayList<ResourceLocation>();
        for (IEnvironmentEvent event : this.registeredEvents.values()) {
            eventNames.add(event.getEventName());
        }
        return eventNames;
    }

    public List<ResourceLocation> getEventNamesOfState(boolean isActive) {
        ArrayList<ResourceLocation> eventNames = new ArrayList<ResourceLocation>();
        for (IEnvironmentEvent event : this.registeredEvents.values()) {
            if (event.isActive() != isActive) continue;
            eventNames.add(event.getEventName());
        }
        return eventNames;
    }

    public String getGrammaticalActiveEventNameList() {
        StringBuilder list = new StringBuilder();
        IEnvironmentEvent[] events = this.registeredEvents.values().toArray(new IEnvironmentEvent[0]);
        for (int i = 0; i < events.length; ++i) {
            ResourceLocation eventName = events[i].getEventName();
            if (i > 0) {
                list.append(", ");
                if (i == events.length - 1) {
                    list.append("and ");
                }
            }
            list.append(eventName);
        }
        return list.toString();
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void enable() {
        this.disabled = false;
    }

    public void disable() {
        this.disabled = true;
    }

    @Override
    public boolean isEnabled() {
        return !this.disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean setEnabled(boolean enabled) {
        this.disabled = !enabled;
        return this.disabled;
    }

    @Override
    public IEnvironmentEvent getEvent(ResourceLocation eventId) {
        return this.registeredEvents.get(eventId);
    }

    @Override
    public boolean isEventActive(ResourceLocation eventId) {
        IEnvironmentEvent event = this.getEvent(eventId);
        return event != null && event.isActive();
    }

    @Override
    public boolean isEventActiveAt(double x, double y, double z, ResourceLocation eventId) {
        IEnvironmentEvent event = this.getEvent(eventId);
        return event != null && event.isActiveAt(x, y, z);
    }
}

