/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.common.entity.mobs.EntityAngler;
import thebetweenlands.common.entity.mobs.EntityBlindCaveFish;
import thebetweenlands.common.entity.mobs.EntityBoulderSprite;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityDragonFly;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.entity.mobs.EntityFrog;
import thebetweenlands.common.entity.mobs.EntityGecko;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.entity.mobs.EntityRootSprite;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.biome.spawning.spawners.BetweenstoneCaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.GreeblingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SporelingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SwampHagCaveSpawnEntry;
import thebetweenlands.common.world.gen.biome.decorator.BiomeDecoratorCoarseIslands;
import thebetweenlands.common.world.gen.biome.feature.AlgaeFeature;
import thebetweenlands.common.world.gen.biome.feature.CoarseIslandsFeature;

public class BiomeCoarseIslands
extends BiomeBetweenlands {
    public BiomeCoarseIslands() {
        super(new ResourceLocation("thebetweenlands", "coarse_islands"), new Biome.BiomeProperties("Coarse Islands").func_185398_c(115.0f).func_185400_d(4.0f).func_185402_a(1784132).func_185410_a(0.8f).func_185395_b(0.9f));
        this.setWeight(16);
        this.getBiomeGenerator().setDecorator(new BiomeDecoratorCoarseIslands(this)).addFeature(new CoarseIslandsFeature()).addFeature(new AlgaeFeature());
        this.setFoliageColors(-1, 0xA8A800);
        this.setSecondaryFoliageColors(-1, 11040768);
    }

    @Override
    public void addTypes() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }

    @Override
    protected void addSpawnEntries(List<ICustomSpawnEntry> entries) {
        super.addSpawnEntries(entries);
        entries.add(new SurfaceSpawnEntry(0, EntityDragonFly.class, 36).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(64.0).setSpawningInterval(400));
        entries.add(new SurfaceSpawnEntry(1, EntityFirefly.class, 60).setCanSpawnOnWater(true).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(2, EntityGecko.class, 52).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(600));
        entries.add(new SurfaceSpawnEntry(3, EntityFrog.class, 30).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(100));
        entries.add(new CaveSpawnEntry(4, EntityBlindCaveFish.class, 30).setCanSpawnInWater(true).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        entries.add(new SporelingSpawnEntry(5, EntitySporeling.class, 80).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        entries.add(new SurfaceSpawnEntry(16, EntityRootSprite.class, 70).setSurfacePredicate((Predicate<IBlockState>)((Predicate)state -> state.func_177230_c() == BlockRegistry.GIANT_ROOT)).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(200));
        entries.add(new GreeblingSpawnEntry(17, 20).setGroupSize(1, 3).setSpawnCheckRadius(64.0).setGroupSpawnRadius(4.0).setSpawningInterval(24000));
        entries.add(new SurfaceSpawnEntry(6, EntityLurker.class, 32).setCanSpawnInWater(true).setHostile(true).setSpawnCheckRadius(16.0));
        entries.add(new SurfaceSpawnEntry(7, EntityAngler.class, 42).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        entries.add(new CaveSpawnEntry(8, EntityAngler.class, 45).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        entries.add(new SurfaceSpawnEntry(9, EntitySwampHag.class, 100).setHostile(true));
        entries.add(new SwampHagCaveSpawnEntry(10, 120).setHostile(true).setSpawnCheckRadius(24.0).setGroupSize(1, 3));
        entries.add(new SurfaceSpawnEntry(11, EntityWight.class, 8).setHostile(true).setSpawnCheckRadius(64.0).setSpawnCheckRangeY(16.0).setSpawningInterval(6000));
        entries.add(new CaveSpawnEntry(12, EntityWight.class, 20).setHostile(true).setSpawnCheckRadius(64.0));
        entries.add(new SurfaceSpawnEntry(13, EntityChiromaw.class, 40).setHostile(true).setSpawnCheckRadius(30.0));
        entries.add(new CaveSpawnEntry(14, EntityChiromaw.class, 60).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
        entries.add(new BetweenstoneCaveSpawnEntry(15, EntityBoulderSprite.class, 60).setHostile(true).setSpawnCheckRadius(16.0).setSpawnCheckRangeY(8.0));
    }
}

